/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.arith.Comparator;
import com.cburch.logisim.std.arith.ComparatorHdlGeneratorFactory;
import com.cburch.logisim.util.LineBuffer;

public class DividerHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NR_OF_BITS_STRING = "nrOfBits";
    private static final int NR_OF_BITS_ID = -1;
    private static final String CALC_BITS_STRING = "calcBits";
    private static final int CALC_BITS_ID = -2;
    private static final String UNSIGNED_STRING = "unsignedDivider";
    private static final int UNSIGNED_ID = -3;

    public DividerHdlGeneratorFactory() {
        this.myParametersList.add(NR_OF_BITS_STRING, -1).add(CALC_BITS_STRING, -2, 3, 2).add(UNSIGNED_STRING, -3, 4, Comparator.MODE_ATTR, ComparatorHdlGeneratorFactory.SIGNED_MAP);
        this.myWires.addWire("s_divResult", -2).addWire("s_modResult", -1).addWire("s_extendedDividend", -2);
        this.myPorts.add("input", "inputA", -1, 0).add("input", "inputB", -1, 1).add("input", "upper", -1, 3).add("output", "quotient", -1, 2).add("output", "remainder", -1, 4);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer().pair(NR_OF_BITS_STRING, NR_OF_BITS_STRING).pair("unsigned", UNSIGNED_STRING).pair(CALC_BITS_STRING, CALC_BITS_STRING);
        if (Hdl.isVhdl()) {
            contents.empty().addVhdlKeywords().add("s_extendedDividend({{calcBits}}-1 {{downto}} {{nrOfBits}}) <= upper;\ns_extendedDividend({{nrOfBits}}-1 {{downto}} 0) <= inputA;\ns_divResult <= std_logic_vector(unsigned(s_extendedDividend) / unsigned(inputB))\n                   {{when}} {{unsigned}} = 1 {{else}}\n                std_logic_vector(signed(s_extendedDividend) / signed(inputB));\ns_modResult <= std_logic_vector(unsigned(s_extendedDividend) {{mod}} unsigned(inputB))\n                   {{when}} {{unsigned}} = 1 {{else}}\n                std_logic_vector(signed(s_extendedDividend) {{mod}} signed(inputB));\nquotient  <= s_divResult({{nrOfBits}}-1 {{downto}} 0);\nremainder <= s_modResult({{nrOfBits}}-1 {{downto}} 0);\n");
        }
        return contents.empty();
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        return Hdl.isVhdl();
    }
}

