/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class FpAdder
extends InstanceFactory {
    public static final String _ID = "FPAdder";
    static final int PER_DELAY = 1;
    private static final int IN0 = 0;
    private static final int IN1 = 1;
    private static final int OUT = 2;
    private static final int ERR = 3;

    public FpAdder() {
        super(_ID, Strings.S.getter("fpAdderComponent"));
        this.setAttributes(new Attribute[]{StdAttr.FP_WIDTH}, new Object[]{BitWidth.create(32)});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.FP_WIDTH));
        this.setOffsetBounds(Bounds.create(-40, -20, 40, 40));
        this.setIcon(new ArithmeticIcon("+"));
        Port[] ps = new Port[]{new Port(-40, -10, "input", StdAttr.FP_WIDTH), new Port(-40, 10, "input", StdAttr.FP_WIDTH), new Port(0, 0, "output", StdAttr.FP_WIDTH), new Port(-20, 20, "output", 1)};
        ps[0].setToolTip(Strings.S.getter("adderInputTip"));
        ps[1].setToolTip(Strings.S.getter("adderInputTip"));
        ps[2].setToolTip(Strings.S.getter("fpAdderOutputTip"));
        ps[3].setToolTip(Strings.S.getter("fpErrorTip"));
        this.setPorts(ps);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawBounds();
        g.setColor(new Color(AppPreferences.COMPONENT_SECONDARY_COLOR.get()));
        painter.drawPort(0);
        painter.drawPort(1);
        painter.drawPort(2);
        painter.drawPort(3);
        Location loc = painter.getLocation();
        int x = loc.getX();
        int y = loc.getY();
        GraphicsUtil.switchToWidth(g, 2);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        g.drawLine(x - 15, y, x - 5, y);
        g.drawLine(x - 10, y - 5, x - 10, y + 5);
        g.drawLine(x - 35, y - 15, x - 35, y + 5);
        g.drawLine(x - 35, y - 15, x - 25, y - 15);
        g.drawLine(x - 35, y - 5, x - 25, y - 5);
        GraphicsUtil.switchToWidth(g, 1);
    }

    @Override
    public void propagate(InstanceState state) {
        BitWidth dataWidth = state.getAttributeValue(StdAttr.FP_WIDTH);
        Value a = state.getPortValue(0);
        Value b = state.getPortValue(1);
        double a_val = switch (dataWidth.getWidth()) {
            case 16 -> a.toFloatValueFromFP16();
            case 32 -> a.toFloatValue();
            case 64 -> a.toDoubleValue();
            default -> Double.NaN;
        };
        double b_val = switch (dataWidth.getWidth()) {
            case 16 -> b.toFloatValueFromFP16();
            case 32 -> b.toFloatValue();
            case 64 -> b.toDoubleValue();
            default -> Double.NaN;
        };
        double out_val = a_val + b_val;
        Value out = switch (dataWidth.getWidth()) {
            case 16 -> Value.createKnown(16, (long)Float.floatToFloat16((float)out_val));
            case 32 -> Value.createKnown((float)out_val);
            case 64 -> Value.createKnown(out_val);
            default -> Value.ERROR;
        };
        int delay = (dataWidth.getWidth() + 2) * 1;
        state.setPort(2, out, delay);
        state.setPort(3, Value.createKnown(BitWidth.create(1), Double.isNaN(out_val) ? 1L : 0L), delay);
    }
}

