/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.arith;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import java.awt.Color;
import java.awt.Graphics;

public class FpToInt
extends InstanceFactory {
    public static final String _ID = "FPToInt";
    public static final AttributeOption CEILING_OPTION = new AttributeOption("ceil", "ceil", Strings.S.getter("ceilOption"));
    public static final AttributeOption FLOOR_OPTION = new AttributeOption("floor", "floor", Strings.S.getter("floorOption"));
    public static final AttributeOption ROUND_OPTION = new AttributeOption("round", "round", Strings.S.getter("roundOption"));
    public static final AttributeOption TRUNCATE_OPTION = new AttributeOption("truncate", "truncate", Strings.S.getter("truncateOption"));
    public static final Attribute<AttributeOption> MODE_ATTRIBUTE = Attributes.forOption("mode", Strings.S.getter("fpToIntType"), new AttributeOption[]{CEILING_OPTION, FLOOR_OPTION, ROUND_OPTION, TRUNCATE_OPTION});
    static final int PER_DELAY = 1;
    private static final int IN = 0;
    private static final int OUT = 1;
    private static final int ERR = 2;

    public FpToInt() {
        super(_ID, Strings.S.getter("fpToIntComponent"));
        this.setAttributes(new Attribute[]{StdAttr.WIDTH, StdAttr.FP_WIDTH, MODE_ATTRIBUTE}, new Object[]{BitWidth.create(8), BitWidth.create(32), ROUND_OPTION});
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.FP_WIDTH));
        this.setOffsetBounds(Bounds.create(-40, -20, 40, 40));
        this.setIcon(new ArithmeticIcon("FP\u2192I", 2));
        Port[] ps = new Port[]{new Port(-40, 0, "input", StdAttr.FP_WIDTH), new Port(0, 0, "output", StdAttr.WIDTH), new Port(-20, 20, "output", 1)};
        ps[0].setToolTip(Strings.S.getter("fpToIntInputTip"));
        ps[1].setToolTip(Strings.S.getter("fpToIntOutputTip"));
        ps[2].setToolTip(Strings.S.getter("fpErrorTip"));
        this.setPorts(ps);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawBounds();
        painter.drawPort(0);
        painter.drawPort(1, "F\u2192I", Direction.WEST);
        painter.drawPort(2);
    }

    @Override
    public void propagate(InstanceState state) {
        double a_val;
        BitWidth dataWidthIn = state.getAttributeValue(StdAttr.FP_WIDTH);
        BitWidth dataWidthOut = state.getAttributeValue(StdAttr.WIDTH);
        AttributeOption roundMode = state.getAttributeValue(MODE_ATTRIBUTE);
        Value a = state.getPortValue(0);
        switch (dataWidthIn.getWidth()) {
            case 16: {
                double d = a.toFloatValueFromFP16();
                break;
            }
            case 32: {
                double d = a.toFloatValue();
                break;
            }
            case 64: {
                double d = a.toDoubleValue();
                break;
            }
            default: {
                double d = a_val = Double.NaN;
            }
        }
        long out_val = roundMode.getValue().equals("ceil") ? (long)Math.ceil(a_val) : (roundMode.getValue().equals("floor") ? (long)Math.floor(a_val) : (roundMode.getValue().equals("round") ? Math.round(a_val) : (long)a_val));
        Value out = Value.createKnown(dataWidthOut, out_val);
        int delay = (dataWidthOut.getWidth() + 2) * 1;
        state.setPort(1, out, delay);
        state.setPort(2, Value.createKnown(BitWidth.create(1), Double.isNaN(a_val) ? 1L : 0L), delay);
    }
}

