/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.file.Loader;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.util.JFileChoosers;
import com.cburch.logisim.util.JInputDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class PlaTable {
    private final ArrayList<Row> rows = new ArrayList();
    private int inSize;
    private int outSize;
    private String label = "";
    private static final Parser[] parsers = new Parser[]{new CompactParser(), new FlexibleParser()};
    private static final char ONE = '1';
    private static final char ZERO = '0';
    private static final char DONTCARE = 'x';

    public PlaTable(int inSz, int outSz, String l) {
        this.inSize = inSz;
        this.outSize = outSz;
        this.label = l;
    }

    public PlaTable(PlaTable other) {
        this(other.inSize, other.outSize, other.label);
        this.copyFrom(other);
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public List<Row> rows() {
        return this.rows;
    }

    public void copyFrom(PlaTable other) {
        this.rows.clear();
        this.inSize = other.inSize;
        this.outSize = other.outSize;
        for (Row otherRow : other.rows) {
            Row r = this.addTableRow();
            r.copyFrom(otherRow);
        }
    }

    public void resize(int newInSize, int newOutSize) {
        this.inSize = newInSize;
        this.outSize = newOutSize;
        for (Row r : this.rows) {
            r.truncate(this.inSize, this.outSize);
        }
    }

    public int inSize() {
        return this.inSize;
    }

    public int outSize() {
        return this.outSize;
    }

    public void setInSize(int sz) {
        this.resize(sz, this.outSize);
    }

    public void setOutSize(int sz) {
        this.resize(this.inSize, sz);
    }

    public Row addTableRow() {
        Row r = new Row(this.inSize, this.outSize);
        this.rows.add(r);
        return r;
    }

    public void deleteTableRow(Row row) {
        this.rows.remove(row);
    }

    public String toString() {
        return this.toStandardString();
    }

    public String toStandardString() {
        StringBuilder ret = new StringBuilder();
        for (Row r : this.rows) {
            ret.append(r.toStandardString()).append("\n");
        }
        return ret.toString();
    }

    private static PlaTable parseOneLine(PlaTable tt, String line) throws IOException {
        for (Parser parser : parsers) {
            if (!parser.canParse(line)) continue;
            return parser.parse(tt, line);
        }
        return tt;
    }

    public static PlaTable parse(String str) {
        PlaTable tt = null;
        for (String line : str.split("\n")) {
            try {
                tt = PlaTable.parseOneLine(tt, line);
            }
            catch (IOException e) {
                OptionPane.showMessageDialog(null, e.getMessage(), Strings.S.get("plaTableError"), 0);
            }
        }
        if (tt == null) {
            tt = new PlaTable(2, 2, "PLA");
        }
        return tt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlaTable parse(File src) throws IOException {
        BufferedReader in;
        try {
            in = new BufferedReader(new FileReader(src));
        }
        catch (IOException e) {
            throw new IOException(Strings.S.get("plaFileOpenError"));
        }
        PlaTable tt = null;
        try {
            String line = in.readLine();
            while (line != null) {
                tt = PlaTable.parseOneLine(tt, line);
                line = in.readLine();
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (tt == null) {
            throw new IOException(Strings.S.get("plaFileIoException"));
        }
        return tt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File dst) throws IOException {
        FileWriter out;
        try {
            out = new FileWriter(dst);
        }
        catch (IOException e) {
            throw new IOException(Strings.S.get("plaFileCreateError"));
        }
        try {
            out.write("# Logisim PLA program table\n");
            out.write(this.toStandardString());
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public long valueFor(long input) {
        for (Row row : this.rows) {
            if (!row.matches(input)) continue;
            return row.getOutput();
        }
        return 0L;
    }

    public String commentFor(long input) {
        for (Row row : this.rows) {
            if (!row.matches(input)) continue;
            return row.comment;
        }
        return "n/a";
    }

    public static class Row {
        public char[] inBits;
        public char[] outBits;
        private String comment = "";

        public Row(int inSize, int outSize) {
            int i;
            this.inBits = new char[inSize];
            this.outBits = new char[outSize];
            for (i = 0; i < inSize; ++i) {
                this.inBits[i] = 48;
            }
            for (i = 0; i < outSize; ++i) {
                this.outBits[i] = 48;
            }
        }

        public void copyFrom(Row other) {
            System.arraycopy(other.inBits, 0, this.inBits, 0, this.inBits.length);
            System.arraycopy(other.outBits, 0, this.outBits, 0, this.outBits.length);
            this.comment = other.comment;
        }

        public char changeInBit(int i) {
            this.inBits[i] = this.inBits[i] == '0' ? 49 : (this.inBits[i] == '1' ? 120 : 48);
            return this.inBits[i];
        }

        public char changeOutBit(int i) {
            if (this.outBits[i] == '0') {
                this.outBits[i] = 49;
            } else if (this.outBits[i] == '1') {
                this.outBits[i] = 48;
            }
            return this.outBits[i];
        }

        void truncate(int newInSize, int newOutSize) {
            this.inBits = Row.truncate(this.inBits, newInSize);
            this.outBits = Row.truncate(this.outBits, newOutSize);
        }

        static char[] truncate(char[] b, int n) {
            int i;
            if (b.length == n) {
                return b;
            }
            char[] a = new char[n];
            for (i = 0; i < n && i < b.length; ++i) {
                a[i] = b[i];
            }
            for (i = b.length; i < n; ++i) {
                a[i] = 48;
            }
            return a;
        }

        public String toString() {
            return this.toStandardString();
        }

        public String toStandardString() {
            StringBuilder i = new StringBuilder();
            for (char inBit : this.inBits) {
                i.insert(0, inBit);
            }
            StringBuilder o = new StringBuilder();
            for (char outBit : this.outBits) {
                o.insert(0, outBit);
            }
            String ret = String.valueOf(i) + " " + String.valueOf(o);
            if (!this.comment.trim().equals("")) {
                ret = ret + " # " + this.comment.trim();
            }
            return ret;
        }

        boolean matches(long input) {
            for (char bit : this.inBits) {
                long b = input & 1L;
                if (bit == '1' && b != 1L || bit == '0' && b != 0L) {
                    return false;
                }
                input >>= 1;
            }
            return true;
        }

        long getOutput() {
            long out = 0L;
            long bit = 1L;
            for (char c : this.outBits) {
                if (c == '1') {
                    out |= bit;
                }
                bit <<= 1;
            }
            return out;
        }
    }

    private static abstract class Parser {
        private Parser() {
        }

        private String comment(String line) {
            int separatorIndex = line.indexOf("#");
            return separatorIndex >= 0 ? line.substring(separatorIndex + 1).trim() : "";
        }

        protected String inputsOutputs(String line) {
            int separatorIndex = line.indexOf("#");
            return separatorIndex >= 0 ? line.substring(0, separatorIndex).trim() : line;
        }

        private static char[] toLogicArray(String line, String errorKey) throws IOException {
            char[] arr;
            for (char ch : arr = new StringBuffer(line).reverse().toString().toCharArray()) {
                if (ch == '1' || ch == '0' || ch == 'x') continue;
                throw new IOException(Strings.S.get(errorKey, line, "" + ch));
            }
            return arr;
        }

        public PlaTable parse(PlaTable tt, String line) throws IOException {
            boolean isCommentLine;
            String andBits = this.inputs(line);
            String orBits = this.outputs(line);
            boolean bl = isCommentLine = andBits.isEmpty() && orBits.isEmpty();
            if (isCommentLine) {
                return tt;
            }
            if (tt == null) {
                tt = new PlaTable(andBits.length(), orBits.length(), "PLA");
            } else {
                if (andBits.length() != tt.inSize) {
                    throw new IOException(Strings.S.get("plaRowExactInBitError", line, "" + tt.inSize));
                }
                if (orBits.length() != tt.outSize) {
                    throw new IOException(Strings.S.get("plaRowExactOutBitError", line, "" + tt.outSize));
                }
            }
            Row r = tt.addTableRow();
            r.inBits = Parser.toLogicArray(andBits, "plaInvalidInputBitError");
            r.outBits = Parser.toLogicArray(orBits, "plaInvalidOutputBitError");
            r.comment = this.comment(line);
            return tt;
        }

        protected abstract String inputs(String var1);

        protected abstract String outputs(String var1);

        protected abstract boolean canParse(String var1);
    }

    private static class CompactParser
    extends Parser {
        private CompactParser() {
        }

        @Override
        protected String inputs(String line) {
            String io = this.inputsOutputs(line);
            int separatorIndex = io.indexOf(" ");
            return separatorIndex >= 0 ? io.substring(0, separatorIndex).trim() : "";
        }

        @Override
        protected String outputs(String line) {
            String io = this.inputsOutputs(line);
            int separatorIndex = io.indexOf(" ");
            return separatorIndex >= 0 ? io.substring(separatorIndex + 1).trim() : "";
        }

        @Override
        protected boolean canParse(String line) {
            String io = this.inputsOutputs(line);
            return io.matches("[01]+\\s+[01]+");
        }
    }

    private static class FlexibleParser
    extends Parser {
        private FlexibleParser() {
        }

        private static String stripSeparators(String line) {
            return line.replaceAll("[|\\s]", "").trim();
        }

        @Override
        protected String inputs(String line) {
            String io = this.inputsOutputs(line);
            int separatorIndex = io.indexOf("||");
            return separatorIndex >= 0 ? FlexibleParser.stripSeparators(io.substring(0, separatorIndex)) : "";
        }

        @Override
        protected String outputs(String line) {
            String io = this.inputsOutputs(line);
            int separatorIndex = io.indexOf("||");
            return separatorIndex >= 0 ? FlexibleParser.stripSeparators(io.substring(separatorIndex + 1)) : "";
        }

        @Override
        protected boolean canParse(String line) {
            String io = this.inputsOutputs(line);
            return io.contains("||");
        }
    }

    public static class EditorDialog
    extends JDialog
    implements JInputDialog {
        private static final long serialVersionUID = 1L;
        private static final float smallFont = 9.5f;
        private static final float tinyFont = 8.8f;
        private final HeaderPanel hdrPanel;
        private final TablePanel ttPanel;
        private final JPanel ttScrollPanel;
        private PlaTable oldTable;
        private PlaTable newTable;
        private final BoundedRangeModel vScrollModel;
        private static final int BS = 18;
        private static final int BUTTON_HGAP = 2;
        private static final int EDGE_THICKNESS = 2;
        private static final Border STD_BORDER = BorderFactory.createEtchedBorder();
        private static final Border CLICK_BORDER = BorderFactory.createEtchedBorder(0);
        private static final Dimension BUTTON_SIZE = new Dimension(AppPreferences.getScaled(12), AppPreferences.getScaled(14));

        public EditorDialog(Frame parent) {
            super(parent, Strings.S.get("plaEditorTitle"), true);
            this.setResizable(true);
            Container cPane = super.getContentPane();
            cPane.setLayout(new BorderLayout(5, 5));
            this.hdrPanel = new HeaderPanel();
            JScrollPane header = new JScrollPane(this.hdrPanel, 22, 31);
            header.getVerticalScrollBar().setUI(new BasicScrollBarUI(this){

                @Override
                protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
                }

                @Override
                protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
                }

                @Override
                protected JButton createIncreaseButton(int orientation) {
                    return this.createZeroButton();
                }

                @Override
                protected JButton createDecreaseButton(int orientation) {
                    return this.createZeroButton();
                }

                private JButton createZeroButton() {
                    JButton jbutton = new JButton();
                    jbutton.setPreferredSize(new Dimension(0, 0));
                    jbutton.setMinimumSize(new Dimension(0, 0));
                    jbutton.setMaximumSize(new Dimension(0, 0));
                    return jbutton;
                }
            });
            this.ttPanel = new TablePanel();
            this.ttScrollPanel = new JPanel();
            this.ttScrollPanel.add((Component)this.ttPanel, "Center");
            JScrollPane table = new JScrollPane(this.ttScrollPanel, 22, 30);
            header.getHorizontalScrollBar().setModel(table.getHorizontalScrollBar().getModel());
            this.vScrollModel = table.getVerticalScrollBar().getModel();
            cPane.add((Component)header, "North");
            cPane.add((Component)table, "Center");
            cPane.add((Component)new ButtonPanel(this), "South");
            cPane.setPreferredSize(new Dimension(AppPreferences.getScaled(440), AppPreferences.getScaled(360)));
            this.setMinimumSize(new Dimension(AppPreferences.getScaled(300), AppPreferences.getScaled(200)));
            this.setLocationRelativeTo(parent);
        }

        @Override
        public void setValue(Object o) {
            if (!(o instanceof PlaTable)) {
                return;
            }
            this.oldTable = (PlaTable)o;
            this.newTable = new PlaTable(this.oldTable);
            this.reset(true);
        }

        @Override
        public Object getValue() {
            return this.oldTable;
        }

        void reset(boolean resize) {
            this.hdrPanel.reset();
            this.ttPanel.reset();
            if (resize) {
                Dimension d = this.hdrPanel.getPreferredSize();
                int w = (int)d.getWidth() + 50;
                int h = (int)d.getHeight() + 20 * this.newTable.rows.size() + 140;
                int ww = Math.max(Math.min(w, 800), 300);
                int hh = Math.max(Math.min(h, 500), 200);
                this.repack(new Dimension(AppPreferences.getScaled(ww), AppPreferences.getScaled(hh)));
            }
        }

        void repack(Dimension prefSize) {
            Dimension d = prefSize != null ? prefSize : this.getSize();
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setPreferredSize(d);
            this.pack();
            this.setMinimumSize(new Dimension(AppPreferences.getScaled(300), AppPreferences.getScaled(200)));
            this.setMaximumSize(null);
        }

        void close(boolean ok) {
            if (ok) {
                this.oldTable.copyFrom(this.newTable);
            }
            this.setVisible(false);
        }

        static String normalizeName(String s) {
            if (s == null) {
                return "pla.txt";
            }
            s = s.trim();
            s = s.replace("[^a-zA-Z0-9().-]", " ");
            if ((s = s.replace("\\s+", "_")).equals("") || s.equals("_")) {
                return "pla.txt";
            }
            return s + ".txt";
        }

        void read() {
            JFileChooser chooser = JFileChoosers.create();
            chooser.setSelectedFile(new File(EditorDialog.normalizeName(this.oldTable.label)));
            chooser.setDialogTitle(Strings.S.get("plaLoadDialogTitle"));
            chooser.setFileFilter(Loader.TXT_FILTER);
            int choice = chooser.showOpenDialog(null);
            if (choice == 0) {
                File f = chooser.getSelectedFile();
                try {
                    PlaTable loaded = PlaTable.parse(f);
                    if (loaded.inSize() != this.newTable.inSize()) {
                        throw new IOException(Strings.S.get("plaUnexpectedInputWidth", this.newTable.inSize(), loaded.inSize()));
                    }
                    if (loaded.outSize() != this.newTable.outSize()) {
                        throw new IOException(Strings.S.get("plaUnexpectedOutputWidth", this.newTable.outSize(), loaded.outSize()));
                    }
                    this.newTable.copyFrom(loaded);
                    this.reset(false);
                }
                catch (IOException e) {
                    OptionPane.showMessageDialog(null, e.getMessage(), Strings.S.get("plaLoadErrorTitle"), 0);
                }
            }
        }

        void write() {
            JFileChooser chooser = JFileChoosers.create();
            chooser.setSelectedFile(new File(EditorDialog.normalizeName(this.oldTable.label)));
            chooser.setDialogTitle(Strings.S.get("plaSaveDialogTitle"));
            chooser.setFileFilter(Loader.TXT_FILTER);
            int choice = chooser.showSaveDialog(null);
            if (choice == 0) {
                File f = chooser.getSelectedFile();
                try {
                    this.newTable.save(f);
                }
                catch (IOException e) {
                    OptionPane.showMessageDialog(null, e.getMessage(), Strings.S.get("plaSaveErrorTitle"), 0);
                }
            }
        }

        class HeaderPanel
        extends JPanel {
            private static final long serialVersionUID = 1L;

            HeaderPanel() {
                super.setLayout(new BoxLayout(this, 1));
            }

            void reset() {
                this.removeAll();
                this.add(new TopLabelPanel(EditorDialog.this.newTable.inSize, EditorDialog.this.newTable.outSize));
                this.add(new TopNumberPanel(EditorDialog.this.newTable.inSize, EditorDialog.this.newTable.outSize));
                EditorDialog.this.pack();
            }
        }

        class TablePanel
        extends JPanel {
            private static final long serialVersionUID = 1L;

            TablePanel() {
                super.setLayout(new BoxLayout(this, 1));
            }

            void reset() {
                this.removeAll();
                for (Row r : EditorDialog.this.newTable.rows) {
                    this.add(new RowPanel(r));
                }
                this.add(new InsertRowPanel());
                this.add(Box.createVerticalGlue());
            }

            void addRow() {
                Dimension prevSize = EditorDialog.this.getSize();
                this.add((Component)new RowPanel(EditorDialog.this.newTable.addTableRow()), this.getComponentCount() - 2);
                EditorDialog.this.repack(prevSize);
                EditorDialog.this.vScrollModel.setValue(EditorDialog.this.vScrollModel.getMaximum());
            }

            void deleteRow(RowPanel rp) {
                EditorDialog.this.newTable.deleteTableRow(rp.row);
                this.remove(rp);
                EditorDialog.this.repack(null);
            }

            class RowPanel
            extends JPanel {
                private static final long serialVersionUID = 1L;
                private final Row row;

                RowPanel(Row r) {
                    int ii;
                    super(new FlowLayout(1, 0, 0));
                    this.row = r;
                    JButton rm = new JButton(Strings.S.get("plaRemoveButton"));
                    rm.setFont(AppPreferences.getScaledFont(rm.getFont().deriveFont(9.5f)));
                    rm.addActionListener(e -> TablePanel.this.deleteRow(this));
                    rm.setMargin(new Insets(0, 0, 0, 0));
                    rm.setPreferredSize(new Dimension(AppPreferences.getScaled(75), AppPreferences.getScaled(17)));
                    this.add(rm);
                    int inSz = this.row.inBits.length;
                    int outSz = this.row.outBits.length;
                    GridLayout layout = new GridLayout(1, 1 + inSz + 1 + Math.max(outSz, 2) + 1);
                    layout.setHgap(2);
                    JPanel bitPanel = new JPanel(layout);
                    bitPanel.add(new Box(0));
                    int i = inSz - 1;
                    while (i >= 0) {
                        ii = i--;
                        bitPanel.add(new BitStateButton(this, this.row.inBits[ii]){
                            private static final long serialVersionUID = 1L;
                            final /* synthetic */ RowPanel this$2;
                            {
                                this.this$2 = this$2;
                                super(s);
                            }

                            @Override
                            public char clicked() {
                                return this.this$2.row.changeInBit(ii);
                            }
                        });
                    }
                    bitPanel.add(new Box(0));
                    for (i = outSz; i < 2; ++i) {
                        bitPanel.add(new Box(0));
                    }
                    i = outSz - 1;
                    while (i >= 0) {
                        ii = i--;
                        bitPanel.add(new BitStateButton(this, this.row.outBits[ii]){
                            private static final long serialVersionUID = 1L;
                            final /* synthetic */ RowPanel this$2;
                            {
                                this.this$2 = this$2;
                                super(s);
                            }

                            @Override
                            public char clicked() {
                                return this.this$2.row.changeOutBit(ii);
                            }
                        });
                    }
                    bitPanel.add(new Box(0));
                    this.add(bitPanel);
                    final JTextField txt = new JTextField(null, this.row.comment, 10);
                    txt.addKeyListener(new KeyAdapter(this){
                        final /* synthetic */ RowPanel this$2;
                        {
                            this.this$2 = this$2;
                        }

                        @Override
                        public void keyReleased(KeyEvent e) {
                            this.this$2.row.comment = txt.getText();
                        }
                    });
                    txt.setPreferredSize(new Dimension(AppPreferences.getScaled(125), AppPreferences.getScaled(20)));
                    this.add(txt);
                    EditorDialog.this.pack();
                    this.setMaximumSize(this.getPreferredSize());
                    this.add(Box.createRigidArea(new Dimension(AppPreferences.getScaled(4), AppPreferences.getScaled(20))));
                }
            }

            class InsertRowPanel
            extends JPanel {
                private static final long serialVersionUID = 1L;

                public InsertRowPanel() {
                    super(new FlowLayout(1));
                    JButton more = new JButton(Strings.S.get("plaAddRowButton"));
                    more.setFont(AppPreferences.getScaledFont(more.getFont().deriveFont(9.5f)));
                    more.addActionListener(e -> TablePanel.this.addRow());
                    more.setMargin(new Insets(1, 20, 1, 20));
                    this.add(more);
                }
            }
        }

        class ButtonPanel
        extends JPanel {
            private static final long serialVersionUID = 1L;

            public ButtonPanel(JDialog parent) {
                JButton write = new JButton(Strings.S.get("plaExportButton"));
                write.addActionListener(e -> EditorDialog.this.write());
                this.add(write);
                JButton read = new JButton(Strings.S.get("plaImportButton"));
                read.addActionListener(e -> EditorDialog.this.read());
                this.add(read);
                JButton ok = new JButton(Strings.S.get("plaOKButton"));
                ok.addActionListener(e -> EditorDialog.this.close(true));
                parent.getRootPane().setDefaultButton(ok);
                this.add(ok);
                JButton cancel = new JButton(Strings.S.get("plaCancelButton"));
                cancel.addActionListener(e -> EditorDialog.this.close(false));
                this.add(cancel);
                parent.getRootPane().registerKeyboardAction(e -> EditorDialog.this.close(false), KeyStroke.getKeyStroke(27, 0), 2);
            }
        }

        static abstract class BitStateButton
        extends JPanel {
            private static final long serialVersionUID = 1L;
            private final JLabel text;

            public abstract char clicked();

            BitStateButton(char s) {
                super(new FlowLayout(1, 0, 0));
                this.setBorder(STD_BORDER);
                this.text = new JLabel("" + s, 0);
                this.text.setPreferredSize(BUTTON_SIZE);
                this.add(this.text);
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.setBorder(CLICK_BORDER);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        this.setBorder(STD_BORDER);
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        text.setText("" + this.clicked());
                    }
                });
            }
        }

        class TopLabelPanel
        extends JPanel {
            private static final long serialVersionUID = 1L;

            TopLabelPanel(int inSz, int outSz) {
                super(new FlowLayout(1, 0, 0));
                this.add(Box.createRigidArea(new Dimension(AppPreferences.getScaled(93 - Math.max(3 - inSz, 0) * 18), AppPreferences.getScaled(15))));
                JLabel i = new JLabel(Strings.S.get("plaInputLabel"), 4);
                i.setFont(AppPreferences.getScaledFont(i.getFont().deriveFont(9.5f)));
                i.setPreferredSize(new Dimension(AppPreferences.getScaled(Math.max(inSz, 3) * 18), AppPreferences.getScaled(15)));
                this.add(i);
                JLabel o = new JLabel(Strings.S.get("plaOutputLabel"), 4);
                o.setFont(AppPreferences.getScaledFont(o.getFont().deriveFont(9.5f)));
                o.setPreferredSize(new Dimension(AppPreferences.getScaled(Math.max(outSz + 1, 3) * 18), AppPreferences.getScaled(15)));
                this.add(o);
                this.add(Box.createRigidArea(new Dimension(AppPreferences.getScaled(135), AppPreferences.getScaled(15))));
                EditorDialog.this.pack();
                this.setMinimumSize(this.getPreferredSize());
                this.setMaximumSize(this.getPreferredSize());
            }
        }

        class TopNumberPanel
        extends JPanel {
            private static final long serialVersionUID = 1L;

            TopNumberPanel(int inSz, int outSz) {
                JLabel l;
                int i;
                super(new FlowLayout(1, 0, 0));
                this.add(Box.createRigidArea(new Dimension(AppPreferences.getScaled(93), AppPreferences.getScaled(15))));
                Dimension dim = new Dimension(AppPreferences.getScaled(18), AppPreferences.getScaled(15));
                for (i = inSz - 1; i >= 0; --i) {
                    l = new JLabel("" + i, 0);
                    l.setFont(AppPreferences.getScaledFont(l.getFont().deriveFont(8.8f)));
                    l.setPreferredSize(dim);
                    this.add(l);
                }
                this.add(Box.createRigidArea(dim));
                for (i = outSz; i < 2; ++i) {
                    this.add(Box.createRigidArea(dim));
                }
                for (i = outSz - 1; i >= 0; --i) {
                    l = new JLabel("" + i, 0);
                    l.setFont(AppPreferences.getScaledFont(l.getFont().deriveFont(8.8f)));
                    l.setPreferredSize(dim);
                    this.add(l);
                }
                this.add(Box.createRigidArea(dim));
                JLabel c = new JLabel(Strings.S.get("plaCommentsLabel"));
                c.setFont(AppPreferences.getScaledFont(c.getFont().deriveFont(9.5f)));
                c.setPreferredSize(new Dimension(AppPreferences.getScaled(117), AppPreferences.getScaled(15)));
                this.add(c);
                EditorDialog.this.pack();
                this.setMinimumSize(this.getPreferredSize());
                this.setMaximumSize(this.getPreferredSize());
            }
        }
    }
}

