/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.hdl.HdlModel;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.vhdl.Strings;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public abstract class GenericInterfaceComponent
extends InstanceFactory {
    static final int WIDTH = 140;
    static final int HEIGHT = 40;
    static final int PORT_GAP = 10;
    static final int X_PADDING = 5;

    public GenericInterfaceComponent(String name, StringGetter displayName, HdlGeneratorFactory generator, boolean requiresGlobalClock) {
        super(name, displayName, generator, requiresGlobalClock);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        int nbInputs = this.getGiAttributesInputs(attrs).length;
        int nbOutputs = this.getGiAttributesOutputs(attrs).length;
        return Bounds.create(0, 0, 140, Math.max(nbInputs, nbOutputs) * 10 + 40);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        int i;
        String glbLabel;
        AttributeSet attrs = painter.getAttributeSet();
        Graphics g = painter.getGraphics();
        FontMetrics metric = g.getFontMetrics();
        Bounds bds = painter.getBounds();
        int x0 = bds.getX() + bds.getWidth() / 2;
        int y0 = bds.getY() + metric.getHeight() + 12;
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        GraphicsUtil.drawText(g, StringUtil.resizeString(this.getGiAttributesName(attrs), metric, 140), x0, y0, 0, 2);
        Boolean labelVis = painter.getAttributeValue(StdAttr.LABEL_VISIBILITY);
        if (labelVis != null && labelVis.booleanValue() && (glbLabel = painter.getAttributeValue(StdAttr.LABEL)) != null) {
            Font font = g.getFont();
            g.setFont(painter.getAttributeValue(StdAttr.LABEL_FONT));
            GraphicsUtil.drawCenteredText(g, glbLabel, bds.getX() + bds.getWidth() / 2, bds.getY() - g.getFont().getSize());
            g.setFont(font);
        }
        g.setColor(new Color(AppPreferences.COMPONENT_SECONDARY_COLOR.get()));
        g.setFont(g.getFont().deriveFont(10.0f));
        metric = g.getFontMetrics();
        HdlModel.PortDescription[] inputs = this.getGiAttributesInputs(attrs);
        HdlModel.PortDescription[] outputs = this.getGiAttributesOutputs(attrs);
        for (i = 0; i < inputs.length; ++i) {
            GraphicsUtil.drawText(g, StringUtil.resizeString(inputs[i].getName(), metric, 65), bds.getX() + 5, bds.getY() + 40 - 2 + i * 10, -1, 0);
        }
        for (i = 0; i < outputs.length; ++i) {
            GraphicsUtil.drawText(g, StringUtil.resizeString(outputs[i].getName(), metric, 65), bds.getX() + 140 - 5, bds.getY() + 40 - 2 + i * 10, 1, 0);
        }
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawBounds();
        painter.drawPorts();
    }

    protected abstract String getGiAttributesName(AttributeSet var1);

    protected abstract HdlModel.PortDescription[] getGiAttributesInputs(AttributeSet var1);

    protected abstract HdlModel.PortDescription[] getGiAttributesOutputs(AttributeSet var1);

    protected void updatePorts(Instance instance) {
        HdlModel.PortDescription[] inputs = this.getGiAttributesInputs(instance.getAttributeSet());
        HdlModel.PortDescription[] outputs = this.getGiAttributesOutputs(instance.getAttributeSet());
        Port[] result = new Port[inputs.length + outputs.length];
        int resultIndex = 0;
        int i = 0;
        for (HdlModel.PortDescription desc : inputs) {
            result[resultIndex] = new Port(0, i * 10 + 40, desc.getType(), desc.getWidth());
            result[resultIndex].setToolTip(Strings.S.getter(desc.getName()));
            ++resultIndex;
            ++i;
        }
        i = 0;
        for (HdlModel.PortDescription desc : outputs) {
            result[resultIndex] = new Port(140, i * 10 + 40, desc.getType(), desc.getWidth());
            result[resultIndex].setToolTip(Strings.S.getter(desc.getName()));
            ++resultIndex;
            ++i;
        }
        instance.setPorts(result);
        instance.recomputeBounds();
    }
}

