/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.InlinedHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.WithSelectHdlGenerator;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.io.SevenSegment;
import com.cburch.logisim.util.LineBuffer;

public class HexDigitHdlGeneratorFactory
extends InlinedHdlGeneratorFactory {
    @Override
    public LineBuffer getInlinedCode(Netlist nets, Long componentId, netlistComponent componentInfo, String circuitName) {
        int startId = componentInfo.getLocalBubbleOutputStartId();
        String bubbleBusName = "logisimOutputBubbles";
        String signalName = LineBuffer.format("{{1}}{{<}}{{2}}{{3}}{{4}}{{>}}", "logisimOutputBubbles", startId + 6, Hdl.vectorLoopId(), startId);
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("bubbleBusName", "logisimOutputBubbles").pair("sigName", signalName).pair("dpName", Hdl.getNetName(componentInfo, 1, true, nets));
        if (componentInfo.isEndConnected(0)) {
            WithSelectHdlGenerator generator = new WithSelectHdlGenerator(componentInfo.getComponent().getAttributeSet().getValue(StdAttr.LABEL), Hdl.getBusName(componentInfo, 0, nets), 4, signalName, 7).add((Long)0L, "0111111").add((Long)1L, "0000110").add((Long)2L, "1011011").add((Long)3L, "1001111").add((Long)4L, "1100110").add((Long)5L, "1101101").add((Long)6L, "1111101").add((Long)7L, "0000111").add((Long)8L, "1111111").add((Long)9L, "1100111").add((Long)10L, "1110111").add((Long)11L, "1111100").add((Long)12L, "0111001").add((Long)13L, "1011110").add((Long)14L, "1111001").setDefault("1110001");
            contents.add(generator.getHdlCode());
        } else {
            contents.add("{{assign}}{{sigName}}{{=}}{{1}};", Hdl.getZeroVector(7, true));
        }
        if (componentInfo.getComponent().getAttributeSet().getValue(SevenSegment.ATTR_DP).booleanValue()) {
            contents.add("{{assign}}{{bubbleBusName}}{{<}}{{1}}{{>}}{{=}}{{dpName}};", startId + 7);
        }
        return contents;
    }
}

