/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.circuit.appear.DynamicElementProvider;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.gui.icons.CounterIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.CounterAttributes;
import com.cburch.logisim.std.memory.CounterHdlGeneratorFactory;
import com.cburch.logisim.std.memory.CounterPoker;
import com.cburch.logisim.std.memory.CounterShape;
import com.cburch.logisim.std.memory.RegisterData;
import com.cburch.logisim.std.memory.RegisterLogger;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import com.cburch.logisim.tools.key.JoinedConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Counter
extends InstanceFactory
implements DynamicElementProvider {
    public static final String _ID = "Counter";
    static final Logger logger = LoggerFactory.getLogger(Counter.class);
    static final AttributeOption ON_GOAL_WRAP = new AttributeOption("wrap", "wrap", Strings.S.getter("counterGoalWrap"));
    static final AttributeOption ON_GOAL_STAY = new AttributeOption("stay", "stay", Strings.S.getter("counterGoalStay"));
    static final AttributeOption ON_GOAL_CONT = new AttributeOption("continue", "continue", Strings.S.getter("counterGoalContinue"));
    static final AttributeOption ON_GOAL_LOAD = new AttributeOption("load", "load", Strings.S.getter("counterGoalLoad"));
    static final Attribute<Long> ATTR_MAX = Attributes.forHexLong("max", Strings.S.getter("counterMaxAttr"));
    static final Attribute<AttributeOption> ATTR_ON_GOAL = Attributes.forOption("ongoal", Strings.S.getter("counterGoalAttr"), new AttributeOption[]{ON_GOAL_WRAP, ON_GOAL_STAY, ON_GOAL_CONT, ON_GOAL_LOAD});
    static final int DELAY = 8;
    public static final int OUT = 0;
    public static final int IN = 1;
    public static final int CK = 2;
    public static final int CLR = 3;
    public static final int LD = 4;
    public static final int UD = 5;
    public static final int EN = 6;
    static final int CARRY = 7;

    public static int getSymbolWidth(int NrOfBits) {
        return 150 + (NrOfBits - 8) / 5 * 10;
    }

    public Counter() {
        super(_ID, Strings.S.getter("counterComponent"), new CounterHdlGeneratorFactory());
        this.setOffsetBounds(Bounds.create(-30, -20, 30, 40));
        this.setIcon(new CounterIcon());
        this.setInstancePoker(CounterPoker.class);
        this.setKeyConfigurator(JoinedConfigurator.create(new BitWidthConfigurator(StdAttr.WIDTH), new DirectionConfigurator(StdAttr.LABEL_LOC, 512)));
        this.setInstanceLogger(RegisterLogger.class);
        this.setKeyConfigurator(new BitWidthConfigurator(StdAttr.WIDTH));
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        this.configurePorts(instance);
        instance.addAttributeListener();
    }

    private void configurePorts(Instance instance) {
        Bounds bds = instance.getBounds();
        BitWidth widthVal = instance.getAttributeValue(StdAttr.WIDTH);
        int width = widthVal == null ? 8 : widthVal.getWidth();
        Port[] ps = new Port[8];
        if (instance.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            ps[0] = new Port(0, 0, "output", StdAttr.WIDTH);
            ps[1] = new Port(-30, 0, "input", StdAttr.WIDTH);
            ps[2] = new Port(-20, 20, "input", 1);
            ps[3] = new Port(-10, 20, "input", 1);
            ps[4] = new Port(-30, -10, "input", 1);
            ps[5] = new Port(-20, -20, "input", 1);
            ps[6] = new Port(-30, 10, "input", 1);
            ps[7] = new Port(0, 10, "output", 1);
        } else {
            if (width == 1) {
                ps[0] = new Port(Counter.getSymbolWidth(width) + 40, 120, "output", StdAttr.WIDTH);
                ps[1] = new Port(0, 120, "input", StdAttr.WIDTH);
            } else {
                ps[0] = new Port(Counter.getSymbolWidth(width) + 40, 110, "output", StdAttr.WIDTH);
                ps[1] = new Port(0, 110, "input", StdAttr.WIDTH);
            }
            ps[2] = new Port(0, 80, "input", 1);
            ps[3] = new Port(0, 20, "input", 1);
            ps[4] = new Port(0, 30, "input", 1);
            ps[5] = new Port(0, 50, "input", 1);
            ps[6] = new Port(0, 70, "input", 1);
            ps[7] = new Port(40 + Counter.getSymbolWidth(width), 50, "output", 1);
        }
        ps[0].setToolTip(Strings.S.getter("counterQTip"));
        ps[1].setToolTip(Strings.S.getter("counterDataTip"));
        ps[2].setToolTip(Strings.S.getter("counterClockTip"));
        ps[3].setToolTip(Strings.S.getter("counterResetTip"));
        ps[4].setToolTip(Strings.S.getter("counterLoadTip"));
        ps[5].setToolTip(Strings.S.getter("counterUpDownTip"));
        ps[6].setToolTip(Strings.S.getter("counterEnableTip"));
        ps[7].setToolTip(Strings.S.getter("counterCarryTip"));
        instance.setPorts(ps);
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, bds.getX() + bds.getWidth() / 2, bds.getY() - 3, 0, 1);
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new CounterAttributes();
    }

    private void drawControl(InstancePainter painter, int xpos, int ypos) {
        Graphics g = painter.getGraphics();
        GraphicsUtil.switchToWidth(g, 2);
        BitWidth widthVal = painter.getAttributeValue(StdAttr.WIDTH);
        int width = widthVal == null ? 8 : widthVal.getWidth();
        int symbolWidth = Counter.getSymbolWidth(width);
        int[] controlTopx = new int[8];
        controlTopx[0] = controlTopx[1] = xpos + 30;
        controlTopx[2] = controlTopx[3] = xpos + 20;
        controlTopx[4] = controlTopx[5] = xpos + 20 + symbolWidth;
        controlTopx[6] = controlTopx[7] = xpos + 10 + symbolWidth;
        int[] controlTopy = new int[8];
        controlTopy[0] = controlTopy[7] = ypos + 110;
        controlTopy[5] = controlTopy[6] = ypos + 100;
        controlTopy[2] = controlTopy[6];
        controlTopy[1] = controlTopy[6];
        controlTopy[3] = controlTopy[4] = ypos;
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        g.drawPolyline(controlTopx, controlTopy, controlTopx.length);
        painter.drawClockSymbol(xpos + 20, ypos + 80);
        painter.drawClockSymbol(xpos + 20, ypos + 90);
        long max = painter.getAttributeValue(ATTR_MAX);
        boolean isCTRm = max == painter.getAttributeValue(StdAttr.WIDTH).getMask();
        AttributeOption onGoal = painter.getAttributeValue(ATTR_ON_GOAL);
        String label = (isCTRm |= onGoal == ON_GOAL_CONT) ? "CTR" + painter.getAttributeValue(StdAttr.WIDTH).getWidth() : "CTR DIV0x" + Long.toHexString(max);
        GraphicsUtil.drawCenteredText(g, label, xpos + Counter.getSymbolWidth(width) / 2 + 20, ypos + 5);
        GraphicsUtil.switchToWidth(g, 2);
        g.drawLine(xpos, ypos + 20, xpos + 20, ypos + 20);
        GraphicsUtil.drawText(g, "R", xpos + 30, ypos + 20, -1, 0);
        painter.drawPort(3);
        g.drawLine(xpos, ypos + 30, xpos + 20, ypos + 30);
        g.drawLine(xpos + 5, ypos + 40, xpos + 12, ypos + 40);
        g.drawLine(xpos + 5, ypos + 30, xpos + 5, ypos + 40);
        g.drawOval(xpos + 12, ypos + 36, 8, 8);
        g.fillOval(xpos + 2, ypos + 27, 6, 6);
        painter.drawPort(4);
        GraphicsUtil.drawText(g, "M2 [count]", xpos + 30, ypos + 40, -1, 0);
        GraphicsUtil.drawText(g, "M1 [load]", xpos + 30, ypos + 30, -1, 0);
        g.drawLine(xpos, ypos + 50, xpos + 20, ypos + 50);
        g.drawLine(xpos + 5, ypos + 60, xpos + 12, ypos + 60);
        g.drawLine(xpos + 5, ypos + 50, xpos + 5, ypos + 60);
        g.drawOval(xpos + 12, ypos + 56, 8, 8);
        g.fillOval(xpos + 2, ypos + 47, 6, 6);
        GraphicsUtil.drawText(g, "M3 [up]", xpos + 30, ypos + 50, -1, 0);
        GraphicsUtil.drawText(g, "M4 [down]", xpos + 30, ypos + 60, -1, 0);
        painter.drawPort(5);
        g.drawLine(xpos, ypos + 70, xpos + 20, ypos + 70);
        GraphicsUtil.drawText(g, "G5", xpos + 30, ypos + 70, -1, 0);
        painter.drawPort(6);
        boolean inverted = painter.getAttributeValue(StdAttr.EDGE_TRIGGER).equals(StdAttr.TRIG_FALLING);
        int xend = inverted ? xpos + 12 : xpos + 20;
        g.drawLine(xpos, ypos + 80, xend, ypos + 80);
        g.drawLine(xpos + 5, ypos + 90, xend, ypos + 90);
        g.drawLine(xpos + 5, ypos + 80, xpos + 5, ypos + 90);
        g.fillOval(xpos + 2, ypos + 77, 6, 6);
        if (inverted) {
            g.drawOval(xend, ypos + 76, 8, 8);
            g.drawOval(xend, ypos + 86, 8, 8);
        }
        GraphicsUtil.drawText(g, "2,3,5+/C6", xpos + 30, ypos + 80, -1, 0);
        GraphicsUtil.drawText(g, "2,4,5-", xpos + 30, ypos + 90, -1, 0);
        painter.drawPort(2);
        g.drawLine(xpos + 20 + Counter.getSymbolWidth(width), ypos + 50, xpos + 40 + Counter.getSymbolWidth(width), ypos + 50);
        g.drawLine(xpos + 20 + Counter.getSymbolWidth(width), ypos + 60, xpos + 35 + Counter.getSymbolWidth(width), ypos + 60);
        g.drawLine(xpos + 35 + Counter.getSymbolWidth(width), ypos + 50, xpos + 35 + Counter.getSymbolWidth(width), ypos + 60);
        g.fillOval(xpos + 32 + Counter.getSymbolWidth(width), ypos + 47, 6, 6);
        String maxVal = "3CT=0x" + Long.toHexString(painter.getAttributeValue(ATTR_MAX)).toUpperCase();
        GraphicsUtil.drawText(g, maxVal, xpos + 17 + Counter.getSymbolWidth(width), ypos + 50, 1, 0);
        GraphicsUtil.drawText(g, "4CT=0", xpos + 17 + Counter.getSymbolWidth(width), ypos + 60, 1, 0);
        painter.drawPort(7);
        RegisterData state = (RegisterData)painter.getData();
        if (painter.getShowState() && state != null) {
            int len = (width + 3) / 4;
            int xcenter = Counter.getSymbolWidth(width) - 25;
            Value val = state.value;
            if (val.isFullyDefined()) {
                g.setColor(Color.LIGHT_GRAY);
            } else if (val.isErrorValue()) {
                g.setColor(Color.RED);
            } else {
                g.setColor(Color.BLUE);
            }
            g.fillRect(xpos + xcenter - len * 4, ypos + 22, len * 8, 16);
            String value = "";
            if (val.isFullyDefined()) {
                g.setColor(Color.DARK_GRAY);
                value = StringUtil.toHexString(width, val.toLongValue()).toUpperCase();
            } else {
                g.setColor(Color.YELLOW);
                for (int i = 0; i < StringUtil.toHexString(width, val.toLongValue()).length(); ++i) {
                    value = val.isUnknown() ? value.concat("?") : value.concat("!");
                }
            }
            GraphicsUtil.drawText(g, value, xpos + xcenter - len * 4 + 1, ypos + 30, -1, 0);
            g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        }
    }

    private void drawDataBlock(InstancePainter painter, int xpos, int ypos, int bitNr, int nrOfBits) {
        int realYpos = ypos + bitNr * 20;
        boolean first = bitNr == 0;
        boolean last = bitNr == nrOfBits - 1;
        Graphics g = painter.getGraphics();
        Font font = g.getFont();
        g.setFont(font.deriveFont(7.0f));
        GraphicsUtil.switchToWidth(g, 2);
        g.drawRect(xpos + 20, realYpos, Counter.getSymbolWidth(nrOfBits), 20);
        if (nrOfBits > 1) {
            int[] ixPoints = new int[]{xpos + 5, xpos + 10, xpos + 20};
            int[] iyPoints = new int[]{realYpos + 5, realYpos + 10, realYpos + 10};
            g.drawPolyline(ixPoints, iyPoints, 3);
            int[] oxPoints = new int[]{xpos + 20 + Counter.getSymbolWidth(nrOfBits), xpos + 30 + Counter.getSymbolWidth(nrOfBits), xpos + 35 + Counter.getSymbolWidth(nrOfBits)};
            int[] oyPoints = new int[]{realYpos + 10, realYpos + 10, realYpos + 5};
            g.drawPolyline(oxPoints, oyPoints, 3);
        } else {
            g.drawLine(xpos, realYpos + 10, xpos + 20, realYpos + 10);
            g.drawLine(xpos + 20 + Counter.getSymbolWidth(nrOfBits), realYpos + 10, xpos + 40 + Counter.getSymbolWidth(nrOfBits), realYpos + 10);
        }
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        if (nrOfBits > 1) {
            GraphicsUtil.drawText(g, Integer.toString(bitNr), xpos + 30 + Counter.getSymbolWidth(nrOfBits), realYpos + 8, 1, 1);
            GraphicsUtil.drawText(g, Integer.toString(bitNr), xpos + 10, realYpos + 8, -1, 1);
        }
        g.setFont(font);
        GraphicsUtil.drawText(g, "1,6D", xpos + 21, realYpos + 10, -1, 0);
        int LineWidth = nrOfBits == 1 ? 3 : 4;
        GraphicsUtil.switchToWidth(g, LineWidth);
        g.setColor(Value.multiColor);
        if (first) {
            painter.drawPort(1);
            painter.drawPort(0);
            if (nrOfBits > 1) {
                int[] ixPoints = new int[]{xpos, xpos + 5, xpos + 5};
                int[] iyPoints = new int[]{realYpos, realYpos + 5, realYpos + 20};
                g.drawPolyline(ixPoints, iyPoints, 3);
                int[] oxPoints = new int[]{xpos + 35 + Counter.getSymbolWidth(nrOfBits), xpos + 35 + Counter.getSymbolWidth(nrOfBits), xpos + 40 + Counter.getSymbolWidth(nrOfBits)};
                int[] oyPoints = new int[]{realYpos + 20, realYpos + 5, realYpos};
                g.drawPolyline(oxPoints, oyPoints, 3);
            }
        } else if (last) {
            g.drawLine(xpos + 5, realYpos, xpos + 5, realYpos + 5);
            g.drawLine(xpos + 35 + Counter.getSymbolWidth(nrOfBits), realYpos, xpos + 35 + Counter.getSymbolWidth(nrOfBits), realYpos + 5);
        } else {
            g.drawLine(xpos + 5, realYpos, xpos + 5, realYpos + 20);
            g.drawLine(xpos + 35 + Counter.getSymbolWidth(nrOfBits), realYpos, xpos + 35 + Counter.getSymbolWidth(nrOfBits), realYpos + 20);
        }
        GraphicsUtil.switchToWidth(g, 1);
        RegisterData state = (RegisterData)painter.getData();
        if (painter.getShowState() && state != null) {
            Value val = state.value;
            BitWidth widthVal = painter.getAttributeValue(StdAttr.WIDTH);
            int width = widthVal == null ? 8 : widthVal.getWidth();
            int xcenter = Counter.getSymbolWidth(width) / 2 + 10;
            String value = "";
            if (val.isFullyDefined()) {
                g.setColor(Color.LIGHT_GRAY);
                value = (1L << bitNr & val.toLongValue()) != 0L ? "1" : "0";
            } else if (val.isUnknown()) {
                g.setColor(Color.BLUE);
                value = "?";
            } else {
                g.setColor(Color.RED);
                value = "!";
            }
            g.fillRect(xpos + xcenter + 16, realYpos + 4, 8, 16);
            if (val.isFullyDefined()) {
                g.setColor(Color.DARK_GRAY);
            } else {
                g.setColor(Color.YELLOW);
            }
            GraphicsUtil.drawText(g, value, xpos + xcenter + 20, realYpos + 10, 0, 0);
            g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        }
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        return "LogisimCounter";
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        BitWidth widthVal = attrs.getValue(StdAttr.WIDTH);
        int width = widthVal == null ? 8 : widthVal.getWidth();
        return attrs.getValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC ? Bounds.create(-30, -20, 30, 40) : Bounds.create(0, 0, Counter.getSymbolWidth(width) + 40, 110 + 20 * width);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.WIDTH || attr == StdAttr.APPEARANCE) {
            instance.recomputeBounds();
            this.configurePorts(instance);
            instance.computeLabelTextField(10);
        } else if (attr == StdAttr.LABEL_LOC) {
            instance.computeLabelTextField(10);
        }
    }

    public void drawCounterClassic(InstancePainter painter) {
        String a;
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        RegisterData state = (RegisterData)painter.getData();
        BitWidth widthVal = painter.getAttributeValue(StdAttr.WIDTH);
        int width = widthVal == null ? 8 : widthVal.getWidth();
        String b = null;
        if (painter.getShowState()) {
            long val = state == null ? 0L : state.value.toLongValue();
            String str = StringUtil.toHexString(width, val);
            if (str.length() <= 4) {
                a = str;
            } else {
                int split = str.length() - 4;
                a = str.substring(0, split);
                b = str.substring(split);
            }
        } else {
            a = Strings.S.get("counterLabel");
            b = Strings.S.get("registerWidthLabel", "" + widthVal.getWidth());
        }
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawBounds();
        painter.drawLabel();
        if (b == null) {
            painter.drawPort(1, "D", Direction.EAST);
            painter.drawPort(0, "Q", Direction.WEST);
        } else {
            painter.drawPort(1);
            painter.drawPort(0);
        }
        g.setColor(new Color(AppPreferences.COMPONENT_SECONDARY_COLOR.get()));
        painter.drawPort(4);
        painter.drawPort(5);
        painter.drawPort(7);
        painter.drawPort(3, "0", Direction.SOUTH);
        painter.drawPort(6, Strings.S.get("counterEnableLabel"), Direction.EAST);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawClock(2, Direction.NORTH);
        if (b == null) {
            GraphicsUtil.drawText(g, a, bds.getX() + 15, bds.getY() + 4, 0, -1);
        } else {
            GraphicsUtil.drawText(g, a, bds.getX() + 15, bds.getY() + 3, 0, -1);
            GraphicsUtil.drawText(g, b, bds.getX() + 15, bds.getY() + 15, 0, -1);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        if (painter.getAttributeValue(StdAttr.APPEARANCE) == StdAttr.APPEAR_CLASSIC) {
            this.drawCounterClassic(painter);
            return;
        }
        int Xpos = painter.getLocation().getX();
        int Ypos = painter.getLocation().getY();
        painter.drawLabel();
        this.drawControl(painter, Xpos, Ypos);
        BitWidth widthVal = painter.getAttributeValue(StdAttr.WIDTH);
        int width = widthVal == null ? 8 : widthVal.getWidth();
        for (int bit = 0; bit < width; ++bit) {
            this.drawDataBlock(painter, Xpos, Ypos + 110, bit, width);
        }
    }

    @Override
    public void propagate(InstanceState state) {
        boolean carry;
        Value newValue;
        RegisterData data = (RegisterData)state.getData();
        if (data == null) {
            data = new RegisterData(state.getAttributeValue(StdAttr.WIDTH));
            state.setData(data);
        }
        BitWidth dataWidth = state.getAttributeValue(StdAttr.WIDTH);
        AttributeOption triggerType = state.getAttributeValue(StdAttr.EDGE_TRIGGER);
        BigInteger max = new BigInteger(Long.toUnsignedString(state.getAttributeValue(ATTR_MAX)));
        Value clock = state.getPortValue(2);
        boolean triggered = data.updateClock(clock, triggerType);
        if (state.getPortValue(3) == Value.TRUE) {
            newValue = Value.createKnown(dataWidth, 0L);
            carry = false;
        } else {
            BigInteger newVal;
            boolean ld = state.getPortValue(4) == Value.TRUE;
            boolean en = state.getPortValue(6) != Value.FALSE;
            boolean UpCount = state.getPortValue(5) != Value.FALSE;
            Value oldVal = data.value;
            BigInteger oldValue = new BigInteger(Long.toUnsignedString(oldVal.toLongValue()));
            BigInteger loadValue = new BigInteger(Long.toUnsignedString(state.getPortValue(1).toLongValue()));
            if (!triggered) {
                newVal = new BigInteger(Long.toUnsignedString(oldVal.toLongValue()));
            } else if (ld) {
                newVal = loadValue;
                if (newVal.compareTo(max) > 0) {
                    newVal = newVal.and(max);
                }
            } else if (!oldVal.isFullyDefined()) {
                newVal = null;
            } else if (en) {
                BigInteger goal;
                BigInteger bigInteger = goal = UpCount ? max : BigInteger.ZERO;
                if (oldValue.compareTo(goal) == 0) {
                    AttributeOption onGoal = state.getAttributeValue(ATTR_ON_GOAL);
                    if (onGoal == ON_GOAL_WRAP) {
                        newVal = UpCount ? BigInteger.ZERO : max;
                    } else if (onGoal == ON_GOAL_STAY) {
                        newVal = oldValue;
                    } else if (onGoal == ON_GOAL_LOAD) {
                        newVal = loadValue;
                        if (newVal.compareTo(max) > 0) {
                            newVal = newVal.and(max);
                        }
                    } else if (onGoal == ON_GOAL_CONT) {
                        newVal = UpCount ? oldValue.add(BigInteger.ONE) : oldValue.subtract(BigInteger.ONE);
                    } else {
                        logger.error("Invalid goal attribute {}", (Object)onGoal);
                        newVal = ld ? max : BigInteger.ZERO;
                    }
                } else {
                    newVal = UpCount ? oldValue.add(BigInteger.ONE) : oldValue.subtract(BigInteger.ONE);
                }
            } else {
                newVal = oldValue;
            }
            newValue = newVal == null ? Value.createError(dataWidth) : Value.createKnown(dataWidth, newVal.longValue());
            BigInteger compVal = UpCount ? max : BigInteger.ZERO;
            carry = newVal.compareTo(compVal) == 0;
        }
        data.value = newValue;
        state.setPort(0, newValue, 8);
        state.setPort(7, carry ? Value.TRUE : Value.FALSE, 8);
    }

    @Override
    public boolean checkForGatedClocks(netlistComponent comp) {
        return true;
    }

    @Override
    public int[] clockPinIndex(netlistComponent comp) {
        return new int[]{2};
    }

    @Override
    public DynamicElement createDynamicElement(int x, int y, DynamicElement.Path path) {
        return new CounterShape(x, y, path);
    }
}

