/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.hex.HexModel;
import com.cburch.hex.HexModelListener;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.std.memory.MemContents;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

class MemState
implements InstanceData,
Cloneable,
HexModelListener {
    private MemContents contents;
    private long curScroll = 0L;
    private long cursorLoc = -1L;
    private long curAddr = -1L;
    private boolean recalculateParameters = true;
    private int nrOfLines = 1;
    private int nrDataSymbolsEachLine = 1;
    private int addrBlockSize = 0;
    private int dataBlockSize = 0;
    private int dataSize = 0;
    private int spaceSize = 0;
    private int xOffset = 0;
    private int yOffset = 0;
    private int charHeight = 0;
    private Bounds displayWindow;

    MemState(MemContents contents) {
        this.contents = contents;
        this.setBits(contents.getLogLength(), contents.getWidth());
        contents.addHexModelListener(this);
    }

    @Override
    public void bytesChanged(HexModel source, long start, long numBytes, long[] oldValues) {
    }

    private void calculateDisplayParameters(Graphics g, int offsetX, int offsetY, int DisplayWidth2, int DisplayHeight) {
        this.recalculateParameters = false;
        this.displayWindow = Bounds.create(offsetX, offsetY, DisplayWidth2, DisplayHeight);
        int addrBits = this.getAddrBits();
        int dataBits = this.contents.getWidth();
        Font font = g.getFont();
        FontMetrics fm = g.getFontMetrics(font);
        this.addrBlockSize = (fm.stringWidth(StringUtil.toHexString(addrBits, 0L)) + 9) / 10 * 10;
        this.dataSize = fm.stringWidth(StringUtil.toHexString(dataBits, 0L) + " ");
        this.spaceSize = fm.stringWidth(" ");
        this.nrDataSymbolsEachLine = (DisplayWidth2 - this.addrBlockSize) / this.dataSize;
        if (this.nrDataSymbolsEachLine == 0) {
            ++this.nrDataSymbolsEachLine;
        }
        if (this.nrDataSymbolsEachLine > 3 && this.nrDataSymbolsEachLine % 2 != 0) {
            --this.nrDataSymbolsEachLine;
        }
        this.nrOfLines = DisplayHeight / (fm.getHeight() + 2);
        if (this.nrOfLines == 0) {
            this.nrOfLines = 1;
        }
        int totalNrOfEntries = 1 << addrBits;
        for (int totalShowableEntries = this.nrDataSymbolsEachLine * this.nrOfLines; totalShowableEntries > totalNrOfEntries + this.nrDataSymbolsEachLine - 1; totalShowableEntries -= this.nrDataSymbolsEachLine) {
            --this.nrOfLines;
        }
        if (this.nrOfLines == 0) {
            this.nrOfLines = 1;
            this.nrDataSymbolsEachLine = totalNrOfEntries;
        }
        this.dataBlockSize = this.nrDataSymbolsEachLine * this.dataSize;
        int totalWidth = this.addrBlockSize + this.dataBlockSize;
        this.xOffset = offsetX + DisplayWidth2 / 2 - totalWidth / 2;
        this.charHeight = fm.getHeight();
        this.yOffset = offsetY;
    }

    @Override
    public MemState clone() {
        try {
            MemState ret = (MemState)super.clone();
            ret.contents = this.contents.clone();
            ret.contents.addHexModelListener(ret);
            return ret;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    int getAddrBits() {
        return this.contents.getLogLength();
    }

    public long getAddressAt(int x, int y) {
        int ystop;
        int ystart;
        int xstop;
        int xstart = this.xOffset + this.addrBlockSize;
        if (x < xstart | x > (xstop = xstart + this.dataBlockSize) | y < (ystart = this.yOffset) | y > (ystop = ystart + this.nrOfLines * (this.charHeight + 2))) {
            return -1L;
        }
        int line = (y -= ystart) / (this.charHeight + 2);
        int symbol = (x -= xstart) / this.dataSize;
        long pointedAddr = this.curScroll + (long)(line * this.nrDataSymbolsEachLine) + (long)symbol;
        return this.isValidAddr(pointedAddr) ? pointedAddr : this.getLastAddress();
    }

    public Bounds getBounds(long addr, Bounds bds) {
        if (addr >= 0L) {
            addr -= this.curScroll;
        }
        return Bounds.create(bds.getX() + this.xOffset, bds.getY() + this.yOffset, this.addrBlockSize, this.charHeight + 2);
    }

    public Bounds getDataBounds(long addr, Bounds bds) {
        int curAddr = (int)this.curScroll;
        for (int row = 0; row < this.nrOfLines; ++row) {
            for (int column = 0; column < this.nrDataSymbolsEachLine; ++column) {
                if ((long)(curAddr + column) != addr || !this.isValidAddr(curAddr + column)) continue;
                return this.getDataBound(bds.getX(), bds.getY(), row, column);
            }
            curAddr += this.nrDataSymbolsEachLine;
        }
        return Bounds.EMPTY_BOUNDS;
    }

    public MemContents getContents() {
        return this.contents;
    }

    long getCurrent() {
        return this.curAddr;
    }

    long getCursor() {
        return this.cursorLoc;
    }

    int getDataBits() {
        return this.contents.getWidth();
    }

    long getLastAddress() {
        return (1L << this.contents.getLogLength()) - 1L;
    }

    int getNrOfLineItems() {
        return this.nrDataSymbolsEachLine;
    }

    int getNrOfLines() {
        return this.nrOfLines;
    }

    long getScroll() {
        return this.curScroll;
    }

    public boolean isSplitted() {
        return false;
    }

    boolean isValidAddr(long addr) {
        int addrBits = this.contents.getLogLength();
        return addr >>> addrBits == 0L;
    }

    @Override
    public void metainfoChanged(HexModel source) {
        this.setBits(this.contents.getLogLength(), this.contents.getWidth());
    }

    private boolean windowChanged(int offsetX, int offsetY, int displayWidth, int displayHeight) {
        return this.displayWindow.getX() != offsetX || this.displayWindow.getY() != offsetY || this.displayWindow.getWidth() != displayWidth || this.displayWindow.getHeight() != displayHeight;
    }

    public void paint(Graphics g, int leftX, int topY, int offsetX, int offsetY, int displayWidth, int displayHeight, int nrItemsToHighlight) {
        if (this.recalculateParameters || this.windowChanged(offsetX, offsetY, displayWidth, displayHeight)) {
            this.calculateDisplayParameters(g, offsetX, offsetY, displayWidth, displayHeight);
        }
        int blockHeight = this.nrOfLines * (this.charHeight + 2);
        int totalNrOfEntries = 1 << this.getAddrBits();
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(leftX + this.xOffset, topY + this.yOffset, this.dataBlockSize + this.addrBlockSize, blockHeight);
        g.setColor(Color.DARK_GRAY);
        g.drawRect(leftX + this.xOffset + this.addrBlockSize, topY + this.yOffset, this.dataBlockSize, blockHeight);
        g.setColor(Color.BLACK);
        int addr = (int)this.curScroll;
        if (addr + this.nrOfLines * this.nrDataSymbolsEachLine > totalNrOfEntries) {
            addr = totalNrOfEntries - this.nrOfLines * this.nrDataSymbolsEachLine;
            if (addr < 0) {
                addr = 0;
            }
            this.curScroll = addr;
        }
        int firsty = topY + this.getFirstYoffset();
        int yinc = this.getDataBlockHeight();
        int firstx = leftX + this.getFirstXoffset();
        for (int i = 0; i < this.nrOfLines; ++i) {
            GraphicsUtil.drawText(g, StringUtil.toHexString(this.getAddrBits(), addr), leftX + this.xOffset + this.addrBlockSize / 2, firsty + i * yinc, 0, 0);
            for (int j = 0; j < this.nrDataSymbolsEachLine; ++j) {
                long value = this.contents.get(addr + j);
                if (!this.isValidAddr(addr + j)) continue;
                if (this.highLight(addr + j, nrItemsToHighlight)) {
                    Bounds dataBounds = this.getDataBound(leftX, topY, i, j);
                    g.setColor(Color.DARK_GRAY);
                    g.fillRect(dataBounds.getX(), dataBounds.getY(), dataBounds.getWidth(), dataBounds.getHeight());
                    g.setColor(Color.WHITE);
                    GraphicsUtil.drawText(g, StringUtil.toHexString(this.contents.getWidth(), value), firstx + j * this.dataSize, firsty + i * yinc, 0, 0);
                    g.setColor(Color.BLACK);
                    continue;
                }
                GraphicsUtil.drawText(g, StringUtil.toHexString(this.contents.getWidth(), value), firstx + j * this.dataSize, firsty + i * yinc, 0, 0);
            }
            addr += this.nrDataSymbolsEachLine;
        }
    }

    private boolean highLight(int addr, int nrItemsToHighlight) {
        return (long)addr >= this.curAddr && (long)addr < this.curAddr + (long)nrItemsToHighlight;
    }

    private Bounds getDataBound(int xoff, int yoff, int line, int column) {
        return Bounds.create(xoff + this.getFirstXoffset() + column * this.dataSize - this.dataSize / 2 - 1, yoff + this.getFirstYoffset() + line * this.getDataBlockHeight() - this.charHeight / 2 - 1, this.getDataBlockWidth(), this.getDataBlockHeight());
    }

    private int getFirstXoffset() {
        return this.xOffset + this.addrBlockSize + this.spaceSize / 2 + (this.dataSize - this.spaceSize) / 2;
    }

    private int getFirstYoffset() {
        return this.yOffset + this.charHeight / 2 + 1;
    }

    private int getDataBlockWidth() {
        return this.dataSize + 2;
    }

    private int getDataBlockHeight() {
        return this.charHeight + 2;
    }

    void scrollToShow(long addr) {
        if (this.recalculateParameters) {
            return;
        }
        int addrBits = this.contents.getLogLength();
        if (addr >>> addrBits != 0L) {
            return;
        }
        if (addr < this.curScroll) {
            long linesToScroll = (this.curScroll - addr + (long)this.nrDataSymbolsEachLine - 1L) / (long)this.nrDataSymbolsEachLine;
            this.curScroll -= linesToScroll * (long)this.nrDataSymbolsEachLine;
        } else if (addr >= this.curScroll + (long)(this.nrOfLines * this.nrDataSymbolsEachLine)) {
            long curScrollEnd = this.curScroll + (long)(this.nrOfLines * this.nrDataSymbolsEachLine) - 1L;
            long linesToScroll = (addr - curScrollEnd + (long)this.nrDataSymbolsEachLine - 1L) / (long)this.nrDataSymbolsEachLine;
            this.curScroll += linesToScroll * (long)this.nrDataSymbolsEachLine;
            long totalNrOfEntries = 1 << addrBits;
            if (this.curScroll + (long)(this.nrOfLines * this.nrDataSymbolsEachLine) > totalNrOfEntries) {
                this.curScroll = totalNrOfEntries - (long)(this.nrOfLines * this.nrDataSymbolsEachLine);
            }
        }
        if (this.curScroll < 0L) {
            this.curScroll = 0L;
        }
    }

    private void setBits(int addrBits, int dataBits) {
        this.recalculateParameters = true;
        if (this.contents == null) {
            this.contents = MemContents.create(addrBits, dataBits, false);
        } else {
            this.contents.setDimensions(addrBits, dataBits);
        }
        this.cursorLoc = -1L;
        this.curAddr = -1L;
        this.curScroll = 0L;
    }

    void setCurrent(long value) {
        this.curAddr = this.isValidAddr(value) ? value : -1L;
    }

    void setCursor(long value) {
        this.cursorLoc = this.isValidAddr(value) ? value : -1L;
    }

    void setScroll(long addr) {
        if (this.recalculateParameters) {
            return;
        }
        long maxAddr = (1 << this.getAddrBits()) - this.nrOfLines * this.nrDataSymbolsEachLine;
        if (addr > maxAddr) {
            addr = maxAddr;
        }
        if (addr < 0L) {
            addr = 0L;
        }
        this.curScroll = addr;
    }
}

