/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.Mem;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public class RamAttributes
extends AbstractAttributeSet {
    static final AttributeOption VOLATILE = new AttributeOption("volatile", Strings.S.getter("ramTypeVolatile"));
    static final AttributeOption NONVOLATILE = new AttributeOption("nonvolatile", Strings.S.getter("ramTypeNonVolatile"));
    static final Attribute<AttributeOption> ATTR_TYPE = Attributes.forOption("type", Strings.S.getter("ramTypeAttr"), new AttributeOption[]{VOLATILE, NONVOLATILE});
    static final AttributeOption BUS_BIDIR = new AttributeOption("bidir", Strings.S.getter("ramBidirDataBus"));
    static final AttributeOption BUS_SEP = new AttributeOption("bibus", Strings.S.getter("ramSeparateDataBus"));
    static final Attribute<AttributeOption> ATTR_DBUS = Attributes.forOption("databus", Strings.S.getter("ramDataAttr"), new AttributeOption[]{BUS_BIDIR, BUS_SEP});
    static final AttributeOption BUS_WITH_BYTEENABLES = new AttributeOption("byteEnables", Strings.S.getter("ramWithByteEnables"));
    static final AttributeOption BUS_WITHOUT_BYTE_ENABLES = new AttributeOption("NobyteEnables", Strings.S.getter("ramNoByteEnables"));
    static final Attribute<AttributeOption> ATTR_ByteEnables = Attributes.forOption("byteenables", Strings.S.getter("ramByteEnables"), new AttributeOption[]{BUS_WITH_BYTEENABLES, BUS_WITHOUT_BYTE_ENABLES});
    static final Attribute<Boolean> CLEAR_PIN = Attributes.forBoolean("clearpin", Strings.S.getter("RamClearPin"));
    private final ArrayList<Attribute<?>> myAttributes = new ArrayList();
    private BitWidth addrBits = BitWidth.create(8);
    private BitWidth dataBits = BitWidth.create(8);
    private String label = "";
    private AttributeOption trigger = StdAttr.TRIG_RISING;
    private AttributeOption busStyle = BUS_SEP;
    private Font labelFont = StdAttr.DEFAULT_LABEL_FONT;
    private Boolean labelVisible = false;
    private AttributeOption byteEnables = BUS_WITHOUT_BYTE_ENABLES;
    private Boolean asynchronousRead = false;
    private AttributeOption appearance = AppPreferences.getDefaultAppearance();
    private AttributeOption readWriteBehavior = Mem.READAFTERWRITE;
    private Boolean clearPin = false;
    private AttributeOption lineSize = Mem.SINGLE;
    private Boolean allowMisaligned = false;
    private AttributeOption typeOfEnables = Mem.USEBYTEENABLES;
    private AttributeOption ramType = VOLATILE;

    RamAttributes() {
        this.updateAttributes();
    }

    public boolean updateAttributes() {
        ArrayList<Attribute<Object>> newList = new ArrayList<Attribute<Object>>();
        boolean changes = false;
        newList.add(Mem.ADDR_ATTR);
        newList.add(Mem.DATA_ATTR);
        newList.add(Mem.ENABLES_ATTR);
        newList.add(ATTR_TYPE);
        newList.add(CLEAR_PIN);
        if (this.typeOfEnables.equals(Mem.USEBYTEENABLES)) {
            newList.add(StdAttr.TRIGGER);
            if (this.trigger.equals(StdAttr.TRIG_RISING) || this.trigger.equals(StdAttr.TRIG_FALLING)) {
                changes |= !this.myAttributes.contains(Mem.ASYNC_READ);
                newList.add(Mem.ASYNC_READ);
                if (!this.asynchronousRead.booleanValue()) {
                    changes |= !this.myAttributes.contains(Mem.READ_ATTR);
                    newList.add(Mem.READ_ATTR);
                } else {
                    changes |= this.myAttributes.contains(Mem.READ_ATTR);
                }
                if (this.dataBits.getWidth() > 8) {
                    changes |= !this.myAttributes.contains(ATTR_ByteEnables);
                    newList.add(ATTR_ByteEnables);
                } else {
                    changes |= this.myAttributes.contains(ATTR_ByteEnables);
                }
            } else {
                changes |= this.myAttributes.contains(Mem.ASYNC_READ);
            }
            newList.add(ATTR_DBUS);
            changes |= this.myAttributes.contains(Mem.LINE_ATTR);
            changes |= this.myAttributes.contains(Mem.ALLOW_MISALIGNED);
        } else {
            newList.add(Mem.LINE_ATTR);
            newList.add(Mem.ALLOW_MISALIGNED);
            newList.add(StdAttr.TRIGGER);
            newList.add(ATTR_DBUS);
            changes |= !this.myAttributes.contains(Mem.LINE_ATTR);
            changes |= !this.myAttributes.contains(Mem.ALLOW_MISALIGNED);
        }
        newList.add(StdAttr.LABEL);
        newList.add(StdAttr.LABEL_FONT);
        newList.add(StdAttr.LABEL_VISIBILITY);
        newList.add(StdAttr.APPEARANCE);
        if (changes) {
            this.myAttributes.clear();
            this.myAttributes.addAll(newList);
        }
        return changes;
    }

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
        RamAttributes d = (RamAttributes)dest;
        d.addrBits = this.addrBits;
        d.dataBits = this.dataBits;
        d.trigger = this.trigger;
        d.busStyle = this.busStyle;
        d.labelFont = this.labelFont;
        d.appearance = this.appearance;
        d.byteEnables = this.byteEnables;
        d.asynchronousRead = this.asynchronousRead;
        d.readWriteBehavior = this.readWriteBehavior;
        d.clearPin = this.clearPin;
        d.lineSize = this.lineSize;
        d.allowMisaligned = this.allowMisaligned;
        d.typeOfEnables = this.typeOfEnables;
        d.ramType = this.ramType;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return this.myAttributes;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == Mem.ADDR_ATTR) {
            return (V)this.addrBits;
        }
        if (attr == Mem.DATA_ATTR) {
            return (V)this.dataBits;
        }
        if (attr == ATTR_TYPE) {
            return (V)this.ramType;
        }
        if (attr == StdAttr.LABEL) {
            return (V)this.label;
        }
        if (attr == StdAttr.TRIGGER) {
            return (V)this.trigger;
        }
        if (attr == Mem.ASYNC_READ) {
            return (V)this.asynchronousRead;
        }
        if (attr == Mem.READ_ATTR) {
            return (V)this.readWriteBehavior;
        }
        if (attr == ATTR_DBUS) {
            return (V)this.busStyle;
        }
        if (attr == StdAttr.LABEL_FONT) {
            return (V)this.labelFont;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            return (V)this.labelVisible;
        }
        if (attr == ATTR_ByteEnables) {
            return (V)this.byteEnables;
        }
        if (attr == StdAttr.APPEARANCE) {
            return (V)this.appearance;
        }
        if (attr == Mem.LINE_ATTR) {
            return (V)this.lineSize;
        }
        if (attr == Mem.ALLOW_MISALIGNED) {
            return (V)this.allowMisaligned;
        }
        if (attr == CLEAR_PIN) {
            return (V)this.clearPin;
        }
        if (attr == Mem.ENABLES_ATTR) {
            return (V)this.typeOfEnables;
        }
        return null;
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        if (attr == Mem.ADDR_ATTR) {
            BitWidth newAddr = (BitWidth)value;
            if (this.addrBits == newAddr) {
                return;
            }
            this.addrBits = newAddr;
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == Mem.DATA_ATTR) {
            BitWidth newData = (BitWidth)value;
            if (this.dataBits == newData) {
                return;
            }
            this.dataBits = newData;
            if (this.typeOfEnables.equals(Mem.USEBYTEENABLES) && this.updateAttributes()) {
                this.fireAttributeListChanged();
            }
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == Mem.ENABLES_ATTR) {
            AttributeOption val = (AttributeOption)value;
            if (!this.typeOfEnables.equals(val)) {
                this.typeOfEnables = val;
                if (this.updateAttributes()) {
                    this.fireAttributeListChanged();
                }
                this.fireAttributeValueChanged(attr, value, null);
            }
        } else if (attr == ATTR_TYPE) {
            AttributeOption val = (AttributeOption)value;
            if (!this.ramType.equals(val)) {
                this.ramType = val;
                this.fireAttributeValueChanged(attr, value, null);
            }
        } else if (attr == StdAttr.LABEL) {
            String newLabel = (String)value;
            if (this.label.equals(newLabel)) {
                return;
            }
            String oldlabel = this.label;
            this.label = newLabel;
            this.fireAttributeValueChanged(attr, value, oldlabel);
        } else if (attr == StdAttr.TRIGGER) {
            AttributeOption newTrigger = (AttributeOption)value;
            if (this.trigger.equals(newTrigger)) {
                return;
            }
            this.trigger = newTrigger;
            if (this.typeOfEnables.equals(Mem.USEBYTEENABLES) && this.updateAttributes()) {
                this.fireAttributeListChanged();
            }
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == Mem.ASYNC_READ) {
            Boolean val = (Boolean)value;
            if (this.asynchronousRead != val) {
                this.asynchronousRead = val;
                if (this.updateAttributes()) {
                    this.fireAttributeListChanged();
                }
                this.fireAttributeValueChanged(attr, value, null);
            }
        } else if (attr == Mem.READ_ATTR) {
            AttributeOption val = (AttributeOption)value;
            if (!this.readWriteBehavior.equals(val)) {
                this.readWriteBehavior = val;
                this.fireAttributeValueChanged(attr, value, null);
            }
        } else if (attr == ATTR_DBUS) {
            AttributeOption newStyle = (AttributeOption)value;
            if (this.busStyle.equals(newStyle)) {
                return;
            }
            this.busStyle = newStyle;
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == StdAttr.LABEL_FONT) {
            Font newFont = (Font)value;
            if (this.labelFont.equals(newFont)) {
                return;
            }
            this.labelFont = newFont;
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == StdAttr.LABEL_VISIBILITY) {
            Boolean newVis = (Boolean)value;
            if (this.labelVisible.equals(newVis)) {
                return;
            }
            this.labelVisible = newVis;
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == ATTR_ByteEnables) {
            AttributeOption newBE = (AttributeOption)value;
            if (this.byteEnables.equals(newBE)) {
                return;
            }
            if (this.dataBits.getWidth() < 9) {
                newBE = BUS_WITHOUT_BYTE_ENABLES;
            }
            this.byteEnables = newBE;
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == CLEAR_PIN) {
            Boolean val = (Boolean)value;
            if (this.clearPin != val) {
                this.clearPin = val;
                this.fireAttributeValueChanged(attr, value, null);
            }
        } else if (attr == Mem.LINE_ATTR) {
            AttributeOption val = (AttributeOption)value;
            if (!this.lineSize.equals(val)) {
                this.lineSize = val;
                this.fireAttributeValueChanged(attr, value, null);
            }
        } else if (attr == Mem.ALLOW_MISALIGNED) {
            Boolean val = (Boolean)value;
            if (this.allowMisaligned != val) {
                this.allowMisaligned = val;
                this.fireAttributeValueChanged(attr, value, null);
            }
        } else if (attr == StdAttr.APPEARANCE) {
            AttributeOption option = (AttributeOption)value;
            if (this.appearance.equals(option)) {
                return;
            }
            this.appearance = option;
            this.fireAttributeValueChanged(attr, value, null);
        }
    }
}

