/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.ShiftRegister;
import com.cburch.logisim.std.memory.ShiftRegisterData;

public class ShiftRegisterLogger
extends InstanceLogger {
    @Override
    public String getLogName(InstanceState state, Object option) {
        Object inName = state.getAttributeValue(StdAttr.LABEL);
        if (inName == null || ((String)inName).equals("")) {
            inName = Strings.S.get("shiftRegisterComponent") + String.valueOf(state.getInstance().getLocation());
        }
        if (option instanceof Integer) {
            return (String)inName + "[" + String.valueOf(option) + "]";
        }
        return inName;
    }

    @Override
    public BitWidth getBitWidth(InstanceState state, Object option) {
        return state.getAttributeValue(StdAttr.WIDTH);
    }

    @Override
    public Object[] getLogOptions(InstanceState state) {
        Integer stages = state.getAttributeValue(ShiftRegister.ATTR_LENGTH);
        Object[] ret = new Object[stages.intValue()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    @Override
    public Value getLogValue(InstanceState state, Object option) {
        ShiftRegisterData data;
        BitWidth dataWidth = state.getAttributeValue(StdAttr.WIDTH);
        if (dataWidth == null) {
            dataWidth = BitWidth.create(0);
        }
        if ((data = (ShiftRegisterData)state.getData()) == null) {
            return Value.createKnown(dataWidth, 0L);
        }
        int index = option == null ? 0 : (Integer)option;
        return data.get(index);
    }
}

