/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.plexers;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.plexers.BitSelector;
import com.cburch.logisim.std.plexers.Decoder;
import com.cburch.logisim.std.plexers.Demultiplexer;
import com.cburch.logisim.std.plexers.Multiplexer;
import com.cburch.logisim.std.plexers.PriorityEncoder;
import com.cburch.logisim.tools.FactoryDescription;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Graphics;
import java.util.List;

public class PlexersLibrary
extends Library {
    public static final String _ID = "Plexers";
    static final AttributeOption SIZE_NARROW = new AttributeOption(20, Strings.S.getter("gateSizeNarrowOpt"));
    static final AttributeOption SIZE_WIDE = new AttributeOption(40, Strings.S.getter("gateSizeWideOpt"));
    public static final Attribute<AttributeOption> ATTR_SIZE = Attributes.forOption("size", Strings.S.getter("gateSizeAttr"), new AttributeOption[]{SIZE_NARROW, SIZE_WIDE});
    public static final Attribute<BitWidth> ATTR_SELECT = Attributes.forBitWidth("select", Strings.S.getter("plexerSelectBitsAttr"), 1, 8);
    public static final Object DEFAULT_SELECT = BitWidth.create(1);
    public static final Attribute<Boolean> ATTR_TRISTATE = Attributes.forBoolean("tristate", Strings.S.getter("plexerThreeStateAttr"));
    public static final Object DEFAULT_TRISTATE = Boolean.FALSE;
    public static final AttributeOption DISABLED_FLOATING = new AttributeOption("Z", Strings.S.getter("plexerDisabledFloating"));
    public static final AttributeOption DISABLED_ZERO = new AttributeOption("0", Strings.S.getter("plexerDisabledZero"));
    public static final Attribute<AttributeOption> ATTR_DISABLED = Attributes.forOption("disabled", Strings.S.getter("plexerDisabledAttr"), new AttributeOption[]{DISABLED_FLOATING, DISABLED_ZERO});
    public static final Attribute<Boolean> ATTR_ENABLE = Attributes.forBoolean("enable", Strings.S.getter("plexerEnableAttr"));
    public static final Object DEFAULT_ENABLE = Boolean.FALSE;
    public static final int DELAY = 3;
    private static final FactoryDescription[] DESCRIPTIONS = new FactoryDescription[]{new FactoryDescription(Multiplexer.class, Strings.S.getter("multiplexerComponent"), "multiplexer.gif"), new FactoryDescription(Demultiplexer.class, Strings.S.getter("demultiplexerComponent"), "demultiplexer.gif"), new FactoryDescription(Decoder.class, Strings.S.getter("decoderComponent"), "decoder.gif"), new FactoryDescription(PriorityEncoder.class, Strings.S.getter("priorityEncoderComponent"), "priencod.gif"), new FactoryDescription(BitSelector.class, Strings.S.getter("bitSelectorComponent"), "bitSelector.gif")};
    private List<Tool> tools = null;

    static boolean contains(Location loc, Bounds bds, Direction facing) {
        if (bds.contains(loc, 1)) {
            int x = loc.getX();
            int y = loc.getY();
            int x0 = bds.getX();
            int x1 = x0 + bds.getWidth();
            int y0 = bds.getY();
            int y1 = y0 + bds.getHeight();
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                if (x < x0 + 5 || x > x1 - 5) {
                    if (facing == Direction.SOUTH) {
                        return y < y0 + 5;
                    }
                    return y > y1 - 5;
                }
                return true;
            }
            if (y < y0 + 5 || y > y1 - 5) {
                if (facing == Direction.EAST) {
                    return x < x0 + 5;
                }
                return x > x1 - 5;
            }
            return true;
        }
        return false;
    }

    static void drawTrapezoid(Graphics g, Bounds bds, Direction facing, int facingLean) {
        int wid = bds.getWidth();
        int ht = bds.getHeight();
        int x0 = bds.getX();
        int x1 = x0 + wid;
        int y0 = bds.getY();
        int y1 = y0 + ht;
        int[] xp = new int[]{x0, x1, x1, x0};
        int[] yp = new int[]{y0, y0, y1, y1};
        if (facing == Direction.WEST) {
            yp[0] = yp[0] + facingLean;
            yp[3] = yp[3] - facingLean;
        } else if (facing == Direction.NORTH) {
            xp[0] = xp[0] + facingLean;
            xp[1] = xp[1] - facingLean;
        } else if (facing == Direction.SOUTH) {
            xp[2] = xp[2] - facingLean;
            xp[3] = xp[3] + facingLean;
        } else {
            yp[1] = yp[1] + facingLean;
            yp[2] = yp[2] - facingLean;
        }
        GraphicsUtil.switchToWidth(g, 2);
        g.drawPolygon(xp, yp, 4);
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("plexerLibrary");
    }

    public List<Tool> getTools() {
        if (this.tools == null) {
            this.tools = FactoryDescription.getTools(PlexersLibrary.class, DESCRIPTIONS);
        }
        return this.tools;
    }
}

