/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.tcl;

import com.cburch.hdl.HdlModel;
import com.cburch.hdl.HdlModelListener;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.hdl.VhdlContentComponent;
import com.cburch.logisim.std.tcl.TclComponent;
import com.cburch.logisim.std.tcl.TclGenericAttributes;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.util.WeakHashMap;

public class TclGeneric
extends TclComponent {
    public static final String _ID = "TclGeneric";
    static final Attribute<VhdlContentComponent> CONTENT_ATTR = new ContentAttribute();
    private final WeakHashMap<Instance, TclGenericListener> contentListeners = new WeakHashMap();

    public TclGeneric() {
        super(_ID, Strings.S.getter("tclGeneric"));
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        VhdlContentComponent content = instance.getAttributeValue(CONTENT_ATTR);
        TclGenericListener listener = new TclGenericListener(instance);
        this.contentListeners.put(instance, listener);
        content.addHdlModelListener(listener);
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new TclGenericAttributes();
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("tclGeneric");
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        VhdlContentComponent content = attrs.getValue(CONTENT_ATTR);
        int nbInputs = content.getInputsNumber();
        int nbOutputs = content.getOutputsNumber();
        return Bounds.create(0, 0, 140, Math.max(nbInputs, nbOutputs) * 10 + 40);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == CONTENT_ATTR) {
            this.updatePorts(instance);
            instance.recomputeBounds();
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        int i;
        Graphics g = painter.getGraphics();
        VhdlContentComponent content = painter.getAttributeValue(CONTENT_ATTR);
        FontMetrics metric = g.getFontMetrics();
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        Bounds bds = painter.getBounds();
        int x0 = bds.getX() + bds.getWidth() / 2;
        int y0 = bds.getY() + metric.getHeight() + 12;
        GraphicsUtil.drawText(g, StringUtil.resizeString(content.getName(), metric, 140), x0, y0, 0, 2);
        String glbLabel = painter.getAttributeValue(StdAttr.LABEL);
        if (glbLabel != null) {
            Font font = g.getFont();
            g.setFont(painter.getAttributeValue(StdAttr.LABEL_FONT));
            GraphicsUtil.drawCenteredText(g, glbLabel, bds.getX() + bds.getWidth() / 2, bds.getY() - g.getFont().getSize());
            g.setFont(font);
        }
        g.setFont(g.getFont().deriveFont(10.0f));
        metric = g.getFontMetrics();
        HdlModel.PortDescription[] inputs = content.getInputs();
        HdlModel.PortDescription[] outputs = content.getOutputs();
        for (i = 0; i < inputs.length; ++i) {
            GraphicsUtil.drawText(g, StringUtil.resizeString(inputs[i].getName(), metric, 65), bds.getX() + 5, bds.getY() + 40 - 2 + i * 10, -1, 0);
        }
        for (i = 0; i < outputs.length; ++i) {
            GraphicsUtil.drawText(g, StringUtil.resizeString(outputs[i].getName(), metric, 65), bds.getX() + 140 - 5, bds.getY() + 40 - 2 + i * 10, 1, 0);
        }
        painter.drawBounds();
        painter.drawPorts();
    }

    @Override
    void updatePorts(Instance instance) {
        VhdlContentComponent content = instance.getAttributeValue(CONTENT_ATTR);
        HdlModel.PortDescription[] inputs = content.getInputs();
        HdlModel.PortDescription[] outputs = content.getOutputs();
        Port[] result = new Port[inputs.length + outputs.length];
        int resultIndex = 0;
        int i = 0;
        for (HdlModel.PortDescription desc : inputs) {
            result[resultIndex] = new Port(0, i * 10 + 40, desc.getType(), desc.getWidth());
            result[resultIndex].setToolTip(Strings.S.getter(desc.getName()));
            ++resultIndex;
            ++i;
        }
        i = 0;
        for (HdlModel.PortDescription desc : outputs) {
            result[resultIndex] = new Port(140, i * 10 + 40, desc.getType(), desc.getWidth());
            result[resultIndex].setToolTip(Strings.S.getter(desc.getName()));
            ++resultIndex;
            ++i;
        }
        instance.setPorts(result);
        this.setPorts(result);
    }

    static class TclGenericListener
    implements HdlModelListener {
        final Instance instance;

        TclGenericListener(Instance instance) {
            this.instance = instance;
        }

        @Override
        public void contentSet(HdlModel source) {
            this.instance.fireInvalidated();
            this.instance.recomputeBounds();
        }
    }

    static class ContentAttribute
    extends Attribute<VhdlContentComponent> {
        public ContentAttribute() {
            super("content", Strings.S.getter("tclInterfaceDefinition"));
        }

        @Override
        public Component getCellEditor(Window source, VhdlContentComponent value) {
            Project project;
            if (source instanceof Frame) {
                Frame frame = (Frame)source;
                project = frame.getProject();
            } else {
                project = null;
            }
            Project proj = project;
            return TclGenericAttributes.getContentEditor(source, value, proj);
        }

        @Override
        public VhdlContentComponent parse(String value) {
            VhdlContentComponent content = VhdlContentComponent.create();
            if (!content.compare(value)) {
                content.setContent(value);
            }
            return content;
        }

        @Override
        public String toDisplayString(VhdlContentComponent value) {
            return Strings.S.get("tclInterfaceDefinitionValue");
        }

        @Override
        public String toStandardString(VhdlContentComponent value) {
            return value.getContent();
        }
    }
}

