/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashSet;

public abstract class AbstractTtlGate
extends InstanceFactory {
    protected static final int PIN_WIDTH = 10;
    protected static final int PIN_HEIGHT = 7;
    private int height = 60;
    protected final byte pinNumber;
    private final String name;
    private byte numberOfGatesToDraw = 0;
    protected String[] portNames = null;
    private final HashSet<Byte> outputPorts = new HashSet();
    private final HashSet<Byte> unusedPins = new HashSet();

    protected AbstractTtlGate(String name, byte pins, byte[] outputPorts, HdlGeneratorFactory generator) {
        super(name, generator);
        this.setIconName("ttl.gif");
        this.setAttributes(new Attribute[]{StdAttr.FACING, TtlLibrary.VCC_GND, TtlLibrary.DRAW_INTERNAL_STRUCTURE, StdAttr.LABEL}, new Object[]{Direction.EAST, false, false, ""});
        this.setFacingAttribute(StdAttr.FACING);
        this.name = name;
        this.pinNumber = pins;
        for (byte outputport : outputPorts) {
            this.outputPorts.add(outputport);
        }
    }

    protected AbstractTtlGate(String name, byte pins, byte[] outputPorts, byte[] notUsedPins, HdlGeneratorFactory generator) {
        this(name, pins, outputPorts, generator);
        if (notUsedPins == null) {
            return;
        }
        for (byte notUsedPin : notUsedPins) {
            this.unusedPins.add(notUsedPin);
        }
    }

    protected AbstractTtlGate(String name, byte pins, byte[] outputPorts, boolean drawgates, HdlGeneratorFactory generator) {
        this(name, pins, outputPorts, generator);
        this.numberOfGatesToDraw = (byte)(drawgates ? outputPorts.length : 0);
    }

    protected AbstractTtlGate(String name, byte pins, byte[] outputPorts, String[] ttlPortNames, HdlGeneratorFactory generator) {
        this(name, pins, outputPorts, generator);
        this.portNames = ttlPortNames;
    }

    protected AbstractTtlGate(String name, byte pins, byte[] outputPorts, byte[] notUsedPins, String[] ttlPortNames, HdlGeneratorFactory generator) {
        this(name, pins, outputPorts, generator);
        this.portNames = ttlPortNames;
        if (notUsedPins == null) {
            return;
        }
        for (byte notUsedPin : notUsedPins) {
            this.unusedPins.add(notUsedPin);
        }
    }

    protected AbstractTtlGate(String name, byte pins, byte[] outputPorts, String[] ttlPortNames, int height, HdlGeneratorFactory generator) {
        this(name, pins, outputPorts, generator);
        this.height = height;
        this.portNames = ttlPortNames;
    }

    private void computeTextField(Instance instance) {
        Bounds bds = instance.getBounds();
        Direction dir = instance.getAttributeValue(StdAttr.FACING);
        if (dir == Direction.EAST || dir == Direction.WEST) {
            instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, bds.getX() + bds.getWidth() + 3, bds.getY() + bds.getHeight() / 2, -1, 3);
        } else {
            instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, bds.getX() + bds.getWidth() / 2, bds.getY() - 3, 0, 3);
        }
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
        this.computeTextField(instance);
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction dir = attrs.getValue(StdAttr.FACING);
        return Bounds.create(0, -30, this.pinNumber * 10, this.height).rotate(Direction.EAST, dir, 0, 0);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            this.updatePorts(instance);
            this.computeTextField(instance);
        } else if (attr == TtlLibrary.VCC_GND) {
            this.updatePorts(instance);
        }
    }

    static Point getTranslatedTtlXY(InstanceState state, MouseEvent e) {
        int x = 0;
        int y = 0;
        Location loc = state.getInstance().getLocation();
        int height = state.getInstance().getBounds().getHeight();
        int width = state.getInstance().getBounds().getWidth();
        Direction dir = state.getAttributeValue(StdAttr.FACING);
        if (dir.equals(Direction.EAST)) {
            x = e.getX() - loc.getX();
            y = e.getY() + 30 - loc.getY();
        } else if (dir.equals(Direction.WEST)) {
            x = loc.getX() - e.getX();
            y = height - (e.getY() + (height - 30) - loc.getY());
        } else if (dir.equals(Direction.NORTH)) {
            x = loc.getY() - e.getY();
            y = width - (loc.getX() + (width - 30) - e.getX());
        } else {
            x = e.getY() - loc.getY();
            y = loc.getX() + 30 - e.getX();
        }
        return new Point(x, y);
    }

    protected void paintBase(InstancePainter painter, boolean drawname, boolean ghost) {
        Direction dir = painter.getAttributeValue(StdAttr.FACING);
        Graphics2D g = (Graphics2D)painter.getGraphics();
        Bounds bds = painter.getBounds();
        int x = bds.getX();
        int y = bds.getY();
        int xp = x;
        int yp = y;
        int width = bds.getWidth();
        int height = bds.getHeight();
        if (!ghost) {
            g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        }
        for (byte i = 0; i < this.pinNumber; i = (byte)(i + 1)) {
            if (i < this.pinNumber / 2) {
                if (dir == Direction.WEST || dir == Direction.EAST) {
                    xp = i * 20 + 5 + x;
                } else {
                    yp = i * 20 + 5 + y;
                }
            } else if (dir == Direction.WEST || dir == Direction.EAST) {
                xp = (i - this.pinNumber / 2) * 20 + 5 + x;
                yp = height + y - 7;
            } else {
                yp = (i - this.pinNumber / 2) * 20 + 5 + y;
                xp = width + x - 7;
            }
            if (dir == Direction.WEST || dir == Direction.EAST) {
                g.drawRect(xp, yp, 10, 7);
                continue;
            }
            g.drawRect(xp, yp, 7, 10);
        }
        if (dir == Direction.SOUTH) {
            g.drawRoundRect(x + 7, y, bds.getWidth() - 14, bds.getHeight(), 10, 10);
            g.drawArc(x + width / 2 - 7, y - 7, 14, 14, 180, 180);
        } else if (dir == Direction.WEST) {
            g.drawRoundRect(x, y + 7, bds.getWidth(), bds.getHeight() - 14, 10, 10);
            g.drawArc(x + width - 7, y + height / 2 - 7, 14, 14, 90, 180);
        } else if (dir == Direction.NORTH) {
            g.drawRoundRect(x + 7, y, bds.getWidth() - 14, bds.getHeight(), 10, 10);
            g.drawArc(x + width / 2 - 7, y + height - 7, 14, 14, 0, 180);
        } else {
            g.drawRoundRect(x, y + 7, bds.getWidth(), bds.getHeight() - 14, 10, 10);
            g.drawArc(x - 7, y + height / 2 - 7, 14, 14, 270, 180);
        }
        g.rotate(Math.toRadians(-dir.toDegrees()), x + width / 2, y + height / 2);
        if (drawname) {
            g.setFont(new Font("DialogInput", 1, 14));
            GraphicsUtil.drawCenteredText(g, this.name, x + bds.getWidth() / 2, y + bds.getHeight() / 2 - 4);
        }
        if (dir == Direction.WEST || dir == Direction.EAST) {
            xp = x;
            yp = y;
        } else {
            xp = x + (width - height) / 2;
            yp = y + (height - width) / 2;
            width = bds.getHeight();
            height = bds.getWidth();
        }
        g.setFont(new Font("DialogInput", 1, 7));
        GraphicsUtil.drawCenteredText(g, "Vcc", xp + 10, yp + 7 + 4);
        GraphicsUtil.drawCenteredText(g, "GND", xp + width - 10, yp + height - 7 - 7);
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        this.paintBase(painter, true, true);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        painter.drawPorts();
        Graphics2D g = (Graphics2D)painter.getGraphics();
        painter.drawLabel();
        if (!painter.getAttributeValue(TtlLibrary.DRAW_INTERNAL_STRUCTURE).booleanValue()) {
            Direction dir = painter.getAttributeValue(StdAttr.FACING);
            Bounds bds = painter.getBounds();
            int x = bds.getX();
            int y = bds.getY();
            int xp = x;
            int yp = y;
            int width = bds.getWidth();
            int height = bds.getHeight();
            for (byte i = 0; i < this.pinNumber; i = (byte)(i + 1)) {
                if (i == this.pinNumber / 2) {
                    xp = x;
                    yp = y;
                    if (dir == Direction.WEST || dir == Direction.EAST) {
                        g.setColor(Color.DARK_GRAY.darker());
                        g.fillRoundRect(xp, yp + 7, width, height - 14 + 2, 10, 10);
                        g.setColor(Color.DARK_GRAY);
                        g.fillRoundRect(xp, yp + 7, width, height - 14 - 2, 10, 10);
                        g.setColor(Color.BLACK);
                        g.drawRoundRect(xp, yp + 7, width, height - 14 - 2, 10, 10);
                        g.drawRoundRect(xp, yp + 7, width, height - 14 + 2, 10, 10);
                    } else {
                        g.setColor(Color.DARK_GRAY.darker());
                        g.fillRoundRect(xp + 7, yp, width - 14, height, 10, 10);
                        g.setColor(Color.DARK_GRAY);
                        g.fillRoundRect(xp + 7, yp, width - 14, height - 4, 10, 10);
                        g.setColor(Color.BLACK);
                        g.drawRoundRect(xp + 7, yp, width - 14, height - 4, 10, 10);
                        g.drawRoundRect(xp + 7, yp, width - 14, height, 10, 10);
                    }
                    if (dir == Direction.SOUTH) {
                        g.fillArc(xp + width / 2 - 7, yp - 7, 14, 14, 180, 180);
                    } else if (dir == Direction.WEST) {
                        g.fillArc(xp + width - 7, yp + height / 2 - 7, 14, 14, 90, 180);
                    } else if (dir == Direction.NORTH) {
                        g.fillArc(xp + width / 2 - 7, yp + height - 11, 14, 14, 0, 180);
                    } else {
                        g.fillArc(xp - 7, yp + height / 2 - 7, 14, 14, 270, 180);
                    }
                }
                if (i < this.pinNumber / 2) {
                    if (dir == Direction.WEST || dir == Direction.EAST) {
                        xp = i * 20 + 5 + x;
                    } else {
                        yp = i * 20 + 5 + y;
                    }
                } else if (dir == Direction.WEST || dir == Direction.EAST) {
                    xp = (i - this.pinNumber / 2) * 20 + 5 + x;
                    yp = height + y - 7;
                } else {
                    yp = (i - this.pinNumber / 2) * 20 + 5 + y;
                    xp = width + x - 7;
                }
                if (dir == Direction.WEST || dir == Direction.EAST) {
                    g.setColor(Color.LIGHT_GRAY);
                    g.fillRect(xp, yp, 10, 7);
                    g.setColor(Color.BLACK);
                    g.drawRect(xp, yp, 10, 7);
                    continue;
                }
                g.setColor(Color.LIGHT_GRAY);
                g.fillRect(xp, yp, 7, 10);
                g.setColor(Color.BLACK);
                g.drawRect(xp, yp, 7, 10);
            }
            g.setColor(Color.LIGHT_GRAY.brighter());
            g.rotate(Math.toRadians(-dir.toDegrees()), x + width / 2, y + height / 2);
            g.setFont(new Font("DialogInput", 1, 14));
            GraphicsUtil.drawCenteredText(g, this.name, x + width / 2, y + height / 2 - 4);
            g.setFont(new Font("DialogInput", 1, 7));
            if (dir == Direction.WEST || dir == Direction.EAST) {
                xp = x;
                yp = y;
            } else {
                xp = x + (width - height) / 2;
                yp = y + (height - width) / 2;
            }
            if (dir == Direction.SOUTH) {
                GraphicsUtil.drawCenteredText(g, "Vcc", xp + 10, yp + 7 + 4);
                GraphicsUtil.drawCenteredText(g, "GND", xp + height - 14, yp + width - 7 - 8);
            } else if (dir == Direction.WEST) {
                GraphicsUtil.drawCenteredText(g, "Vcc", xp + 10, yp + 7 + 6);
                GraphicsUtil.drawCenteredText(g, "GND", xp + width - 10, yp + height - 7 - 8);
            } else if (dir == Direction.NORTH) {
                GraphicsUtil.drawCenteredText(g, "Vcc", xp + 14, yp + 7 + 4);
                GraphicsUtil.drawCenteredText(g, "GND", xp + height - 10, yp + width - 7 - 8);
            } else {
                GraphicsUtil.drawCenteredText(g, "Vcc", xp + 10, yp + 7 + 4);
                GraphicsUtil.drawCenteredText(g, "GND", xp + width - 10, yp + height - 7 - 10);
            }
        } else {
            this.paintInternalBase(painter);
        }
    }

    public abstract void paintInternal(InstancePainter var1, int var2, int var3, int var4, boolean var5);

    private void paintInternalBase(InstancePainter painter) {
        Direction dir = painter.getAttributeValue(StdAttr.FACING);
        Bounds bds = painter.getBounds();
        int x = bds.getX();
        int y = bds.getY();
        int width = bds.getWidth();
        int height = bds.getHeight();
        if (dir == Direction.SOUTH || dir == Direction.NORTH) {
            x += (width - height) / 2;
            y += (height - width) / 2;
            width = bds.getHeight();
            height = bds.getWidth();
        }
        if (this.numberOfGatesToDraw == 0) {
            this.paintInternal(painter, x, y, height, false);
        } else {
            this.paintBase(painter, false, false);
            for (int i = 0; i < this.numberOfGatesToDraw; i = (int)((byte)(i + 1))) {
                this.paintInternal(painter, x + (i < this.numberOfGatesToDraw / 2 ? i : i - this.numberOfGatesToDraw / 2) * ((width - 20) / (this.numberOfGatesToDraw / 2)) + (i < this.numberOfGatesToDraw / 2 ? 0 : 20), y, height, i >= this.numberOfGatesToDraw / 2);
            }
        }
    }

    @Override
    public void propagate(InstanceState state) {
        int NrOfUnusedPins = this.unusedPins.size();
        if (state.getAttributeValue(TtlLibrary.VCC_GND).booleanValue() && (state.getPortValue(this.pinNumber - 2 - NrOfUnusedPins) != Value.FALSE || state.getPortValue(this.pinNumber - 1 - NrOfUnusedPins) != Value.TRUE)) {
            int port = 0;
            for (byte i = 1; i <= this.pinNumber; i = (byte)(i + 1)) {
                if (this.unusedPins.contains(i) || i == this.pinNumber / 2) continue;
                if (this.outputPorts.contains(i)) {
                    state.setPort(port, Value.UNKNOWN, 1);
                }
                ++port;
            }
        } else {
            this.propagateTtl(state);
        }
    }

    public abstract void propagateTtl(InstanceState var1);

    private void updatePorts(Instance instance) {
        Bounds bds = instance.getBounds();
        Direction dir = instance.getAttributeValue(StdAttr.FACING);
        int dx = 0;
        int dy = 0;
        int width = bds.getWidth();
        int height = bds.getHeight();
        int portindex = 0;
        boolean isoutput = false;
        Boolean hasvccgnd = instance.getAttributeValue(TtlLibrary.VCC_GND);
        boolean skip = false;
        int NrOfUnusedPins = this.unusedPins.size();
        Port[] ps = new Port[hasvccgnd != false ? this.pinNumber - NrOfUnusedPins : this.pinNumber - 2 - NrOfUnusedPins];
        for (byte i = 0; i < this.pinNumber; i = (byte)(i + 1)) {
            isoutput = this.outputPorts.contains((byte)(i + 1));
            skip = this.unusedPins.contains((byte)(i + 1));
            if (i < this.pinNumber / 2) {
                if (dir == Direction.EAST) {
                    dx = i * 20 + 10;
                    dy = height - 30;
                } else if (dir == Direction.WEST) {
                    dx = -10 - 20 * i;
                    dy = 30 - height;
                } else if (dir == Direction.NORTH) {
                    dx = width - 30;
                    dy = -10 - 20 * i;
                } else {
                    dx = 30 - width;
                    dy = i * 20 + 10;
                }
            } else if (dir == Direction.EAST) {
                dx = width - (i - this.pinNumber / 2) * 20 - 10;
                dy = -30;
            } else if (dir == Direction.WEST) {
                dx = -width + (i - this.pinNumber / 2) * 20 + 10;
                dy = 30;
            } else if (dir == Direction.NORTH) {
                dx = -30;
                dy = -height + (i - this.pinNumber / 2) * 20 + 10;
            } else {
                dx = 30;
                dy = height - (i - this.pinNumber / 2) * 20 - 10;
            }
            if (skip) {
                portindex = (byte)(portindex - 1);
            } else if (isoutput) {
                ps[portindex] = new Port(dx, dy, "output", 1);
                if (this.portNames == null || this.portNames.length <= portindex) {
                    ps[portindex].setToolTip(Strings.S.getter("demultiplexerOutTip", ": " + (i + 1)));
                } else {
                    ps[portindex].setToolTip(Strings.S.getter("demultiplexerOutTip", i + 1 + ": " + this.portNames[portindex]));
                }
            } else if (hasvccgnd.booleanValue() && i == this.pinNumber - 1) {
                ps[ps.length - 1] = new Port(dx, dy, "input", 1);
                ps[ps.length - 1].setToolTip(Strings.S.getter("VCCPin", Integer.toString(this.pinNumber)));
            } else if (i == this.pinNumber / 2 - 1) {
                if (hasvccgnd.booleanValue()) {
                    ps[ps.length - 2] = new Port(dx, dy, "input", 1);
                    ps[ps.length - 2].setToolTip(Strings.S.getter("GNDPin", Integer.toString(this.pinNumber / 2)));
                }
                portindex = (byte)(portindex - 1);
            } else if (i != this.pinNumber - 1 && i != this.pinNumber / 2 - 1) {
                ps[portindex] = new Port(dx, dy, "input", 1);
                if (this.portNames == null || this.portNames.length <= portindex) {
                    ps[portindex].setToolTip(Strings.S.getter("multiplexerInTip", ": " + (i + 1)));
                } else {
                    ps[portindex].setToolTip(Strings.S.getter("multiplexerInTip", i + 1 + ": " + this.portNames[portindex]));
                }
            }
            portindex = (byte)(portindex + 1);
        }
        instance.setPorts(ps);
    }

    @Override
    public final void paintIcon(InstancePainter painter) {
        Graphics2D g = (Graphics2D)painter.getGraphics().create();
        g.setColor(Color.DARK_GRAY.brighter());
        GraphicsUtil.switchToWidth(g, AppPreferences.getScaled(1));
        g.fillRoundRect(AppPreferences.getScaled(4), 0, AppPreferences.getScaled(8), AppPreferences.getScaled(16), AppPreferences.getScaled(3), AppPreferences.getScaled(3));
        g.setColor(Color.black);
        g.drawRoundRect(AppPreferences.getScaled(4), 0, AppPreferences.getScaled(8), AppPreferences.getScaled(16), AppPreferences.getScaled(3), AppPreferences.getScaled(3));
        int wh1 = AppPreferences.getScaled(3);
        int wh2 = AppPreferences.getScaled(2);
        for (int y = 0; y < 3; ++y) {
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(wh2, AppPreferences.getScaled(y * 5 + 1), wh1, wh1);
            g.fillRect(AppPreferences.getScaled(12), AppPreferences.getScaled(y * 5 + 1), wh1, wh1);
            g.setColor(Color.BLACK);
            g.drawRect(wh2, AppPreferences.getScaled(y * 5 + 1), wh1, wh1);
            g.drawRect(AppPreferences.getScaled(12), AppPreferences.getScaled(y * 5 + 1), wh1, wh1);
        }
        g.drawRoundRect(AppPreferences.getScaled(6), 0, AppPreferences.getScaled(6), AppPreferences.getScaled(16), AppPreferences.getScaled(3), AppPreferences.getScaled(3));
        g.dispose();
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        return CorrectLabel.getCorrectLabel("TTL" + this.getName()).toUpperCase();
    }
}

