/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Graphics;

public class Drawgates {
    public static void paintAnd(Graphics g, int x, int y, int width, int height, boolean negated) {
        if (negated) {
            Drawgates.paintNegatedOutput(g, x, y);
        }
        if (AppPreferences.GATE_SHAPE.get().equals("rectangular")) {
            g.drawRect(x - width, y - height / 2, width, height);
            GraphicsUtil.drawCenteredText(g, "&", x - width / 2, y);
        } else {
            int[] xp = new int[]{x - width / 2, x - width, x - width, x - width / 2};
            int[] yp = new int[]{y - width / 2, y - width / 2, y + width / 2, y + width / 2};
            GraphicsUtil.drawCenteredArc(g, x - width / 2, y, width / 2, -90, 180);
            g.drawPolyline(xp, yp, 4);
            if (height > width) {
                g.drawLine(x - width, y - height / 2, x - width, y + height / 2);
            }
        }
    }

    static void paintBuffer(Graphics g, int x, int y, int width, int height) {
        int[] xp = new int[4];
        int[] yp = new int[4];
        xp[0] = x - 4;
        yp[0] = y;
        xp[1] = x - width;
        yp[1] = y - height / 2;
        xp[2] = x - width;
        yp[2] = y + height / 2;
        xp[3] = x - 4;
        yp[3] = y;
        g.drawPolyline(xp, yp, 4);
    }

    static void paintDoubleInputgate(Graphics gfx, int rightPinX, int y, int inputX, int outputY, int portHeight, boolean up, boolean rightToLeft, int height) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int[] nArray4;
        if (!rightToLeft) {
            int[] nArray5 = new int[5];
            nArray5[0] = rightPinX;
            nArray5[1] = rightPinX;
            nArray5[2] = rightPinX - 10;
            nArray5[3] = rightPinX - 10;
            nArray4 = nArray5;
            nArray5[4] = inputX;
        } else {
            int[] nArray6 = new int[5];
            nArray6[0] = rightPinX - 20;
            nArray6[1] = rightPinX - 20;
            nArray6[2] = rightPinX - 10;
            nArray6[3] = rightPinX - 10;
            nArray4 = nArray6;
            nArray6[4] = inputX;
        }
        int[] xPoints = nArray4;
        if (!up) {
            int[] nArray7 = new int[5];
            nArray7[0] = y + height - 7;
            nArray7[1] = y + height - 7 - 3;
            nArray7[2] = y + height - 7 - 3;
            nArray7[3] = outputY + portHeight / 3;
            nArray3 = nArray7;
            nArray7[4] = outputY + portHeight / 3;
        } else {
            int[] nArray8 = new int[5];
            nArray8[0] = y + 7;
            nArray8[1] = y + 7 + 3;
            nArray8[2] = y + 7 + 3;
            nArray8[3] = outputY - portHeight / 3;
            nArray3 = nArray8;
            nArray8[4] = outputY - portHeight / 3;
        }
        int[] yPoints = nArray3;
        gfx.drawPolyline(xPoints, yPoints, 5);
        if (!rightToLeft) {
            int[] nArray9 = new int[3];
            nArray9[0] = rightPinX - 20;
            nArray9[1] = rightPinX - 20;
            nArray2 = nArray9;
            nArray9[2] = inputX;
        } else {
            int[] nArray10 = new int[3];
            nArray10[0] = rightPinX;
            nArray10[1] = rightPinX;
            nArray2 = nArray10;
            nArray10[2] = inputX;
        }
        xPoints = nArray2;
        if (!up) {
            int[] nArray11 = new int[3];
            nArray11[0] = y + height - 7;
            nArray11[1] = outputY - portHeight / 3;
            nArray = nArray11;
            nArray11[2] = outputY - portHeight / 3;
        } else {
            int[] nArray12 = new int[3];
            nArray12[0] = y + 7;
            nArray12[1] = outputY + portHeight / 3;
            nArray = nArray12;
            nArray12[2] = outputY + portHeight / 3;
        }
        yPoints = nArray;
        gfx.drawPolyline(xPoints, yPoints, 3);
    }

    private static void paintNegatedOutput(Graphics g, int x, int y) {
        g.drawOval(x, y - 2, 4, 4);
    }

    static void paintNot(Graphics g, int x, int y, int width, int height) {
        Drawgates.paintNegatedOutput(g, x - 4, y);
        if (AppPreferences.GATE_SHAPE.get().equals("rectangular")) {
            g.drawRect(x - width, y - (width - 4) / 2, width - 4, width - 4);
            GraphicsUtil.drawCenteredText(g, "1", x - 4 - (width - 4) / 2, y);
        } else {
            int[] xp = new int[4];
            int[] yp = new int[4];
            xp[0] = x - 4;
            yp[0] = y;
            xp[1] = x - width;
            yp[1] = y - height / 2;
            xp[2] = x - width;
            yp[2] = y + height / 2;
            xp[3] = x - 4;
            yp[3] = y;
            g.drawPolyline(xp, yp, 4);
        }
    }

    static void paintOr(Graphics g, int x, int y, int width, int height, boolean negated, boolean rightToLeft) {
        int offset;
        int n = offset = rightToLeft ? -4 : 0;
        if (negated) {
            Drawgates.paintNegatedOutput(g, x + offset, y);
        }
        if (AppPreferences.GATE_SHAPE.get().equals("rectangular")) {
            if (!rightToLeft) {
                g.drawRect(x - width, y - height / 2, width, height);
                GraphicsUtil.drawCenteredText(g, "\u22651", x - width / 2, y);
            } else {
                g.drawRect(x, y - height / 2, width, height);
                GraphicsUtil.drawCenteredText(g, "\u22651", x + width / 2, y);
            }
        } else if (!rightToLeft) {
            GraphicsUtil.drawCenteredArc(g, x - 14, y - 10, 17, -90, 54);
            GraphicsUtil.drawCenteredArc(g, x - 14, y + 10, 17, 90, -54);
            GraphicsUtil.drawCenteredArc(g, x - 28, y, 15, -27, 54);
        } else {
            GraphicsUtil.drawCenteredArc(g, x + 14, y - 10, 17, -90, -54);
            GraphicsUtil.drawCenteredArc(g, x + 14, y + 10, 17, 90, 54);
            GraphicsUtil.drawCenteredArc(g, x + 28, y, 15, 153, 54);
        }
    }

    static void paintOutputgate(Graphics g, int xpin, int y, int xoutput, int youtput, boolean up, int height) {
        int[] nArray;
        int[] xPoints = new int[]{xoutput, xpin, xpin};
        if (!up) {
            int[] nArray2 = new int[3];
            nArray2[0] = youtput;
            nArray2[1] = youtput;
            nArray = nArray2;
            nArray2[2] = y + height - 7;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = youtput;
            nArray3[1] = youtput;
            nArray = nArray3;
            nArray3[2] = y + 7;
        }
        int[] yPoints = nArray;
        g.drawPolyline(xPoints, yPoints, 3);
    }

    static void paintPortNames(InstancePainter painter, int x, int y, int height, String[] portNames) {
        Graphics gfx = painter.getGraphics();
        int portsPerRow = portNames.length / 2;
        gfx.drawRect(x + 10, y + 7 + 10, portNames.length * 10, height - 14 - 20);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < portsPerRow; ++j) {
                GraphicsUtil.drawCenteredText(gfx, portNames[j + i * portsPerRow], i == 0 ? x + 10 + j * 20 : x + 20 * portsPerRow - j * 20 + 10, y + height - 7 - 7 - i * (height - 14 - 11));
            }
        }
    }

    static void paintSingleInputgate(Graphics g, int xpin, int y, int xinput, int youtput, boolean up, int height) {
        int[] nArray;
        int[] xPoints = new int[]{xpin, xpin, xinput};
        if (!up) {
            int[] nArray2 = new int[3];
            nArray2[0] = y + height - 7;
            nArray2[1] = youtput;
            nArray = nArray2;
            nArray2[2] = youtput;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = y + 7;
            nArray3[1] = youtput;
            nArray = nArray3;
            nArray3[2] = youtput;
        }
        int[] yPoints = nArray;
        g.drawPolyline(xPoints, yPoints, 3);
    }

    static void paintXor(Graphics g, int x, int y, int width, int height, boolean negated) {
        if (AppPreferences.GATE_SHAPE.get().equals("rectangular")) {
            if (negated) {
                Drawgates.paintNegatedOutput(g, x, y);
            }
            g.drawRect(x - width, y - height / 2, width, height);
            GraphicsUtil.drawCenteredText(g, "=1", x - width / 2, y);
        } else {
            Drawgates.paintOr(g, x, y, width, height, negated, false);
            GraphicsUtil.drawCenteredArc(g, x - 32, y, 15, -27, 54);
        }
    }

    static void paintOpenCollector(Graphics g, int x, int y) {
        g.drawPolyline(new int[]{x, x + 3, x + 6, x + 3, x}, new int[]{y, y + 3, y, y - 3, y}, 5);
        g.drawLine(x, y + 3, x + 6, y + 3);
    }
}

