/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.wiring;

import com.cburch.logisim.LogisimVersion;
import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.prefs.PrefMonitorBooleanConvert;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.std.wiring.ProbeAttributes;
import com.cburch.logisim.tools.key.DirectionConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Objects;

public class Probe
extends InstanceFactory {
    public static final String _ID = "Probe";
    public static final Probe FACTORY = new Probe();

    public static Bounds getOffsetBounds(Direction dir, BitWidth width, RadixOption radix, boolean NewLayout, boolean IsPin) {
        int y;
        int x;
        int bheight;
        int bwidth;
        int len;
        int n = len = radix == null || radix == RadixOption.RADIX_2 ? width.getWidth() : radix.getMaxLength(width);
        if (radix == RadixOption.RADIX_2) {
            int maxBitsPerRow = 8;
            int maxRows = 8;
            int rows = len / maxBitsPerRow;
            if (len > rows * maxBitsPerRow) {
                ++rows;
            }
            int n2 = len < 2 ? 20 : (bwidth = len >= maxBitsPerRow ? maxBitsPerRow * 10 : len * 10);
            bheight = rows < 2 ? 20 : (rows >= maxRows ? maxRows * 20 : rows * 20);
        } else {
            bwidth = len < 2 ? 20 : len * 8;
            bheight = 20;
        }
        if (NewLayout) {
            bwidth += len == 1 ? 20 : 25;
        }
        bwidth = (bwidth + 9) / 10 * 10;
        if (dir == Direction.EAST) {
            x = -bwidth;
            y = -(bheight / 2);
        } else if (dir == Direction.WEST) {
            x = 0;
            y = -(bheight / 2);
        } else if (dir == Direction.SOUTH) {
            if (NewLayout && IsPin) {
                x = bwidth;
                bwidth = bheight;
                bheight = x;
            }
            x = -(bwidth / 2);
            y = -bheight;
        } else {
            if (NewLayout && IsPin) {
                x = bwidth;
                bwidth = bheight;
                bheight = x;
            }
            x = -(bwidth / 2);
            y = 0;
        }
        return Bounds.create(x, y, bwidth, bheight);
    }

    private static Value getValue(InstanceState state) {
        StateData data = (StateData)state.getData();
        return data == null ? Value.NIL : data.curValue;
    }

    static void paintValue(InstancePainter painter, Value value) {
        if (painter.getAttributeValue(ProbeAttributes.PROBEAPPEARANCE) == ProbeAttributes.APPEAR_EVOLUTION_NEW) {
            Probe.paintValue(painter, value, false);
        } else {
            Probe.paintOldStyleValue(painter, value);
        }
    }

    static void paintOldStyleValue(InstancePainter painter, Value value) {
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        RadixOption radix = painter.getAttributeValue(RadixOption.ATTRIBUTE);
        if (radix == null || radix == RadixOption.RADIX_2) {
            int x = bds.getX();
            int y = bds.getY();
            int wid = value.getWidth();
            if (wid == 0) {
                GraphicsUtil.switchToWidth(g, 2);
                g.drawLine((x += bds.getWidth() / 2) - 4, y += bds.getHeight() / 2, x + 4, y);
                return;
            }
            int x0 = bds.getX() + bds.getWidth() - 5;
            int compWidth = wid * 10;
            if (compWidth < bds.getWidth() - 3) {
                x0 = bds.getX() + (bds.getWidth() + compWidth) / 2 - 5;
            }
            int cx = x0;
            int cy = bds.getY() + bds.getHeight() - 10;
            int cur = 0;
            for (int k = 0; k < wid; ++k) {
                GraphicsUtil.drawCenteredText(g, value.get(k).toDisplayString(), cx, cy);
                if (++cur == 8) {
                    cur = 0;
                    cx = x0;
                    cy -= 14;
                    continue;
                }
                cx -= 10;
            }
        } else {
            String text = radix.toString(value);
            GraphicsUtil.drawCenteredText(g, text, bds.getX() + bds.getWidth() / 2, bds.getY() + bds.getHeight() / 2 - 2);
        }
    }

    @Override
    public Object getDefaultAttributeValue(Attribute<?> attr, LogisimVersion ver) {
        return attr.equals(ProbeAttributes.PROBEAPPEARANCE) ? ProbeAttributes.getDefaultProbeAppearance() : super.getDefaultAttributeValue(attr, ver);
    }

    static void paintValue(InstancePainter painter, Value value, boolean colored) {
        boolean IsOutput;
        Graphics g = painter.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        Bounds bds = painter.getBounds();
        g.setFont(Pin.DEFAULT_FONT);
        boolean bl = painter.getAttributeSet().containsAttribute(Pin.ATTR_TYPE) ? painter.getAttributeValue(Pin.ATTR_TYPE) == Pin.OUTPUT : (IsOutput = false);
        if (painter.getAttributeValue(ProbeAttributes.PROBEAPPEARANCE) != ProbeAttributes.APPEAR_EVOLUTION_NEW) {
            if (colored) {
                int x = bds.getX();
                int y = bds.getY();
                if (!IsOutput) {
                    g.setColor(value.get(0).getColor());
                    g.fillOval(x + 5, y + 4, 11, 13);
                }
                if (!IsOutput) {
                    g.setColor(Color.WHITE);
                }
                GraphicsUtil.drawCenteredText(g, value.get(0).toDisplayString(), x + 10, y + 9);
            } else {
                Probe.paintOldStyleValue(painter, value);
            }
            return;
        }
        RadixOption radix = painter.getAttributeValue(RadixOption.ATTRIBUTE);
        int LabelValueXOffset = 15;
        if (radix != null && radix != RadixOption.RADIX_2) {
            LabelValueXOffset += 3;
        }
        g.setColor(Color.BLUE);
        g2.scale(0.7, 0.7);
        g2.drawString(radix.getIndexChar(), (int)((double)(bds.getX() + bds.getWidth() - LabelValueXOffset) / 0.7), (int)((double)(bds.getY() + bds.getHeight() - 2) / 0.7));
        g2.scale(1.4285714285714286, 1.4285714285714286);
        g.setColor(Color.BLACK);
        if (radix == null || radix == RadixOption.RADIX_2) {
            int x0;
            int x = bds.getX();
            int y = bds.getY();
            int wid = value.getWidth();
            if (wid == 0) {
                GraphicsUtil.switchToWidth(g, 2);
                g.drawLine((x += bds.getWidth() / 2) - 4, y += bds.getHeight() / 2, x + 4, y);
                return;
            }
            int yoffset = 12;
            int cx = x0 = bds.getX() + bds.getWidth() - 20;
            int cy = bds.getY() + bds.getHeight() - yoffset;
            int cur = 0;
            for (int k = 0; k < wid; ++k) {
                GraphicsUtil.drawCenteredText(g, value.get(k).toDisplayString(), cx, cy);
                if (++cur == 8) {
                    cur = 0;
                    cx = x0;
                    cy -= 20;
                    continue;
                }
                cx -= 10;
            }
        } else {
            String text = radix.toString(value);
            int cx = bds.getX() + bds.getWidth() - LabelValueXOffset - 2;
            for (int k = text.length() - 1; k >= 0; --k) {
                GraphicsUtil.drawText(g, text.substring(k, k + 1), cx, bds.getY() + bds.getHeight() / 2 - 1, 1, 0);
                cx -= 8;
            }
        }
    }

    public Probe() {
        super(_ID, Strings.S.getter("probeComponent"));
        this.setIconName("probe.gif");
        this.setKeyConfigurator(new DirectionConfigurator(StdAttr.LABEL_LOC, 512));
        this.setFacingAttribute(StdAttr.FACING);
        this.setInstanceLogger(ProbeLogger.class);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.setPorts(new Port[]{new Port(0, 0, "input", BitWidth.UNKNOWN)});
        instance.addAttributeListener();
        ((PrefMonitorBooleanConvert)AppPreferences.NEW_INPUT_OUTPUT_SHAPES).addConvertListener((ProbeAttributes)instance.getAttributeSet());
        instance.computeLabelTextField(8);
    }

    @Override
    public AttributeSet createAttributeSet() {
        ProbeAttributes attrs = new ProbeAttributes();
        attrs.setValue(ProbeAttributes.PROBEAPPEARANCE, ProbeAttributes.getDefaultProbeAppearance());
        return attrs;
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrsBase) {
        ProbeAttributes attrs = (ProbeAttributes)attrsBase;
        return Probe.getOffsetBounds(attrs.facing, attrs.width, attrs.radix, attrs.appearance == ProbeAttributes.APPEAR_EVOLUTION_NEW, false);
    }

    @Override
    public boolean isHDLSupportedComponent(AttributeSet attrs) {
        return true;
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.LABEL_LOC) {
            instance.computeLabelTextField(8);
        } else if (attr == StdAttr.FACING || attr == RadixOption.ATTRIBUTE || attr == ProbeAttributes.PROBEAPPEARANCE) {
            instance.recomputeBounds();
            instance.computeLabelTextField(8);
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getOffsetBounds();
        g.drawOval(bds.getX() + 1, bds.getY() + 1, bds.getWidth() - 1, bds.getHeight() - 1);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Value value = Probe.getValue(painter);
        Graphics g = painter.getGraphics();
        Bounds bds = painter.getBounds();
        int x = bds.getX();
        int y = bds.getY();
        Color back = new Color(255, 240, 153);
        if (value.getWidth() <= 1) {
            g.setColor(back);
            g.fillOval(x + 1, y + 1, bds.getWidth() - 2, bds.getHeight() - 2);
            g.setColor(Color.lightGray);
            g.drawOval(x + 1, y + 1, bds.getWidth() - 2, bds.getHeight() - 2);
        } else {
            g.setColor(back);
            g.fillRoundRect(x + 1, y + 1, bds.getWidth() - 2, bds.getHeight() - 2, 20, 20);
            g.setColor(Color.lightGray);
            g.drawRoundRect(x + 1, y + 1, bds.getWidth() - 2, bds.getHeight() - 2, 20, 20);
        }
        g.setColor(Color.GRAY);
        painter.drawLabel();
        g.setColor(Color.DARK_GRAY);
        if (!painter.getShowState()) {
            if (value.getWidth() > 0) {
                GraphicsUtil.drawCenteredText(g, "x" + value.getWidth(), bds.getX() + bds.getWidth() / 2, bds.getY() + bds.getHeight() / 2);
            }
        } else {
            Probe.paintValue(painter, value);
        }
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        Value newValue;
        StateData oldData = (StateData)state.getData();
        Value oldValue = oldData == null ? Value.NIL : oldData.curValue;
        boolean same = Objects.equals(oldValue, newValue = state.getPortValue(0));
        if (!same) {
            if (oldData == null) {
                oldData = new StateData();
                oldData.curValue = newValue;
                state.setData(oldData);
            } else {
                oldData.curValue = newValue;
            }
            int oldWidth = oldValue == null ? 1 : oldValue.getBitWidth().getWidth();
            int newWidth = newValue.getBitWidth().getWidth();
            if (oldWidth != newWidth) {
                ProbeAttributes attrs = (ProbeAttributes)state.getAttributeSet();
                attrs.width = newValue.getBitWidth();
                state.getInstance().recomputeBounds();
                state.getInstance().computeLabelTextField(8);
            }
        }
    }

    private static class StateData
    implements InstanceData,
    Cloneable {
        Value curValue = Value.NIL;

        private StateData() {
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static class ProbeLogger
    extends InstanceLogger {
        @Override
        public String getLogName(InstanceState state, Object option) {
            String ret = state.getAttributeValue(StdAttr.LABEL);
            return ret != null && !ret.equals("") ? ret : null;
        }

        @Override
        public BitWidth getBitWidth(InstanceState state, Object option) {
            ProbeAttributes attrs = (ProbeAttributes)state.getAttributeSet();
            return attrs.width;
        }

        @Override
        public Value getLogValue(InstanceState state, Object option) {
            return Probe.getValue(state);
        }
    }
}

