/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.wiring;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.instance.StdAttr;
import java.awt.Font;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

class TunnelAttributes
extends AbstractAttributeSet {
    private static final List<Attribute<?>> ATTRIBUTES = Arrays.asList(StdAttr.FACING, StdAttr.WIDTH, StdAttr.LABEL, StdAttr.LABEL_FONT);
    private Direction facing = Direction.WEST;
    private BitWidth width = BitWidth.ONE;
    private String label = "";
    private Font labelFont = StdAttr.DEFAULT_LABEL_FONT;
    private Bounds offsetBounds = null;
    private int labelX;
    private int labelY;
    private int labelHAlign;
    private int labelVAlign;

    public TunnelAttributes() {
        this.configureLabel();
    }

    private void configureLabel() {
        int valign;
        int halign;
        int y;
        int x;
        Direction facing = this.facing;
        int margin = 5;
        if (facing == Direction.NORTH) {
            x = 0;
            y = margin;
            halign = 0;
            valign = -1;
        } else if (facing == Direction.SOUTH) {
            x = 0;
            y = -margin;
            halign = 0;
            valign = 2;
        } else if (facing == Direction.EAST) {
            x = -margin;
            y = 0;
            halign = 1;
            valign = 3;
        } else {
            x = margin;
            y = 0;
            halign = -1;
            valign = 3;
        }
        this.labelX = x;
        this.labelY = y;
        this.labelHAlign = halign;
        this.labelVAlign = valign;
    }

    @Override
    protected void copyInto(AbstractAttributeSet destObj) {
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return ATTRIBUTES;
    }

    Direction getFacing() {
        return this.facing;
    }

    Font getFont() {
        return this.labelFont;
    }

    String getLabel() {
        return this.label;
    }

    int getLabelHAlign() {
        return this.labelHAlign;
    }

    int getLabelVAlign() {
        return this.labelVAlign;
    }

    int getLabelX() {
        return this.labelX;
    }

    int getLabelY() {
        return this.labelY;
    }

    Bounds getOffsetBounds() {
        return this.offsetBounds;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == StdAttr.FACING) {
            return (V)this.facing;
        }
        if (attr == StdAttr.WIDTH) {
            return (V)this.width;
        }
        if (attr == StdAttr.LABEL) {
            return (V)this.label;
        }
        if (attr == StdAttr.LABEL_FONT) {
            return (V)this.labelFont;
        }
        return null;
    }

    boolean setOffsetBounds(Bounds value) {
        Bounds old = this.offsetBounds;
        boolean same = Objects.equals(old, value);
        if (!same) {
            this.offsetBounds = value;
        }
        return !same;
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        String Oldvalue = null;
        if (attr == StdAttr.FACING) {
            this.facing = (Direction)value;
            this.configureLabel();
        } else if (attr == StdAttr.WIDTH) {
            this.width = (BitWidth)value;
        } else if (attr == StdAttr.LABEL) {
            String val = (String)value;
            Oldvalue = this.label;
            this.label = val;
        } else if (attr == StdAttr.LABEL_FONT) {
            this.labelFont = (Font)value;
        } else {
            throw new IllegalArgumentException("unknown attribute");
        }
        this.offsetBounds = null;
        this.fireAttributeValueChanged(attr, value, Oldvalue);
    }
}

