/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.tools;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMutation;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.Selection;
import com.cburch.logisim.gui.main.SelectionActions;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.MenuExtender;
import com.cburch.logisim.tools.Strings;
import com.cburch.logisim.tools.Tool;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MenuTool
extends Tool {
    public static final String _ID = "Menu Tool";

    public boolean equals(Object other) {
        return other instanceof MenuTool;
    }

    @Override
    public String getDescription() {
        return Strings.S.get("menuToolDesc");
    }

    @Override
    public String getDisplayName() {
        return Strings.S.get("menuTool");
    }

    public int hashCode() {
        return MenuTool.class.hashCode();
    }

    @Override
    public void mousePressed(Canvas canvas, Graphics g, MouseEvent e) {
        JPopupMenu menu;
        int x = e.getX();
        int y = e.getY();
        Location pt = Location.create(x, y, false);
        Project proj = canvas.getProject();
        Selection sel = proj.getSelection();
        Collection<Component> inSel = sel.getComponentsContaining(pt, g);
        if (!inSel.isEmpty()) {
            Component comp = inSel.iterator().next();
            if (sel.getComponents().size() > 1) {
                menu = new MenuSelection(proj);
            } else {
                menu = new MenuComponent(proj, canvas.getCircuit(), comp);
                MenuExtender extender = (MenuExtender)comp.getFeature(MenuExtender.class);
                if (extender != null) {
                    extender.configureMenu(menu, proj);
                }
            }
        } else {
            Collection<Component> cl = canvas.getCircuit().getAllContaining(pt, g);
            if (!cl.isEmpty()) {
                Component comp = cl.iterator().next();
                menu = new MenuComponent(proj, canvas.getCircuit(), comp);
                MenuExtender extender = (MenuExtender)comp.getFeature(MenuExtender.class);
                if (extender != null) {
                    extender.configureMenu(menu, proj);
                }
            } else {
                menu = null;
            }
        }
        if (menu != null) {
            canvas.showPopupMenu(menu, x, y);
        }
    }

    @Override
    public void paintIcon(ComponentDrawContext c, int x, int y) {
        Graphics g = c.getGraphics();
        g.fillRect(x + 2, y + 1, 9, 2);
        g.drawRect(x + 2, y + 3, 15, 12);
        g.setColor(Color.lightGray);
        g.drawLine(x + 4, y + 2, x + 8, y + 2);
        for (int y_offs = y + 6; y_offs < y + 15; y_offs += 3) {
            g.drawLine(x + 4, y_offs, x + 14, y_offs);
        }
    }

    private static class MenuSelection
    extends JPopupMenu
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        final Project proj;
        final JMenuItem del = new JMenuItem(Strings.S.get("selDeleteItem"));
        final JMenuItem cut = new JMenuItem(Strings.S.get("selCutItem"));
        final JMenuItem copy = new JMenuItem(Strings.S.get("selCopyItem"));

        MenuSelection(Project proj) {
            this.proj = proj;
            boolean canChange = proj.getLogisimFile().contains(proj.getCurrentCircuit());
            this.add(this.del);
            this.del.addActionListener(this);
            this.del.setEnabled(canChange);
            this.add(this.cut);
            this.cut.addActionListener(this);
            this.cut.setEnabled(canChange);
            this.add(this.copy);
            this.copy.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            Selection sel = this.proj.getSelection();
            if (src == this.del) {
                this.proj.doAction(SelectionActions.clear(sel));
            } else if (src == this.cut) {
                this.proj.doAction(SelectionActions.cut(sel));
            } else if (src == this.copy) {
                this.proj.doAction(SelectionActions.copy(sel));
            }
        }
    }

    private static class MenuComponent
    extends JPopupMenu
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        final Project proj;
        final Circuit circ;
        final Component comp;
        final JMenuItem del = new JMenuItem(Strings.S.get("compDeleteItem"));
        final JMenuItem attrs = new JMenuItem(Strings.S.get("compShowAttrItem"));
        final JMenuItem rotateRight = new JMenuItem(Strings.S.get("compRotateRight"));
        final JMenuItem rotateLeft = new JMenuItem(Strings.S.get("compRotateLeft"));

        MenuComponent(Project proj, Circuit circ, Component comp) {
            this.proj = proj;
            this.circ = circ;
            this.comp = comp;
            boolean canChange = proj.getLogisimFile().contains(circ);
            if (comp.getAttributeSet().containsAttribute(StdAttr.FACING)) {
                this.add(this.rotateLeft);
                this.rotateLeft.addActionListener(this);
                this.add(this.rotateRight);
                this.rotateRight.addActionListener(this);
            }
            this.add(this.del);
            this.del.addActionListener(this);
            this.del.setEnabled(canChange);
            this.add(this.attrs);
            this.attrs.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.del) {
                Circuit circ = this.proj.getCurrentCircuit();
                CircuitMutation xn = new CircuitMutation(circ);
                xn.remove(this.comp);
                this.proj.doAction(xn.toAction(Strings.S.getter("removeComponentAction", this.comp.getFactory().getDisplayGetter())));
            } else if (src == this.attrs) {
                this.proj.getFrame().viewComponentAttributes(this.circ, this.comp);
            } else if (src == this.rotateRight) {
                Circuit circ = this.proj.getCurrentCircuit();
                CircuitMutation xn = new CircuitMutation(circ);
                Direction d = this.comp.getAttributeSet().getValue(StdAttr.FACING);
                xn.set(this.comp, StdAttr.FACING, d.getRight());
                this.proj.doAction(xn.toAction(Strings.S.getter("rotateComponentAction", this.comp.getFactory().getDisplayGetter())));
            } else if (src == this.rotateLeft) {
                Circuit circ = this.proj.getCurrentCircuit();
                CircuitMutation xn = new CircuitMutation(circ);
                Direction d = this.comp.getAttributeSet().getValue(StdAttr.FACING);
                xn.set(this.comp, StdAttr.FACING, d.getLeft());
                this.proj.doAction(xn.toAction(Strings.S.getter("rotateComponentAction", this.comp.getFactory().getDisplayGetter())));
            }
        }
    }
}

