/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.util;

import com.cburch.logisim.util.XmlUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ArgonXml {
    private final String name;
    private String content;
    private final Map<String, String> nameAttributes = new HashMap<String, String>();
    private final Map<String, ArrayList<ArgonXml>> nameChildren = new HashMap<String, ArrayList<ArgonXml>>();

    private ArgonXml(Element element) {
        this.name = element.getNodeName();
        this.content = element.getTextContent();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = namedNodeMap.item(i);
            String name = node.getNodeName();
            this.addAttribute(name, node.getNodeValue());
        }
        NodeList nodes = element.getChildNodes();
        n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodes.item(i);
            short type = node.getNodeType();
            if (type != 1) continue;
            ArgonXml child = new ArgonXml((Element)node);
            this.addChild(node.getNodeName(), child);
        }
    }

    public ArgonXml(InputStream inputStream, String rootName) {
        this(ArgonXml.rootElement(inputStream, rootName));
    }

    public ArgonXml(String rootName) {
        this.name = rootName;
    }

    public ArgonXml(String filename, String rootName) {
        this(ArgonXml.fileInputStream(filename), rootName);
    }

    private static FileInputStream fileInputStream(String filename) {
        try {
            return new FileInputStream(filename);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Element rootElement(InputStream inputStream, String rootName) {
        try {
            DocumentBuilderFactory builderFactory = XmlUtil.getHardenedBuilderFactory();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            Element rootElement = document.getDocumentElement();
            if (!rootElement.getNodeName().equals(rootName)) {
                throw new RuntimeException("Could not find root node: " + rootName);
            }
            Element element = rootElement;
            return element;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new RuntimeException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
    }

    public void addAttribute(String name, String value) {
        this.nameAttributes.put(name, value);
    }

    public void addChild(ArgonXml xml) {
        this.addChild(xml.name(), xml);
    }

    private void addChild(String name, ArgonXml child) {
        ArrayList children = this.nameChildren.computeIfAbsent(name, k -> new ArrayList());
        children.add(child);
    }

    public void addChildren(ArgonXml ... xmls) {
        for (ArgonXml xml : xmls) {
            this.addChild(xml.name(), xml);
        }
    }

    public ArgonXml child(String name) {
        ArgonXml child = this.optChild(name);
        if (child == null) {
            throw new RuntimeException("Could not find child node: " + name);
        }
        return child;
    }

    public List<ArgonXml> children(String name) {
        ArrayList children = this.nameChildren.get(name);
        return children == null ? new ArrayList() : children;
    }

    public String content() {
        return this.content;
    }

    public double doubleValue(String name) {
        return Double.parseDouble(this.optString(name));
    }

    public int integer(String name) {
        return Integer.parseInt(this.string(name));
    }

    public String name() {
        return this.name;
    }

    public ArgonXml optChild(String name) {
        List<ArgonXml> children = this.children(name);
        int n = children.size();
        if (n > 1) {
            throw new RuntimeException("Could not find individual child node: " + name);
        }
        return n == 0 ? null : children.get(0);
    }

    public Double optDouble(String name) {
        String string = this.optString(name);
        return string == null ? null : Double.valueOf(this.doubleValue(name));
    }

    public Integer optInteger(String name) {
        String string = this.optString(name);
        return string == null ? null : Integer.valueOf(this.integer(name));
    }

    public boolean option(String name) {
        return this.optChild(name) != null;
    }

    public String optString(String name) {
        return this.nameAttributes.get(name);
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String string(String name) {
        String value = this.optString(name);
        if (value == null) {
            throw new RuntimeException("Could not find attribute: " + name + ", in node: " + this.name);
        }
        return value;
    }
}

