/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.vhdl.sim;

import com.cburch.logisim.tools.MessageBox;
import com.cburch.logisim.util.FileUtil;
import com.cburch.logisim.util.Softwares;
import com.cburch.logisim.vhdl.base.VhdlSimConstants;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorTop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VhdlSimulatorTclBinder {
    static final Logger logger = LoggerFactory.getLogger(VhdlSimulatorTclBinder.class);
    private ProcessBuilder builder;
    private Process process;
    private Boolean running = false;
    private VhdlSimulatorTop vsim = null;

    public VhdlSimulatorTclBinder(VhdlSimulatorTop vs) {
        this.vsim = vs;
        this.init(vs.getSocketClient().getServerPort());
    }

    private void init(int serverPort) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(FileUtil.correctPath(Softwares.getQuestaPath()) + Softwares.QUESTA_BIN[1]);
        command.add("-c");
        command.add("-do");
        command.add("do ../run.tcl " + serverPort);
        command.add("-errorfile");
        command.add("../questasim_errors.log");
        this.builder = new ProcessBuilder(command);
        Map<String, String> env = this.builder.environment();
        this.builder.directory(new File(VhdlSimConstants.SIM_PATH + "comp/"));
        this.builder.redirectErrorStream(true);
    }

    public Boolean isRunning() {
        return this.running;
    }

    public void start() {
        try {
            this.process = this.builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Cannot run TCL binder to QuestaSim: {}", (Object)e.getMessage());
            this.running = false;
            return;
        }
        new Thread(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            String line = "";
            try {
                StringBuilder errorMessage = new StringBuilder("You may disable VHDL simulation in the simulation menu if this occurs again\n\n");
                String msgCheckOnError = String.format("\"%s%s", "vcom -reportprogress 300 -work work ../src/", "LogisimVhdlSimComp_");
                while ((line = reader.readLine()) != null) {
                    if (this.vsim.getProject().getFrame() != null) {
                        this.vsim.getProject().getFrame().getVhdlSimulatorConsole().append(line + "\n");
                    }
                    if (line.toLowerCase().contains("error")) {
                        errorMessage.append("\n").append(line);
                    }
                    if (line.contains("TCL_BINDER_RUNNING")) {
                        this.running = true;
                        new Thread(() -> {
                            Scanner sc = new Scanner(new InputStreamReader(this.process.getInputStream()));
                            String nextLine = "";
                            while (sc.hasNextLine()) {
                                nextLine = sc.nextLine();
                                if (nextLine.length() <= 0 || this.vsim.getProject().getFrame() == null) continue;
                                this.vsim.getProject().getFrame().getVhdlSimulatorConsole().append(nextLine + "\n");
                            }
                            sc.close();
                        }).start();
                        this.vsim.tclStartCallback();
                        return;
                    }
                    if (!line.contains(msgCheckOnError)) continue;
                }
                MessageBox userInfoBox = new MessageBox("Error starting VHDL simulator", errorMessage.toString(), 0);
                userInfoBox.show();
                this.vsim.setState(VhdlSimConstants.State.ENABLED);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void stop() {
        if (this.running.equals(Boolean.FALSE)) {
            return;
        }
        if (this.vsim.getSocketClient() != null) {
            this.vsim.getSocketClient().send("end");
        }
        this.process.destroy();
        this.running = false;
    }
}

