/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.array.OffHeapArray;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.NativeMemory;

final class OffHeapR064
extends OffHeapArray {
    private final long myPointer;

    OffHeapR064(long count) {
        super(OffHeapArray.R064, count);
        this.myPointer = NativeMemory.allocateDoubleArray(this, count);
    }

    @Override
    public void add(long index, Comparable<?> addend) {
        this.add(index, Scalar.doubleValue(addend));
    }

    @Override
    public double doubleValue(long index) {
        return NativeMemory.getDouble(this.myPointer, index);
    }

    @Override
    public float floatValue(long index) {
        return (float)NativeMemory.getDouble(this.myPointer, index);
    }

    @Override
    public void reset() {
        NativeMemory.initialiseDoubleArray(this.myPointer, this.count());
    }

    @Override
    public void set(long index, Comparable<?> value) {
        this.set(index, Scalar.doubleValue(value));
    }

    @Override
    public void set(long index, double value) {
        NativeMemory.setDouble(this.myPointer, index, value);
    }

    @Override
    public void set(long index, float value) {
        NativeMemory.setDouble(this.myPointer, index, value);
    }
}

