/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data;

import java.util.function.Function;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.random.SampleSet;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Factory2D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.structure.Transformation2D;

public class DataProcessors {
    public static final Transformation2D<Double> CENTER = DataProcessors.newTransformation2D(ss -> PrimitiveMath.SUBTRACT.by(ss.getMean()));
    public static final Transformation2D<Double> CENTER_AND_SCALE = DataProcessors.newTransformation2D(ss -> PrimitiveMath.SUBTRACT.by(ss.getMean()).andThen(PrimitiveMath.DIVIDE.by((ss.getMaximum() - ss.getMinimum()) / PrimitiveMath.TWO)));
    public static final Transformation2D<Double> SCALE = DataProcessors.newTransformation2D(ss -> PrimitiveMath.DIVIDE.by(ss.getLargest()));
    public static final Transformation2D<Double> STANDARD_SCORE = DataProcessors.newTransformation2D(ss -> PrimitiveMath.SUBTRACT.by(ss.getMean()).andThen(PrimitiveMath.DIVIDE.by(ss.getStandardDeviation())));

    public static <M extends Mutate2D> M correlations(Factory2D<M> factory, Access1D<?> ... data) {
        int nbVariables = data.length;
        Mutate2D retVal = (Mutate2D)factory.make(nbVariables, nbVariables);
        SampleSet rowSet = SampleSet.make();
        SampleSet colSet = SampleSet.make();
        double[] stdDev = new double[nbVariables];
        double stdDevJ = PrimitiveMath.ZERO;
        for (int j = 0; j < nbVariables; ++j) {
            colSet.swap(data[j]);
            stdDevJ = stdDev[j] = colSet.getStandardDeviation();
            for (int i = 0; i < j; ++i) {
                rowSet.swap(data[i]);
                double correlation = rowSet.getCovariance(colSet);
                correlation /= stdDev[i];
                retVal.set((long)i, (long)j, correlation /= stdDevJ);
                retVal.set((long)j, (long)i, correlation);
            }
            retVal.set((long)j, (long)j, PrimitiveMath.ONE);
        }
        return (M)retVal;
    }

    public static <M extends Mutate2D> M covariances(Factory2D<M> factory, Access1D<?> ... data) {
        int nbVariables = data.length;
        Mutate2D retVal = (Mutate2D)factory.make(nbVariables, nbVariables);
        SampleSet rowSet = SampleSet.make();
        SampleSet colSet = SampleSet.make();
        for (int j = 0; j < nbVariables; ++j) {
            colSet.swap(data[j]);
            retVal.set((long)j, (long)j, colSet.getVariance());
            for (int i = 0; i < j; ++i) {
                rowSet.swap(data[i]);
                double covariance = rowSet.getCovariance(colSet);
                retVal.set((long)i, (long)j, covariance);
                retVal.set((long)j, (long)i, covariance);
            }
        }
        return (M)retVal;
    }

    public static <D extends Access2D<?> & Access2D.Sliceable<?>, M extends Mutate2D> M covariances(Factory2D<M> factory, D data) {
        int nbVariables = data.getColDim();
        Mutate2D retVal = (Mutate2D)factory.make(nbVariables, nbVariables);
        SampleSet rowSet = SampleSet.make();
        SampleSet colSet = SampleSet.make();
        for (int j = 0; j < nbVariables; ++j) {
            colSet.swap(((Access2D.Sliceable<?>)data).sliceColumn(j));
            retVal.set((long)j, (long)j, colSet.getVariance());
            for (int i = 0; i < j; ++i) {
                rowSet.swap(((Access2D.Sliceable<?>)data).sliceColumn(i));
                double covariance = rowSet.getCovariance(colSet);
                retVal.set((long)i, (long)j, covariance);
                retVal.set((long)j, (long)i, covariance);
            }
        }
        return (M)retVal;
    }

    public static <M extends Mutate2D> M covariances(Factory2D<M> factory, double[] ... data) {
        return DataProcessors.covariances(factory, RawStore.wrap(data).transpose());
    }

    public static <M extends PhysicalStore<Double>> M covariances(Factory2D<M> factory, SingularValue<Double> svd) {
        return DataProcessors.covariances(factory, svd, Math.toIntExact(svd.countColumns()));
    }

    public static <M extends PhysicalStore<Double>> M covariances(Factory2D<M> factory, SingularValue<Double> svd, double threshold) {
        return DataProcessors.covariances(factory, svd, svd.countSignificant(threshold));
    }

    public static <M extends PhysicalStore<Double>> M covariances(Factory2D<M> factory, SingularValue<Double> svd, int complexity) {
        if (!svd.isComputed()) {
            throw new ProgrammingError("The decomposition must be computed!");
        }
        if (!svd.isOrdered()) {
            throw new ProgrammingError("The singular values must be ordered!");
        }
        long numberOfSamples = svd.countRows();
        long numberOfVariables = svd.countColumns();
        if (numberOfSamples <= 1L) {
            throw new ProgrammingError("There must be more than 1 sample!");
        }
        PhysicalStore retVal = (PhysicalStore)factory.make(numberOfVariables, numberOfVariables);
        int limit = Math.min(complexity, svd.getRank());
        if (limit > 0) {
            Access1D<Double> values = svd.getSingularValues();
            Structure2D.Logical vectors = svd.getV();
            if ((long)limit < numberOfVariables) {
                values = values.sliceRange(0L, limit);
                vectors = vectors.limits(-1L, limit);
            }
            MatrixStore scaledV = (MatrixStore)vectors.onColumns(PrimitiveMath.MULTIPLY, values).collect(factory);
            retVal.fillByMultiplying(scaledV, scaledV.transpose());
            retVal.modifyAll(PrimitiveMath.DIVIDE.by((double)(numberOfSamples - 1L)));
        }
        return (M)retVal;
    }

    public static Transformation2D<Double> newTransformation2D(final Function<SampleSet, UnaryFunction<Double>> definition) {
        return new Transformation2D<Double>(){

            @Override
            public <T extends Mutate2D.ModifiableReceiver<Double>> void transform(T transformable) {
                SampleSet sampleSet = SampleSet.make();
                for (Access2D.ColumnView columnView : transformable.columns()) {
                    sampleSet.swap(columnView);
                    UnaryFunction modifier = (UnaryFunction)definition.apply(sampleSet);
                    transformable.modifyColumn(columnView.column(), modifier);
                }
            }
        };
    }
}

