/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.data.domain.finance.portfolio.EquilibriumModel;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.MarketEquilibrium;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.Primitive64Matrix;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.TypeUtils;

public final class BlackLittermanModel
extends EquilibriumModel {
    private BigDecimal myConfidence = BigMath.ONE;
    private final Primitive64Matrix myOriginalWeights;
    private final List<FinancePortfolio> myViews;

    public BlackLittermanModel(FinancePortfolio.Context context, FinancePortfolio originalWeights) {
        super(context);
        this.myOriginalWeights = (Primitive64Matrix)MATRIX_FACTORY.columns(new List[]{originalWeights.getWeights()});
        this.myViews = new ArrayList<FinancePortfolio>();
    }

    public BlackLittermanModel(MarketEquilibrium marketEquilibrium, Primitive64Matrix originalWeights) {
        super(marketEquilibrium);
        this.myOriginalWeights = originalWeights;
        this.myViews = new ArrayList<FinancePortfolio>();
    }

    private BlackLittermanModel(MarketEquilibrium aMarketEquilibrium) {
        super(aMarketEquilibrium);
        this.myOriginalWeights = null;
        this.myViews = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    public void addView(FinancePortfolio aView) {
        this.myViews.add(aView);
    }

    public void addViewWithBalancedConfidence(List<BigDecimal> someWeights, Comparable<?> aReturn) {
        View tmpView = new View(this, someWeights);
        tmpView.setMeanReturn(TypeUtils.toBigDecimal(aReturn));
        tmpView.setReturnVariance(null);
        tmpView.setScale(null);
        this.myViews.add(tmpView);
    }

    public void addViewWithScaledConfidence(List<BigDecimal> someWeights, Comparable<?> aReturn, Comparable<?> aScale) {
        View tmpView = new View(this, someWeights);
        tmpView.setMeanReturn(TypeUtils.toBigDecimal(aReturn));
        tmpView.setReturnVariance(null);
        tmpView.setScale(TypeUtils.toBigDecimal(aScale));
        this.myViews.add(tmpView);
    }

    @Deprecated
    public void addViewWithStandardDeviation(List<BigDecimal> someWeights, BigDecimal aReturn, BigDecimal aStdDev) {
        View tmpView = new View(this, someWeights);
        tmpView.setMeanReturn(aReturn);
        tmpView.setReturnVariance(aStdDev.multiply(aStdDev));
        tmpView.setScale(null);
        this.myViews.add(tmpView);
    }

    public Scalar<?> getConfidence() {
        return BigScalar.of(this.myConfidence);
    }

    public void setConfidence(Comparable<?> aWeight) {
        this.myConfidence = TypeUtils.toBigDecimal(aWeight);
    }

    @Override
    protected Primitive64Matrix calculateAssetReturns() {
        return this.calculateAssetReturns(this.calculateAssetWeights());
    }

    @Override
    protected Primitive64Matrix calculateAssetWeights() {
        Primitive64Matrix tmpViewPortfolios = this.getViewPortfolios();
        Primitive64Matrix tmpViewReturns = this.getViewReturns();
        Primitive64Matrix tmpViewVariances = this.getViewVariances();
        Primitive64Matrix tmpCovariances = this.getCovariances();
        Primitive64Matrix tmpRightParenthesis = (Primitive64Matrix)tmpViewReturns.subtract((Primitive64Matrix)((Primitive64Matrix)tmpViewPortfolios.multiply(tmpCovariances)).multiply(this.myOriginalWeights));
        Primitive64Matrix tmpViewsTransposed = (Primitive64Matrix)tmpViewPortfolios.transpose();
        Primitive64Matrix tmpLeftParenthesis = (Primitive64Matrix)tmpViewVariances.add((Primitive64Matrix)((Primitive64Matrix)tmpViewPortfolios.multiply(tmpCovariances)).multiply(tmpViewsTransposed));
        return (Primitive64Matrix)this.myOriginalWeights.add((Primitive64Matrix)tmpViewsTransposed.multiply((Primitive64Matrix)tmpLeftParenthesis.solve((Access2D)tmpRightParenthesis)));
    }

    protected Primitive64Matrix getOriginalReturns() {
        return this.calculateAssetReturns(this.myOriginalWeights);
    }

    protected Primitive64Matrix getOriginalWeights() {
        return this.myOriginalWeights;
    }

    protected Primitive64Matrix getViewPortfolios() {
        int tmpRowDim = this.myViews.size();
        int tmpColDim = (int)this.myOriginalWeights.count();
        Primitive64Matrix.DenseReceiver retVal = (Primitive64Matrix.DenseReceiver)MATRIX_FACTORY.makeDense(tmpRowDim, tmpColDim);
        for (int i = 0; i < tmpRowDim; ++i) {
            FinancePortfolio tmpView = this.myViews.get(i);
            List<BigDecimal> tmpWeights = tmpView.getWeights();
            for (int j = 0; j < tmpColDim; ++j) {
                retVal.set((long)i, (long)j, (Comparable)tmpWeights.get(j));
            }
        }
        return (Primitive64Matrix)retVal.get();
    }

    protected Primitive64Matrix getViewReturns() {
        int tmpRowDim = this.myViews.size();
        boolean tmpColDim = true;
        Primitive64Matrix.DenseReceiver retVal = (Primitive64Matrix.DenseReceiver)MATRIX_FACTORY.makeDense(tmpRowDim, 1L);
        double tmpRAF = this.getRiskAversion().doubleValue();
        for (int i = 0; i < tmpRowDim; ++i) {
            double tmpRet = this.myViews.get(i).getMeanReturn();
            retVal.set((long)i, 0L, PrimitiveMath.DIVIDE.invoke(tmpRet, tmpRAF));
        }
        return (Primitive64Matrix)retVal.get();
    }

    protected List<FinancePortfolio> getViews() {
        return this.myViews;
    }

    protected Primitive64Matrix getViewVariances() {
        int tmpDim = this.myViews.size();
        Primitive64Matrix.DenseReceiver retVal = (Primitive64Matrix.DenseReceiver)MATRIX_FACTORY.makeDense(tmpDim, tmpDim);
        if (this.myConfidence.compareTo(BigMath.ONE) == 0) {
            for (int ij = 0; ij < tmpDim; ++ij) {
                retVal.set((long)ij, (long)ij, this.myViews.get(ij).getReturnVariance());
            }
        } else {
            double tmpScale = this.myConfidence.doubleValue();
            for (int ij = 0; ij < tmpDim; ++ij) {
                double tmpVar = this.myViews.get(ij).getReturnVariance();
                retVal.set((long)ij, (long)ij, PrimitiveMath.DIVIDE.invoke(tmpVar, tmpScale));
            }
        }
        return (Primitive64Matrix)retVal.get();
    }

    BigDecimal calculateVariance(Primitive64Matrix weights) {
        Primitive64Matrix tmpVal = this.getCovariances();
        tmpVal = (Primitive64Matrix)tmpVal.multiply(weights);
        return TypeUtils.toBigDecimal(((Primitive64Matrix)((Primitive64Matrix)weights.transpose()).multiply(tmpVal)).get(0L, 0L));
    }

    private static final class View
    extends FinancePortfolio {
        private BigDecimal myMeanReturn = BigMath.ZERO;
        private final BlackLittermanModel myModel;
        private BigDecimal myReturnVariance = null;
        private BigDecimal myScale = null;
        private final List<BigDecimal> myWeights;

        public View(BlackLittermanModel aModel, List<BigDecimal> someWeights) {
            this.myModel = aModel;
            this.myWeights = someWeights;
        }

        private View() {
            this.myModel = null;
            this.myWeights = null;
            ProgrammingError.throwForIllegalInvocation();
        }

        @Override
        public double getMeanReturn() {
            if (this.myMeanReturn != null) {
                return this.myMeanReturn.doubleValue();
            }
            return PrimitiveMath.ZERO;
        }

        @Override
        public double getReturnVariance() {
            if (this.myReturnVariance != null) {
                return this.myReturnVariance.doubleValue();
            }
            Primitive64Matrix tmpWeights = (Primitive64Matrix)MATRIX_FACTORY.columns(new List[]{this.myWeights});
            BigDecimal retVal = this.myModel.calculateVariance(tmpWeights);
            retVal = this.myScale != null ? retVal.multiply(this.myScale) : retVal.multiply(this.myModel.getConfidence().toBigDecimal());
            return retVal.doubleValue();
        }

        @Override
        public List<BigDecimal> getWeights() {
            return this.myWeights;
        }

        @Override
        protected void reset() {
        }

        protected void setMeanReturn(BigDecimal aMeanReturn) {
            this.myMeanReturn = aMeanReturn;
        }

        protected void setReturnVariance(BigDecimal aReturnVariance) {
            this.myReturnVariance = aReturnVariance;
        }

        protected void setScale(BigDecimal aScale) {
            this.myScale = aScale;
        }
    }
}

