/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import java.io.File;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.ojalgo.array.DenseArray;
import org.ojalgo.data.domain.finance.series.AlphaVantageFetcher;
import org.ojalgo.data.domain.finance.series.AlphaVantageParser;
import org.ojalgo.data.domain.finance.series.DataFetcher;
import org.ojalgo.data.domain.finance.series.DatePrice;
import org.ojalgo.data.domain.finance.series.FinanceData;
import org.ojalgo.data.domain.finance.series.FinanceDataReader;
import org.ojalgo.data.domain.finance.series.IEXTradingFetcher;
import org.ojalgo.data.domain.finance.series.IEXTradingParser;
import org.ojalgo.data.domain.finance.series.SourceCache;
import org.ojalgo.data.domain.finance.series.YahooParser;
import org.ojalgo.data.domain.finance.series.YahooSession;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.netio.BasicParser;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.CalendarDateSeries;
import org.ojalgo.series.SimpleSeries;
import org.ojalgo.series.TreeSeries;
import org.ojalgo.series.primitive.CoordinatedSet;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;
import org.ojalgo.type.PrimitiveNumber;
import org.ojalgo.type.function.AutoSupplier;
import org.ojalgo.type.keyvalue.KeyValue;

public final class DataSource
implements FinanceData<DatePrice> {
    public static final UnaryOperator<LocalDate> FRIDAY_OF_WEEK = d -> (LocalDate)TemporalAdjusters.nextOrSame(DayOfWeek.FRIDAY).adjustInto((Temporal)d);
    public static final UnaryOperator<LocalDate> LAST_DAY_OF_MONTH = d -> (LocalDate)TemporalAdjusters.lastDayOfMonth().adjustInto((Temporal)d);
    public static final UnaryOperator<LocalDate> LAST_DAY_OF_YEAR = d -> LocalDate.of(d.getYear(), 12, 31);
    private final DataFetcher myFetcher;
    private final BasicParser<? extends DatePrice> myParser;

    public static Coordinated coordinated() {
        return new Coordinated();
    }

    public static Coordinated coordinated(CalendarDateUnit resolution) {
        return new Coordinated().resolution(resolution);
    }

    public static DataSource newAlphaVantage(String symbol, CalendarDateUnit resolution, String apiKey) {
        return DataSource.newAlphaVantage(symbol, resolution, apiKey, false);
    }

    public static DataSource newAlphaVantage(String symbol, CalendarDateUnit resolution, String apiKey, boolean fullOutputSize) {
        AlphaVantageFetcher fetcher = new AlphaVantageFetcher(symbol, resolution, apiKey, fullOutputSize);
        AlphaVantageParser parser = new AlphaVantageParser();
        return new DataSource(fetcher, parser);
    }

    public static <T extends DatePrice> DataSource newFileReader(File file, BasicParser<T> parser) {
        return new DataSource(FinanceDataReader.of(file, parser), parser);
    }

    public static <T extends DatePrice> DataSource newFileReader(File file, BasicParser<T> parser, CalendarDateUnit resolution) {
        return new DataSource(FinanceDataReader.of(file, parser, resolution), parser);
    }

    public static DataSource newIEXTrading(String symbol) {
        IEXTradingFetcher fetcher = new IEXTradingFetcher(symbol);
        IEXTradingParser parser = new IEXTradingParser();
        return new DataSource(fetcher, parser);
    }

    public static DataSource newYahoo(YahooSession session, String symbol, CalendarDateUnit resolution) {
        YahooSession.Fetcher fetcher = session.newFetcher(symbol, resolution);
        YahooParser parser = new YahooParser();
        return new DataSource(fetcher, parser);
    }

    DataSource(DataFetcher fetcher, BasicParser<? extends DatePrice> parser) {
        this.myFetcher = fetcher;
        this.myParser = parser;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)obj;
        if (this.myFetcher == null ? other.myFetcher != null : !this.myFetcher.equals(other.myFetcher)) {
            return false;
        }
        return !(this.myParser == null ? other.myParser != null : !this.myParser.equals(other.myParser));
    }

    public CalendarDateSeries<Double> getCalendarDateSeries() {
        return this.getCalendarDateSeries(this.myFetcher.getResolution(), LocalTime.NOON, ZoneOffset.UTC);
    }

    public CalendarDateSeries<Double> getCalendarDateSeries(CalendarDateUnit resolution) {
        return this.getCalendarDateSeries(resolution, LocalTime.NOON, ZoneOffset.UTC);
    }

    public CalendarDateSeries<Double> getCalendarDateSeries(CalendarDateUnit resolution, LocalTime time, ZoneId zoneId) {
        CalendarDateSeries<Double> retVal = new CalendarDateSeries<Double>(resolution);
        for (DatePrice datePrice : this.getHistoricalPrices()) {
            ((TreeSeries)retVal).put(CalendarDate.valueOf(datePrice.getKey().atTime(time).atZone(zoneId)), datePrice.getPrice());
        }
        return retVal;
    }

    public CalendarDateSeries<Double> getCalendarDateSeries(LocalTime time, ZoneId zoneId) {
        return this.getCalendarDateSeries(this.myFetcher.getResolution(), time, zoneId);
    }

    @Override
    public KeyValue<String, List<DatePrice>> getHistoricalData() {
        String key = this.myFetcher.getSymbol();
        ArrayList value = new ArrayList();
        try (AutoSupplier<? extends DatePrice> reader = this.myFetcher.getReader(this.myParser);){
            reader.forEach(value::add);
        }
        catch (Exception cause) {
            BasicLogger.error(cause, "Fetch problem for {}!", this.myFetcher.getClass().getSimpleName());
            BasicLogger.error("Symbol & Resolution: {} & {}", this.myFetcher.getSymbol(), this.myFetcher.getResolution());
        }
        Collections.sort(value);
        return KeyValue.of(key, value);
    }

    @Override
    public List<DatePrice> getHistoricalPrices() {
        return this.getHistoricalData().getValue();
    }

    public BasicSeries<LocalDate, PrimitiveNumber> getLocalDateSeries() {
        return this.getLocalDateSeries(this.getHistoricalPrices(), this.myFetcher.getResolution());
    }

    public BasicSeries<LocalDate, PrimitiveNumber> getLocalDateSeries(CalendarDateUnit resolution) {
        return this.getLocalDateSeries(this.getHistoricalPrices(), resolution);
    }

    public BasicSeries<LocalDate, PrimitiveNumber> getLocalDateSeries(CalendarDateUnit resolution, DenseArray.Factory<Double> denseArrayFactory) {
        return this.getLocalDateSeries(this.getHistoricalPrices(), resolution);
    }

    public BasicSeries<LocalDate, PrimitiveNumber> getLocalDateSeries(DenseArray.Factory<Double> denseArrayFactory) {
        return this.getLocalDateSeries(this.getHistoricalPrices(), this.myFetcher.getResolution());
    }

    @Override
    public BasicSeries<LocalDate, PrimitiveNumber> getPriceSeries() {
        return this.getLocalDateSeries(this.getHistoricalPrices(), this.myFetcher.getResolution());
    }

    @Override
    public String getSymbol() {
        return this.myFetcher.getSymbol();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myFetcher == null ? 0 : this.myFetcher.hashCode());
        return 31 * result + (this.myParser == null ? 0 : this.myParser.hashCode());
    }

    private BasicSeries<LocalDate, PrimitiveNumber> getLocalDateSeries(List<DatePrice> historicalPrices, CalendarDateUnit resolution) {
        SimpleSeries<LocalDate, PrimitiveNumber> retVal = new SimpleSeries<LocalDate, PrimitiveNumber>();
        retVal.name(this.getSymbol());
        for (DatePrice datePrice : historicalPrices) {
            LocalDate adjusted;
            switch (resolution) {
                case YEAR: {
                    adjusted = (LocalDate)LAST_DAY_OF_YEAR.apply(datePrice.date);
                    break;
                }
                case MONTH: {
                    adjusted = (LocalDate)LAST_DAY_OF_MONTH.apply(datePrice.date);
                    break;
                }
                case WEEK: {
                    adjusted = (LocalDate)FRIDAY_OF_WEEK.apply(datePrice.date);
                    break;
                }
                default: {
                    adjusted = datePrice.date;
                }
            }
            retVal.put(adjusted, datePrice);
        }
        return retVal;
    }

    public static final class Coordinated
    implements Supplier<CoordinatedSet<LocalDate>> {
        private final CoordinatedSet.Builder<LocalDate> myBuilder = CoordinatedSet.builder();
        private final SourceCache myCache = new SourceCache(CalendarDateUnit.DAY);
        private CalendarDateUnit myResolution = CalendarDateUnit.MONTH;
        private final YahooSession myYahooSession = new YahooSession();

        public <T extends DatePrice> Coordinated add(FinanceData<T> data) {
            this.myBuilder.add(() -> this.myCache.get(data));
            return this;
        }

        public <T1 extends DatePrice, T2 extends DatePrice> Coordinated add(FinanceData<T1> primary, FinanceData<T2> secondary) {
            this.myCache.register(primary, secondary);
            this.myBuilder.add(() -> this.myCache.get(primary));
            return this;
        }

        public Coordinated addAlphaVantage(String symbol, String apiKey) {
            this.myBuilder.add(() -> this.myCache.get(DataSource.newAlphaVantage(symbol, this.myResolution, apiKey, true)));
            return this;
        }

        public Coordinated addIEXTrading(String symbol) {
            this.myBuilder.add(() -> this.myCache.get(DataSource.newIEXTrading(symbol)));
            return this;
        }

        public <T extends DatePrice> Coordinated addReader(File file, BasicParser<T> parser) {
            return this.add(FinanceDataReader.of(file, parser));
        }

        public Coordinated addYahoo(String symbol) {
            this.myBuilder.add(() -> this.myCache.get(DataSource.newYahoo(this.myYahooSession, symbol, this.myResolution)));
            return this;
        }

        @Override
        public CoordinatedSet<LocalDate> get() {
            switch (this.myResolution) {
                case YEAR: {
                    return this.myBuilder.build(LAST_DAY_OF_YEAR);
                }
                case MONTH: {
                    return this.myBuilder.build(LAST_DAY_OF_MONTH);
                }
                case WEEK: {
                    return this.myBuilder.build(FRIDAY_OF_WEEK);
                }
            }
            return this.myBuilder.build();
        }

        public Coordinated resolution(CalendarDateUnit resolution) {
            this.myResolution = resolution;
            return this;
        }
    }
}

