/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.array.BasicArray;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

abstract class CholeskyDecomposition<N extends Comparable<N>>
extends InPlaceDecomposition<N>
implements Cholesky<N> {
    private double myMaxDiag = PrimitiveMath.ONE;
    private double myMinDiag = PrimitiveMath.ZERO;
    private boolean mySPD = false;

    protected CholeskyDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public N calculateDeterminant(Access2D<?> matrix) {
        this.decompose(this.wrap(matrix));
        return this.getDeterminant();
    }

    @Override
    public boolean checkAndDecompose(MatrixStore<N> matrix) {
        return this.compute(matrix, true);
    }

    @Override
    public int countSignificant(double threshold) {
        double minimum = Math.sqrt(threshold);
        DecompositionStore internal = this.getInPlace();
        int significant = 0;
        int limit = this.getMinDim();
        for (int ij = 0; ij < limit; ++ij) {
            if (!(internal.doubleValue(ij, ij) > minimum)) continue;
            ++significant;
        }
        return significant;
    }

    @Override
    public boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> aStore) {
        return this.compute(aStore, false);
    }

    @Override
    public N getDeterminant() {
        AggregatorFunction tmpAggrFunc = this.aggregator().product2();
        this.getInPlace().visitDiagonal(0L, 0L, tmpAggrFunc);
        return (N)((Comparable)tmpAggrFunc.get());
    }

    @Override
    public MatrixStore<N> getInverse(PhysicalStore<N> preallocated) {
        DecompositionStore body = this.getInPlace();
        preallocated.substituteForwards(body, false, false, true);
        preallocated.substituteBackwards(body, false, true, true);
        return preallocated.hermitian(false);
    }

    @Override
    public MatrixStore<N> getL() {
        return this.getInPlace().triangular(false, false);
    }

    @Override
    public double getRankThreshold() {
        return PrimitiveMath.TEN * this.myMaxDiag * this.getDimensionalEpsilon();
    }

    @Override
    public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs) {
        return this.getSolution(rhs, this.preallocate(this.getInPlace(), rhs));
    }

    @Override
    public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs, PhysicalStore<N> preallocated) {
        rhs.supplyTo(preallocated);
        DecompositionStore body = this.getInPlace();
        preallocated.substituteForwards(body, false, false, false);
        preallocated.substituteBackwards(body, false, true, false);
        return preallocated;
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse();
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    public boolean isFullSize() {
        return true;
    }

    @Override
    public boolean isSolvable() {
        return super.isSolvable();
    }

    @Override
    public boolean isSPD() {
        return this.mySPD;
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.allocate(tmpCountRows, tmpCountRows);
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateRHS.countRows(), templateRHS.countColumns());
    }

    @Override
    public void reset() {
        super.reset();
        this.mySPD = false;
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs));
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs), preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    protected boolean checkSolvability() {
        return this.mySPD && this.myMinDiag > this.getRankThreshold();
    }

    boolean compute(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean checkHermitian) {
        this.reset();
        DecompositionStore tmpInPlace = this.setInPlace(matrix);
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        int tmpMinDim = Math.min(tmpRowDim, tmpColDim);
        boolean tmpPositiveDefinite = tmpRowDim == tmpColDim;
        this.myMaxDiag = Double.MIN_NORMAL;
        this.myMinDiag = Double.MAX_VALUE;
        BasicArray tmpMultipliers = this.makeArray(tmpRowDim);
        if (tmpPositiveDefinite && checkHermitian) {
            tmpPositiveDefinite &= tmpInPlace.isHermitian();
        }
        UnaryFunction tmpSqrtFunc = this.function().sqrt();
        for (int ij = 0; tmpPositiveDefinite && ij < tmpMinDim; ++ij) {
            double tmpVal = tmpInPlace.doubleValue(ij, ij);
            this.myMaxDiag = PrimitiveMath.MAX.invoke(this.myMaxDiag, tmpVal);
            this.myMinDiag = PrimitiveMath.MIN.invoke(this.myMinDiag, tmpVal);
            if (tmpVal > PrimitiveMath.ZERO) {
                tmpInPlace.modifyOne(ij, ij, tmpSqrtFunc);
                tmpInPlace.divideAndCopyColumn(ij, ij, tmpMultipliers);
                tmpInPlace.applyCholesky(ij, tmpMultipliers);
                continue;
            }
            tmpPositiveDefinite = false;
        }
        this.mySPD = tmpPositiveDefinite;
        return this.computed(this.mySPD);
    }

    static final class Rational
    extends CholeskyDecomposition<RationalNumber> {
        Rational() {
            super(GenericStore.RATIONAL);
        }
    }

    static final class Quat
    extends CholeskyDecomposition<Quaternion> {
        Quat() {
            super(GenericStore.QUATERNION);
        }
    }

    static final class Primitive
    extends CholeskyDecomposition<Double> {
        Primitive() {
            super(Primitive64Store.FACTORY);
        }
    }

    static final class Complex
    extends CholeskyDecomposition<ComplexNumber> {
        Complex() {
            super(GenericStore.COMPLEX);
        }
    }
}

