/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.matrix.store.AbstractStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.Scalar;

abstract class FactoryStore<N extends Comparable<N>>
extends AbstractStore<N> {
    private final PhysicalStore.Factory<N, ?> myFactory;
    private final Scalar<N> myOne;
    private final Scalar<N> myZero;

    protected FactoryStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(rowsCount, columnsCount);
        this.myFactory = factory;
        this.myZero = factory.scalar().zero();
        this.myOne = factory.scalar().one();
    }

    protected FactoryStore(PhysicalStore.Factory<N, ?> factory, long rowsCount, long columnsCount) {
        this(factory, Math.toIntExact(rowsCount), Math.toIntExact(columnsCount));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof FactoryStore)) {
            return false;
        }
        FactoryStore other = (FactoryStore)obj;
        if (this.myFactory == null ? other.myFactory != null : !this.myFactory.equals(other.myFactory)) {
            return false;
        }
        if (this.myOne == null ? other.myOne != null : !this.myOne.equals(other.myOne)) {
            return false;
        }
        return !(this.myZero == null ? other.myZero != null : !this.myZero.equals(other.myZero));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myFactory == null ? 0 : this.myFactory.hashCode());
        result = 31 * result + (this.myOne == null ? 0 : this.myOne.hashCode());
        result = 31 * result + (this.myZero == null ? 0 : this.myZero.hashCode());
        return result;
    }

    @Override
    public final PhysicalStore.Factory<N, ?> physical() {
        return this.myFactory;
    }

    final Scalar<N> one() {
        return this.myOne;
    }

    final Scalar<N> zero() {
        return this.myZero;
    }
}

