/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Transformation2D;

public interface TransformableRegion<N extends Comparable<N>>
extends Mutate2D.ModifiableReceiver<N> {
    @Override
    default public void exchangeColumns(long colA, long colB) {
        long limit = this.countRows();
        for (long i = 0L; i < limit; ++i) {
            Object valA = this.get(i, colA);
            Object valB = this.get(i, colB);
            this.set(i, colB, (Comparable<?>)valA);
            this.set(i, colA, (Comparable<?>)valB);
        }
    }

    @Override
    default public void exchangeRows(long rowA, long rowB) {
        long limit = this.countColumns();
        for (long j = 0L; j < limit; ++j) {
            Object valA = this.get(rowA, j);
            Object valB = this.get(rowB, j);
            this.set(rowB, j, (Comparable<?>)valA);
            this.set(rowA, j, (Comparable<?>)valB);
        }
    }

    public void fillByMultiplying(Access1D<N> var1, Access1D<N> var2);

    @Override
    default public void modifyAny(Transformation2D<N> modifier) {
        modifier.transform(this);
    }

    public TransformableRegion<N> regionByColumns(int ... var1);

    public TransformableRegion<N> regionByLimits(int var1, int var2);

    public TransformableRegion<N> regionByOffsets(int var1, int var2);

    public TransformableRegion<N> regionByRows(int ... var1);

    public TransformableRegion<N> regionByTransposing();

    @FunctionalInterface
    public static interface FillByMultiplying<N extends Comparable<N>> {
        public void invoke(TransformableRegion<N> var1, Access1D<N> var2, int var3, Access1D<N> var4);

        default public void invoke(TransformableRegion<N> product, Access1D<N> left, long complexity, Access1D<N> right) {
            this.invoke(product, left, Math.toIntExact(complexity), right);
        }
    }
}

