/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;

final class ConfiguredIntegration<S extends Optimisation.Solver>
extends ExpressionsBasedModel.Integration<S> {
    private final Predicate<ExpressionsBasedModel> myCapabilityPredicate;
    private final ExpressionsBasedModel.Integration<S> myDelegate;
    private final Consumer<Optimisation.Options> myOptionsModifier;

    ConfiguredIntegration(ExpressionsBasedModel.Integration<S> delegate, Predicate<ExpressionsBasedModel> capabilityPredicate, Consumer<Optimisation.Options> optionsModifier) {
        this.myDelegate = delegate;
        this.myCapabilityPredicate = capabilityPredicate;
        this.myOptionsModifier = optionsModifier;
    }

    @Override
    public S build(ExpressionsBasedModel model) {
        if (this.myOptionsModifier != null) {
            this.myOptionsModifier.accept(model.options);
        }
        return this.myDelegate.build(model);
    }

    @Override
    public boolean isCapable(ExpressionsBasedModel model) {
        return (this.myCapabilityPredicate == null || this.myCapabilityPredicate.test(model)) && this.myDelegate.isCapable(model);
    }

    @Override
    public Optimisation.Result toModelState(Optimisation.Result solverState, ExpressionsBasedModel model) {
        return this.myDelegate.toModelState(solverState, model);
    }

    @Override
    public Optimisation.Result toSolverState(Optimisation.Result modelState, ExpressionsBasedModel model) {
        return this.myDelegate.toSolverState(modelState, model);
    }

    @Override
    protected boolean isSolutionMapped() {
        return this.myDelegate.isSolutionMapped();
    }
}

