/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import java.util.Arrays;
import org.ojalgo.array.SparseArray;
import org.ojalgo.equation.Equation;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.task.iterative.ConjugateGradientSolver;
import org.ojalgo.matrix.task.iterative.MutableSolver;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ActiveSetSolver;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Operate2D;
import org.ojalgo.type.context.NumberContext;

final class IterativeASS
extends ActiveSetSolver {
    static final NumberContext ITERATIVE_ACCURACY = ACCURACY.withPrecision(10);
    private final PhysicalStore<Double> myColumnS;
    private final MyIterativeSolver myS = new MyIterativeSolver();

    IterativeASS(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
        this.myColumnS = (PhysicalStore)Primitive64Store.FACTORY.make(this.countVariables(), 1);
    }

    private void addConstraint(int constrIndex, Access1D<?> constrBody, double constrRHS) {
        MatrixStore<Double> body = this.getSolutionQ(Access2D.newPrimitiveColumnCollectable(constrBody), this.myColumnS);
        double rhs = constrBody.dot(this.getInvQC()) - constrRHS;
        this.myS.add(constrIndex, body, rhs, 3);
    }

    @Override
    protected void exclude(int toExclude) {
        super.exclude(toExclude);
        this.myS.remove(this.countEqualityConstraints() + toExclude);
    }

    @Override
    protected void performIteration() {
        Primitive64Store tmpXL;
        if (this.isLogProgress()) {
            this.log("\nPerformIteration {}", 1 + this.countIterations());
            this.log(this.toActivatorString(), new Object[0]);
        }
        int toInclude = this.getConstraintToInclude();
        this.setConstraintToInclude(-1);
        int[] incl = this.getIncluded();
        int[] excl = this.getExcluded();
        boolean solved = false;
        if (toInclude >= 0) {
            int constrIndex = this.countEqualityConstraints() + toInclude;
            SparseArray<Double> constrBody = this.getMatrixAI(toInclude);
            double constrRHS = this.getMatrixBI(toInclude);
            this.addConstraint(constrIndex, constrBody, constrRHS);
        }
        Primitive64Store iterX = this.getIterationX();
        if (this.countIterationConstraints() <= this.countVariables() && (solved = this.isSolvableQ())) {
            if ((long)this.countIterationConstraints() == 0L) {
                iterX.fillMatching(this.getInvQC());
            } else {
                double relativeError = this.myS.resolve(this.getSolutionL());
                if (this.isLogDebug()) {
                    this.log("RHS={}", new Object[]{this.myS.getRHS()});
                    this.log("Relative error {} in solution for L={}", relativeError, Arrays.toString(this.getIterationL(incl).toRawCopy1D()));
                }
                if (solved = ACCURACY.isZero(relativeError)) {
                    Operate2D rhs = this.getIterationL(incl).premultiply(this.getIterationA().transpose()).onMatching(this.getIterationC(), (BinaryFunction)PrimitiveMath.SUBTRACT);
                    this.getSolutionQ((Access2D.Collectable<Double, ? super PhysicalStore<Double>>)((Object)rhs), iterX);
                }
            }
        }
        if (!solved && (solved = this.solveFullKKT(tmpXL = (Primitive64Store)Primitive64Store.FACTORY.make((long)(this.countVariables() + this.countIterationConstraints()), 1L)))) {
            iterX.fillMatching((Access1D<?>)((Object)tmpXL.limits(this.countVariables(), 1L)));
            for (int i = 0; i < this.countEqualityConstraints(); ++i) {
                this.getSolutionL().set((long)i, tmpXL.doubleValue((long)(this.countVariables() + i)));
            }
            int tmpLengthIncluded = incl.length;
            for (int i = 0; i < tmpLengthIncluded; ++i) {
                this.getSolutionL().set((long)(this.countEqualityConstraints() + incl[i]), tmpXL.doubleValue((long)(this.countVariables() + this.countEqualityConstraints() + i)));
            }
        }
        this.handleIterationResults(solved, iterX, incl, excl);
    }

    @Override
    void resetActivator() {
        super.resetActivator();
        int numbEqus = this.countEqualityConstraints();
        int numbVars = this.countVariables();
        this.myS.clear();
        int[] incl = this.getIncluded();
        if (numbEqus + incl.length > 0) {
            int j;
            MatrixStore<Double> iterA = this.getIterationA();
            MatrixStore<Double> iterB = this.getIterationB();
            MatrixStore<Double> tmpCols = this.getSolutionQ((Access2D.Collectable<Double, ? super PhysicalStore<Double>>)((Object)iterA.transpose()));
            MatrixStore tmpRHS = (MatrixStore)this.getInvQC().premultiply(iterA).onMatching((BinaryFunction)PrimitiveMath.SUBTRACT, iterB).collect(Primitive64Store.FACTORY);
            for (j = 0; j < numbEqus; ++j) {
                this.myS.add(j, tmpCols.sliceColumn(j), tmpRHS.doubleValue(j), numbVars);
            }
            for (j = 0; j < incl.length; ++j) {
                this.myS.add(numbEqus + incl[j], tmpCols.sliceColumn(numbEqus + j), tmpRHS.doubleValue(numbEqus + j), 3);
            }
        }
    }

    final class MyIterativeSolver
    extends MutableSolver<ConjugateGradientSolver>
    implements Access2D<Double> {
        private final PhysicalStore<Double> myColumnE;
        private final int myCountE;
        private final int myFullDim;
        private final Equation[] myIterationRows;

        MyIterativeSolver() {
            super(new ConjugateGradientSolver(), IterativeASS.this.countEqualityConstraints() + IterativeASS.this.countInequalityConstraints());
            this.myCountE = IterativeASS.this.countEqualityConstraints();
            this.myFullDim = this.myCountE + IterativeASS.this.countInequalityConstraints();
            this.setAccuracyContext(ITERATIVE_ACCURACY);
            this.setIterationsLimit(this.myFullDim + this.myFullDim);
            this.myIterationRows = new Equation[this.myFullDim];
            this.myColumnE = (PhysicalStore)Primitive64Store.FACTORY.make(this.myCountE, 1);
        }

        @Override
        public long countColumns() {
            return IterativeASS.this.countEqualityConstraints() + IterativeASS.this.countIncluded();
        }

        @Override
        public long countRows() {
            return IterativeASS.this.countEqualityConstraints() + IterativeASS.this.countIncluded();
        }

        @Override
        public double doubleValue(long row, long col) {
            int tmpColumn = (int)col;
            if (tmpColumn >= this.myCountE) {
                tmpColumn = this.myCountE + IterativeASS.this.getIncluded()[tmpColumn - this.myCountE];
            }
            return this.doubleValue((int)row, tmpColumn);
        }

        @Override
        public Double get(long row, long col) {
            return this.doubleValue(row, col);
        }

        void add(int j, Access1D<Double> column, double rhs, int numberOfNonzeros) {
            double tmpVal;
            Equation tmpNewRow;
            int[] myIncluded = IterativeASS.this.getIncluded();
            this.myIterationRows[j] = tmpNewRow = new Equation(j, this.myFullDim, rhs, numberOfNonzeros);
            this.add(tmpNewRow);
            if (this.myCountE > 0) {
                IterativeASS.this.getMatrixAE().multiply(column, this.myColumnE);
                for (int i = 0; i < this.myCountE; ++i) {
                    tmpVal = this.myColumnE.doubleValue(i);
                    if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpVal)) continue;
                    Equation tmpRowE = this.myIterationRows[i];
                    if (tmpRowE != null) {
                        tmpRowE.set((long)j, tmpVal);
                    }
                    tmpNewRow.set((long)i, tmpVal);
                }
            }
            if (IterativeASS.this.countIncluded() > 0) {
                for (int _i = 0; _i < myIncluded.length; ++_i) {
                    tmpVal = IterativeASS.this.getMatrixAI(myIncluded[_i]).dot(column);
                    if (PrimitiveScalar.isSmall(PrimitiveMath.ONE, tmpVal)) continue;
                    int i = this.myCountE + myIncluded[_i];
                    Equation tmpRowI = this.myIterationRows[i];
                    if (tmpRowI != null) {
                        tmpRowI.set((long)j, tmpVal);
                    }
                    tmpNewRow.set((long)i, tmpVal);
                }
            }
            tmpNewRow.initialise(IterativeASS.this.getSolutionL());
        }

        void remove(int i) {
            Equation tmpO = this.myIterationRows[i];
            if (tmpO != null) {
                this.remove(tmpO);
            }
            this.myIterationRows[i] = null;
            IterativeASS.this.getSolutionL().set((long)i, PrimitiveMath.ZERO);
        }
    }
}

