/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.ProgrammingError;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.Exponential;
import org.ojalgo.random.Poisson;
import org.ojalgo.random.process.SingleValueBasedProcess;

public final class PoissonProcess
extends SingleValueBasedProcess<Poisson> {
    private static final Poisson GENERATOR = new Poisson();
    private final double myRate;

    protected PoissonProcess(double rate) {
        this.setCurrentValue(PrimitiveMath.ZERO);
        this.myRate = rate;
    }

    @Override
    public Poisson getDistribution(double evaluationPoint) {
        return new Poisson(this.myRate * evaluationPoint);
    }

    public Exponential getTimeBetweenConsecutiveEvents() {
        return new Exponential(this.myRate);
    }

    @Override
    double doStep(double stepSize, double normalisedRandomIncrement) {
        double retVal = this.getCurrentValue() + this.myRate * stepSize * normalisedRandomIncrement;
        this.setCurrentValue(retVal);
        return retVal;
    }

    @Override
    double getExpected(double stepSize) {
        return this.myRate * stepSize;
    }

    @Override
    double getLowerConfidenceQuantile(double stepSize, double confidence) {
        ProgrammingError.throwForUnsupportedOptionalOperation();
        return PrimitiveMath.ZERO;
    }

    @Override
    double getNormalisedRandomIncrement() {
        return GENERATOR.doubleValue();
    }

    @Override
    double getStandardDeviation(double stepSize) {
        return PrimitiveMath.SQRT.invoke(this.myRate * stepSize);
    }

    @Override
    double getUpperConfidenceQuantile(double stepSize, double confidence) {
        ProgrammingError.throwForUnsupportedOptionalOperation();
        return PrimitiveMath.ZERO;
    }

    @Override
    double getVariance(double stepSize) {
        return this.myRate * stepSize;
    }
}

