/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import org.ojalgo.scalar.Amount;
import org.ojalgo.scalar.ExactDecimal;
import org.ojalgo.scalar.Price;
import org.ojalgo.scalar.Scalar;

public final class Quantity
extends ExactDecimal<Quantity> {
    public static final ExactDecimal.Descriptor DESCRIPTOR = new ExactDecimal.Descriptor(6);
    public static final Scalar.Factory<Quantity> FACTORY = new ExactDecimal.Factory<Quantity>(){

        @Override
        public Quantity cast(double value) {
            return Quantity.valueOf(value);
        }

        @Override
        public Quantity cast(Comparable<?> number) {
            return Quantity.valueOf(number);
        }

        public Quantity convert(double value) {
            return Quantity.valueOf(value);
        }

        public Quantity convert(Comparable<?> number) {
            return Quantity.valueOf(number);
        }

        @Override
        public ExactDecimal.Descriptor descriptor() {
            return DESCRIPTOR;
        }

        public Quantity one() {
            return ONE;
        }

        public Quantity zero() {
            return ZERO;
        }
    };
    private static final double DOUBLE_DENOMINATOR = 1000000.0;
    private static final long LONG_DENOMINATOR = 1000000L;
    public static final Quantity NEG = new Quantity(-1000000L);
    public static final Quantity ONE = new Quantity(1000000L);
    public static final Quantity TWO = new Quantity(2000000L);
    public static final Quantity ZERO = new Quantity();

    public static Quantity valueOf(double value) {
        return new Quantity(Math.round(value * 1000000.0));
    }

    public static Quantity valueOf(Comparable<?> number) {
        if (number == null) {
            return ZERO;
        }
        if (number instanceof Quantity) {
            return (Quantity)number;
        }
        return Quantity.valueOf(Scalar.doubleValue(number));
    }

    public Quantity() {
        super(0L);
    }

    Quantity(long numerator) {
        super(numerator);
    }

    @Override
    public Amount multiply(Price price) {
        return new Amount(Amount.DESCRIPTOR.multiply(this, price));
    }

    @Override
    protected ExactDecimal.Descriptor descriptor() {
        return DESCRIPTOR;
    }

    @Override
    protected Quantity wrap(long numerator) {
        return new Quantity(numerator);
    }
}

