/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.tensor;

import org.ojalgo.array.Array1D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Factory1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.tensor.ArrayBasedTensor;
import org.ojalgo.tensor.TensorFactory1D;

public final class VectorTensor<N extends Comparable<N>>
extends ArrayBasedTensor<N, VectorTensor<N>>
implements Access1D<N>,
Mutate1D.Receiver<N> {
    private final Array1D<N> myArray;
    private final Array1D.Factory<N> myFactory;

    public static <N extends Comparable<N>> TensorFactory1D<N, VectorTensor<N>> factory(DenseArray.Factory<N> arrayFactory) {
        return new TensorFactory1D(new Factory<N>(arrayFactory));
    }

    VectorTensor(Array1D.Factory<N> factory, int dimensions) {
        super(1, dimensions, factory.function(), factory.scalar());
        this.myFactory = factory;
        this.myArray = (Array1D)factory.make(dimensions);
    }

    @Override
    public VectorTensor<N> add(VectorTensor<N> addend) {
        ArrayBasedTensor retVal = this.newSameShape();
        this.add(((VectorTensor)retVal).getArray(), this.myArray, addend);
        return retVal;
    }

    @Override
    public byte byteValue(long index) {
        return this.myArray.byteValue(index);
    }

    @Override
    public VectorTensor<N> conjugate() {
        return this;
    }

    @Override
    public long count() {
        return this.myArray.count();
    }

    @Override
    public double doubleValue(long index) {
        return this.myArray.doubleValue(index);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof VectorTensor)) {
            return false;
        }
        VectorTensor other = (VectorTensor)obj;
        if (this.myArray == null ? other.myArray != null : !this.myArray.equals(other.myArray)) {
            return false;
        }
        return !(this.myFactory == null ? other.myFactory != null : !this.myFactory.equals(other.myFactory));
    }

    @Override
    public float floatValue(long index) {
        return this.myArray.floatValue(index);
    }

    @Override
    public N get(long index) {
        return this.myArray.get(index);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myArray == null ? 0 : this.myArray.hashCode());
        return 31 * result + (this.myFactory == null ? 0 : this.myFactory.hashCode());
    }

    @Override
    public int intValue(long index) {
        return this.myArray.intValue(index);
    }

    @Override
    public long longValue(long index) {
        return this.myArray.longValue(index);
    }

    @Override
    public VectorTensor<N> multiply(double scalarMultiplicand) {
        ArrayBasedTensor retVal = this.newSameShape();
        this.multiply(((VectorTensor)retVal).getArray(), scalarMultiplicand, this.myArray);
        return retVal;
    }

    @Override
    public VectorTensor<N> multiply(N scalarMultiplicand) {
        ArrayBasedTensor retVal = this.newSameShape();
        this.multiply(((VectorTensor)retVal).getArray(), scalarMultiplicand, this.myArray);
        return retVal;
    }

    @Override
    public VectorTensor<N> negate() {
        ArrayBasedTensor retVal = this.newSameShape();
        this.negate(((VectorTensor)retVal).getArray(), this.myArray);
        return retVal;
    }

    @Override
    public double norm() {
        return this.norm(this.myArray);
    }

    @Override
    public void set(long index, byte value) {
        this.myArray.set(index, value);
    }

    @Override
    public void set(long index, Comparable<?> value) {
        this.myArray.set(index, value);
    }

    @Override
    public void set(long index, double value) {
        this.myArray.set(index, value);
    }

    @Override
    public void set(long index, float value) {
        this.myArray.set(index, value);
    }

    @Override
    public void set(long index, int value) {
        this.myArray.set(index, value);
    }

    @Override
    public void set(long index, long value) {
        this.myArray.set(index, value);
    }

    @Override
    public void set(long index, short value) {
        this.myArray.set(index, value);
    }

    @Override
    public short shortValue(long index) {
        return this.myArray.shortValue(index);
    }

    public String toString() {
        return Access1D.toString(this.myArray);
    }

    Array1D<N> getArray() {
        return this.myArray;
    }

    @Override
    VectorTensor<N> newSameShape() {
        return new VectorTensor<N>(this.myFactory, this.dimensions());
    }

    static final class Factory<N extends Comparable<N>>
    extends ArrayBasedTensor.Factory<N>
    implements Factory1D<VectorTensor<N>> {
        private final Array1D.Factory<N> myFactory;

        Factory(DenseArray.Factory<N> arrayFactory) {
            super(arrayFactory);
            this.myFactory = Array1D.factory(arrayFactory);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || !(obj instanceof Factory)) {
                return false;
            }
            Factory other = (Factory)obj;
            return !(this.myFactory == null ? other.myFactory != null : !this.myFactory.equals(other.myFactory));
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            return 31 * result + (this.myFactory == null ? 0 : this.myFactory.hashCode());
        }

        @Override
        public VectorTensor<N> make(long count) {
            return new VectorTensor<N>(this.myFactory, Math.toIntExact(count));
        }
    }
}

