/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.lang.ref.Cleaner;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public abstract class NativeMemory {
    static final Cleaner CLEANER = Cleaner.create();
    static final long SIZE_BYTE = Unsafe.ARRAY_BYTE_INDEX_SCALE;
    static final long SIZE_DOUBLE = Unsafe.ARRAY_DOUBLE_INDEX_SCALE;
    static final long SIZE_FLOAT = Unsafe.ARRAY_FLOAT_INDEX_SCALE;
    static final long SIZE_INT = Unsafe.ARRAY_INT_INDEX_SCALE;
    static final long SIZE_LONG = Unsafe.ARRAY_LONG_INDEX_SCALE;
    static final long SIZE_SHORT = Unsafe.ARRAY_SHORT_INDEX_SCALE;
    static final Unsafe UNSAFE;
    static final byte ZERO_BYTE = 0;
    static final double ZERO_DOUBLE = 0.0;
    static final float ZERO_FLOAT = 0.0f;
    static final int ZERO_INT = 0;
    static final long ZERO_LONG = 0L;
    static final short ZERO_SHORT = 0;

    public static long allocateByteArray(Object owner, long count) {
        return NativeMemory.allocate(owner, count * SIZE_BYTE);
    }

    public static long allocateDoubleArray(Object owner, long count) {
        return NativeMemory.allocate(owner, count * SIZE_DOUBLE);
    }

    public static long allocateFloatArray(Object owner, long count) {
        return NativeMemory.allocate(owner, count * SIZE_FLOAT);
    }

    public static long allocateIntArray(Object owner, long count) {
        return NativeMemory.allocate(owner, count * SIZE_INT);
    }

    public static long allocateLongArray(Object owner, long count) {
        return NativeMemory.allocate(owner, count * SIZE_LONG);
    }

    public static long allocateShortArray(Object owner, long count) {
        return NativeMemory.allocate(owner, count * SIZE_SHORT);
    }

    public static void fillByteArray(long basePointer, long count, byte value) {
        long limit = basePointer + SIZE_BYTE * count;
        for (long i = basePointer; i < limit; i += SIZE_BYTE) {
            UNSAFE.putByte(i, value);
        }
    }

    public static void fillDoubleArray(long basePointer, long count, double value) {
        long limit = basePointer + SIZE_DOUBLE * count;
        for (long i = basePointer; i < limit; i += SIZE_DOUBLE) {
            UNSAFE.putDouble(i, value);
        }
    }

    public static void fillFloatArray(long basePointer, long count, float value) {
        long limit = basePointer + SIZE_FLOAT * count;
        for (long i = basePointer; i < limit; i += SIZE_FLOAT) {
            UNSAFE.putFloat(i, value);
        }
    }

    public static void fillIntArray(long basePointer, long count, int value) {
        long limit = basePointer + SIZE_INT * count;
        for (long i = basePointer; i < limit; i += SIZE_INT) {
            UNSAFE.putInt(i, value);
        }
    }

    public static void fillLongArray(long basePointer, long count, long value) {
        long limit = basePointer + SIZE_LONG * count;
        for (long i = basePointer; i < limit; i += SIZE_LONG) {
            UNSAFE.putLong(i, value);
        }
    }

    public static void fillShortArray(long basePointer, long count, short value) {
        long limit = basePointer + SIZE_SHORT * count;
        for (long i = basePointer; i < limit; i += SIZE_SHORT) {
            UNSAFE.putShort(i, value);
        }
    }

    public static byte getByte(long basePointer, long index) {
        return UNSAFE.getByte(basePointer + SIZE_BYTE * index);
    }

    public static double getDouble(long basePointer, long index) {
        return UNSAFE.getDouble(basePointer + SIZE_DOUBLE * index);
    }

    public static float getFloat(long basePointer, long index) {
        return UNSAFE.getFloat(basePointer + SIZE_FLOAT * index);
    }

    public static int getInt(long basePointer, long index) {
        return UNSAFE.getInt(basePointer + SIZE_INT * index);
    }

    public static long getLong(long basePointer, long index) {
        return UNSAFE.getLong(basePointer + SIZE_LONG * index);
    }

    public static short getShort(long basePointer, long index) {
        return UNSAFE.getShort(basePointer + SIZE_SHORT * index);
    }

    public static void initialiseByteArray(long basePointer, long count) {
        NativeMemory.fillByteArray(basePointer, count, (byte)0);
    }

    public static void initialiseDoubleArray(long basePointer, long count) {
        NativeMemory.fillDoubleArray(basePointer, count, 0.0);
    }

    public static void initialiseFloatArray(long basePointer, long count) {
        NativeMemory.fillFloatArray(basePointer, count, 0.0f);
    }

    public static void initialiseIntArray(long basePointer, long count) {
        NativeMemory.fillIntArray(basePointer, count, 0);
    }

    public static void initialiseLongArray(long basePointer, long count) {
        NativeMemory.fillLongArray(basePointer, count, 0L);
    }

    public static void initialiseShortArray(long basePointer, long count) {
        NativeMemory.fillShortArray(basePointer, count, (short)0);
    }

    public static void setByte(long basePointer, long index, byte value) {
        UNSAFE.putByte(basePointer + SIZE_BYTE * index, value);
    }

    public static void setDouble(long basePointer, long index, double value) {
        UNSAFE.putDouble(basePointer + SIZE_DOUBLE * index, value);
    }

    public static void setFloat(long basePointer, long index, float value) {
        UNSAFE.putFloat(basePointer + SIZE_FLOAT * index, value);
    }

    public static void setInt(long basePointer, long index, int value) {
        UNSAFE.putInt(basePointer + SIZE_INT * index, value);
    }

    public static void setLong(long basePointer, long index, long value) {
        UNSAFE.putLong(basePointer + SIZE_LONG * index, value);
    }

    public static void setShort(long basePointer, long index, short value) {
        UNSAFE.putShort(basePointer + SIZE_SHORT * index, value);
    }

    static long allocate(Object owner, long bytes) {
        long pointer = UNSAFE.allocateMemory(bytes);
        CLEANER.register(owner, () -> UNSAFE.freeMemory(pointer));
        return pointer;
    }

    static {
        Unsafe tmpUnsafe = null;
        try {
            Field tmpField = Unsafe.class.getDeclaredField("theUnsafe");
            tmpField.setAccessible(true);
            tmpUnsafe = (Unsafe)tmpField.get(null);
        }
        catch (Exception cause) {
            throw new RuntimeException(cause);
        }
        finally {
            UNSAFE = tmpUnsafe;
        }
    }
}

