/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.meteoinfo.chart.ChartElement;
import org.meteoinfo.chart.geo.MapPlot;
import org.meteoinfo.common.PointF;
import org.meteoinfo.render.java2d.Draw;

public class ChartNorthArrow
extends ChartElement {
    private final MapPlot mapPlot;
    private float lineWidth;
    private boolean drawNeatLine;
    private Color neatLineColor;
    private float neatLineSize;
    private NorthArrowType northArrowType;
    private float angle;

    public ChartNorthArrow(MapPlot mapPlot) {
        this.setWidth(50.0f);
        this.setHeight(50.0f);
        this.mapPlot = mapPlot;
        this.lineWidth = 1.0f;
        this.antiAlias = true;
        this.drawNeatLine = false;
        this.neatLineColor = Color.black;
        this.neatLineSize = 1.0f;
        this.northArrowType = NorthArrowType.NORTH_ARROW_1;
        this.angle = 0.0f;
    }

    public MapPlot getMapPlot() {
        return this.mapPlot;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float value) {
        this.lineWidth = value;
    }

    public boolean isDrawNeatLine() {
        return this.drawNeatLine;
    }

    public void setDrawNeatLine(boolean value) {
        this.drawNeatLine = value;
    }

    public Color getNeatLineColor() {
        return this.neatLineColor;
    }

    public void setNeatLineColor(Color color) {
        this.neatLineColor = color;
    }

    public float getNeatLineSize() {
        return this.neatLineSize;
    }

    public void setNeatLineSize(float size) {
        this.neatLineSize = size;
    }

    public NorthArrowType getNorthArrowType() {
        return this.northArrowType;
    }

    public void setNorthArrowType(NorthArrowType value) {
        this.northArrowType = value;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public void draw(Graphics2D g, float x, float y) {
        AffineTransform oldMatrix = g.getTransform();
        g.translate(x, y);
        if (this.angle != 0.0f) {
            g.rotate(this.angle);
        }
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.isDrawBackColor()) {
            g.setColor(this.getBackground());
            g.fill(new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight()));
        }
        this.drawNorthArrow(g);
        if (this.drawNeatLine) {
            Rectangle2D.Float mapRect = new Rectangle2D.Float(this.neatLineSize - 1.0f, this.neatLineSize - 1.0f, this.getWidth() - this.neatLineSize, this.getHeight() - this.neatLineSize);
            g.setColor(this.neatLineColor);
            g.setStroke(new BasicStroke(this.neatLineSize));
            g.draw(mapRect);
        }
        g.setTransform(oldMatrix);
    }

    public void paintGraphics(Graphics2D g, PointF pageLocation, float zoom) {
        AffineTransform oldMatrix = g.getTransform();
        PointF aP = this.pageToScreen(this.getX(), this.getY(), pageLocation, zoom);
        g.translate(aP.X, aP.Y);
        g.scale(zoom, zoom);
        if (this.angle != 0.0f) {
            g.rotate(this.angle);
        }
        if (this.antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.isDrawBackColor()) {
            g.setColor(this.getBackground());
            g.fill(new Rectangle2D.Float(0.0f, 0.0f, this.getWidth() * zoom, this.getHeight() * zoom));
        }
        this.drawNorthArrow(g);
        if (this.drawNeatLine) {
            Rectangle2D.Float mapRect = new Rectangle2D.Float(this.neatLineSize - 1.0f, this.neatLineSize - 1.0f, (this.getWidth() - this.neatLineSize) * zoom, (this.getHeight() - this.neatLineSize) * zoom);
            g.setColor(this.neatLineColor);
            g.setStroke(new BasicStroke(this.neatLineSize));
            g.draw(mapRect);
        }
        g.setTransform(oldMatrix);
    }

    private void drawNorthArrow(Graphics2D g) {
        switch (this.northArrowType) {
            case NORTH_ARROW_1: {
                this.drawNorthArrow1(g);
            }
        }
    }

    private void drawNorthArrow1(Graphics2D g) {
        g.setColor(this.getForeground());
        g.setStroke(new BasicStroke(this.lineWidth));
        PointF[] points = new PointF[4];
        float x = this.getWidth() / 2.0f;
        float y = this.getHeight() / 6.0f;
        float w = this.getWidth() / 6.0f;
        float h = this.getHeight() / 4.0f;
        points[0] = new PointF(x - w / 2.0f, y + h / 2.0f);
        points[1] = new PointF(x - w / 2.0f, y - h / 2.0f);
        points[2] = new PointF(x + w / 2.0f, y + h / 2.0f);
        points[3] = new PointF(x + w / 2.0f, y - h / 2.0f);
        Draw.drawPolyline((PointF[])points, (Graphics2D)g);
        w = this.getWidth() / 2.0f;
        h = this.getHeight() * 2.0f / 3.0f;
        points = new PointF[]{new PointF(x - w / 2.0f, this.getHeight()), new PointF(x, this.getHeight() - h / 2.0f), new PointF(x, this.getHeight() - h)};
        Draw.fillPolygon((PointF[])points, (Graphics2D)g, null);
        Draw.drawPolyline((PointF[])points, (Graphics2D)g);
        points = new PointF[]{new PointF(x + w / 2.0f, this.getHeight()), new PointF(x, this.getHeight() - h / 2.0f), new PointF(x, this.getHeight() - h), points[0]};
        Draw.drawPolyline((PointF[])points, (Graphics2D)g);
    }

    @Override
    public void moveUpdate() {
    }

    @Override
    public void resizeUpdate() {
    }

    public static enum NorthArrowType {
        NORTH_ARROW_1,
        NORTH_ARROW_2;

    }
}

