/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.geo;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.meteoinfo.chart.plot.GridLabelPosition;
import org.meteoinfo.chart.plot.GridLine;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.Direction;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.GridLabel;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.geoprocess.GeoComputation;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.ProjectionUtil;

public class MapGridLine
extends GridLine {
    protected ProjectionInfo projInfo;
    protected Extent extent = new Extent(-100.0, 100.0, -100.0, 100.0);
    protected Extent lonLatExtent = new Extent(-180.0, 180.0, -90.0, 90.0);
    protected List<Double> longitudeLocations;
    protected List<Double> latitudeLocations;
    protected boolean fixLocations = false;
    protected GraphicCollection longitudeLines;
    protected GraphicCollection latitudeLines;
    protected int nPoints = 100;
    protected boolean drawDegreeSymbol = true;
    protected boolean degreeSpace;
    protected List<GridLabel> gridLabels = new ArrayList<GridLabel>();
    protected boolean labelVisible = false;
    protected GridLabelPosition labelPosition = GridLabelPosition.LEFT_BOTTOM;
    protected Color labelColor = Color.BLACK;
    protected Font labelFont = new Font("Arial", 0, 14);

    public MapGridLine() {
        this(false);
    }

    public MapGridLine(boolean visible) {
        super(visible);
        this.lineBreak.setColor(Color.gray);
    }

    public MapGridLine(ProjectionInfo projInfo) {
        this();
        this.projInfo = projInfo;
    }

    public MapGridLine(ProjectionInfo projInfo, Extent extent) {
        this();
        this.projInfo = projInfo;
        this.setExtent(extent);
    }

    public ProjectionInfo getProjInfo() {
        return this.projInfo;
    }

    public void setProjInfo(ProjectionInfo projInfo) {
        this.projInfo = projInfo;
        this.updateLonLatExtent();
    }

    public void setExtent(Extent extent) {
        this.extent = extent == null ? extent : (Extent)extent.clone();
        this.updateLonLatExtent();
    }

    public boolean isDrawDegreeSymbol() {
        return this.drawDegreeSymbol;
    }

    public void setDrawDegreeSymbol(boolean value) {
        this.drawDegreeSymbol = value;
    }

    public void updateLonLatExtent() {
        if (this.projInfo == null || this.extent == null) {
            return;
        }
        if (this.extent.getWidth() == 0.0 || this.extent.getHeight() == 0.0) {
            return;
        }
        this.lonLatExtent = ProjectionUtil.getProjectionExtent((ProjectionInfo)this.projInfo, (ProjectionInfo)ProjectionInfo.LONG_LAT, (Extent)this.extent, (int)100);
        if (!this.fixLocations) {
            this.longitudeLocations = Arrays.stream(MIMath.getIntervalValues((double)this.lonLatExtent.minX, (double)this.lonLatExtent.maxX)).boxed().collect(Collectors.toList());
            this.updateLongitudeLines();
            this.latitudeLocations = Arrays.stream(MIMath.getIntervalValues((double)this.lonLatExtent.minY, (double)this.lonLatExtent.maxY)).boxed().collect(Collectors.toList());
            this.updateLatitudeLines();
            this.updateLonLatGridLabels();
        }
    }

    public void setLongitudeLocations(List<Number> value) {
        this.longitudeLocations = value.stream().map(Number::doubleValue).collect(Collectors.toList());
        this.updateLongitudeLines();
        this.updateLonLatGridLabels();
        this.fixLocations = true;
    }

    public void setLatitudeLocations(List<Number> value) {
        this.latitudeLocations = value.stream().map(Number::doubleValue).collect(Collectors.toList());
        this.updateLatitudeLines();
        this.updateLonLatGridLabels();
        this.fixLocations = true;
    }

    public GraphicCollection getLongitudeLines() {
        return this.longitudeLines;
    }

    public GraphicCollection getLatitudeLines() {
        return this.latitudeLines;
    }

    public boolean isFixLocations() {
        return this.fixLocations;
    }

    public void setFixLocations(boolean value) {
        this.fixLocations = value;
        this.updateLonLatExtent();
    }

    public List<GridLabel> getGridLabels() {
        return this.gridLabels;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean value) {
        this.labelVisible = value;
    }

    public GridLabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(GridLabelPosition value) {
        this.labelPosition = value;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color value) {
        this.labelColor = value;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font value) {
        this.labelFont = value;
    }

    protected void updateLongitudeLines() {
        this.longitudeLines = new GraphicCollection();
        double latMin = this.lonLatExtent.minY;
        double latMax = this.lonLatExtent.maxY;
        double delta = this.lonLatExtent.getHeight() / (double)(this.nPoints - 1);
        if (delta <= 0.0) {
            return;
        }
        for (double lon : this.longitudeLocations) {
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (double lat = latMin; lat < latMax; lat += delta) {
                points.add(new PointD(lon, lat));
            }
            points.add(new PointD(lon, latMax));
            PolylineShape line = new PolylineShape();
            line.setPoints(points);
            Graphic graphic = new Graphic((Shape)line, (ColorBreak)this.lineBreak);
            if ((graphic = ProjectionUtil.projectClipGraphic((Graphic)graphic, (ProjectionInfo)ProjectionInfo.LONG_LAT, (ProjectionInfo)this.projInfo)) == null) continue;
            graphic.getShape().setValue(lon);
            this.longitudeLines.add(graphic);
        }
    }

    protected void updateLatitudeLines() {
        double delta;
        this.latitudeLines = new GraphicCollection();
        double lonMin = this.lonLatExtent.minX;
        double lonMax = this.lonLatExtent.maxX;
        if (lonMin < -170.0) {
            lonMin = -180.0;
        }
        if (lonMax > 170.0) {
            lonMax = 180.0;
        }
        if ((delta = (lonMax - lonMin) / (double)(this.nPoints - 1)) <= 0.0) {
            return;
        }
        for (double lat : this.latitudeLocations) {
            List points = new ArrayList<PointD>();
            for (double lon = lonMin; lon < lonMax; lon += delta) {
                points.add(new PointD(lon, lat));
            }
            PolylineShape line = new PolylineShape();
            line.setPoints(points);
            Graphic graphic = new Graphic((Shape)line, (ColorBreak)this.lineBreak);
            if ((graphic = ProjectionUtil.projectClipGraphic((Graphic)graphic, (ProjectionInfo)ProjectionInfo.LONG_LAT, (ProjectionInfo)this.projInfo)) == null) continue;
            PolylineShape polylineShape = (PolylineShape)graphic.getShape();
            if (polylineShape.getPartNum() > 1) {
                points = ((Polyline)polylineShape.getPolylines().get(0)).getPointList();
                List points1 = ((Polyline)polylineShape.getPolylines().get(1)).getPointList();
                Collections.reverse(points1);
                points.addAll(points1);
                line = new PolylineZShape();
                line.setPoints(points);
                graphic = new Graphic((Shape)line, (ColorBreak)this.lineBreak);
            }
            graphic.getShape().setValue(lat);
            this.latitudeLines.add(graphic);
        }
    }

    protected void updateLonLatGridLabels() {
        ArrayList gLabels;
        String labStr;
        float value;
        PolylineShape line;
        int i;
        if (this.extent == null) {
            return;
        }
        ArrayList<GridLabel> tLabels = new ArrayList<GridLabel>();
        for (i = 0; i < this.longitudeLines.size(); ++i) {
            line = (PolylineShape)this.longitudeLines.getGraphicN(i).getShape();
            value = (float)line.getValue();
            labStr = String.valueOf(value);
            labStr = DataConvert.removeTailingZeros((String)labStr);
            if (value == -180.0f) {
                labStr = "180";
            } else if (value != 0.0f && value != 180.0f) {
                labStr = labStr.substring(0, 1).equals("-") ? labStr.substring(1) + "W" : labStr + "E";
            }
            gLabels = new ArrayList();
            for (Polyline aPL : line.getPolylines()) {
                gLabels.addAll(GeoComputation.getGridLabels((Polyline)aPL, (Extent)this.extent, (boolean)true));
            }
            for (GridLabel gLabel : gLabels) {
                gLabel.setLabString(labStr);
                gLabel.setValue(value);
            }
            tLabels.addAll(gLabels);
        }
        for (i = 0; i < this.latitudeLines.size(); ++i) {
            line = (PolylineShape)this.latitudeLines.getGraphicN(i).getShape();
            value = (float)line.getValue();
            labStr = String.valueOf(value);
            labStr = DataConvert.removeTailingZeros((String)labStr);
            if (value == 90.0f || value == -90.0f) continue;
            if (value != 0.0f) {
                labStr = labStr.substring(0, 1).equals("-") ? labStr.substring(1) + "S" : labStr + "N";
            }
            gLabels = new ArrayList();
            for (Polyline aPL : line.getPolylines()) {
                gLabels.addAll(GeoComputation.getGridLabels((Polyline)aPL, (Extent)this.extent, (boolean)false));
            }
            for (GridLabel gLabel : gLabels) {
                gLabel.setLabString(labStr);
                gLabel.setValue(value);
            }
            tLabels.addAll(gLabels);
        }
        this.gridLabels = new ArrayList<GridLabel>();
        switch (this.projInfo.getProjectionName()) {
            case Lambert_Conformal_Conic: {
                for (GridLabel aGL : tLabels) {
                    if (!aGL.isBorder()) {
                        if (!aGL.isLongitude()) {
                            aGL.setLabDirection(Direction.North);
                        } else {
                            if (aGL.getLabDirection() == Direction.North || aGL.getCoord().Y > 0.0 && Math.abs(aGL.getCoord().X) < 1000.0) continue;
                            if (MIMath.lonDistance((float)aGL.getValue(), (float)((float)this.projInfo.getCenterLon())) > 60.0f) {
                                if (aGL.getCoord().X < 0.0) {
                                    aGL.setLabDirection(Direction.Weast);
                                } else {
                                    aGL.setLabDirection(Direction.East);
                                }
                            } else {
                                aGL.setLabDirection(Direction.South);
                            }
                        }
                    }
                    this.gridLabels.add(aGL);
                }
                break;
            }
            case Albers_Equal_Area: 
            case Lambert_Equal_Area_Conic: {
                for (GridLabel aGL : tLabels) {
                    if (!aGL.isBorder()) {
                        if (!aGL.isLongitude()) {
                            aGL.setLabDirection(Direction.North);
                        } else {
                            if (aGL.getCoord().Y > 7000000.0 && Math.abs(aGL.getCoord().X) < 5000000.0) continue;
                            if (MIMath.lonDistance((float)aGL.getValue(), (float)((float)this.projInfo.getCenterLon())) > 60.0f) {
                                if (aGL.getCoord().X < 0.0) {
                                    aGL.setLabDirection(Direction.Weast);
                                } else {
                                    aGL.setLabDirection(Direction.East);
                                }
                            } else {
                                aGL.setLabDirection(Direction.South);
                            }
                        }
                    }
                    this.gridLabels.add(aGL);
                }
                break;
            }
            case Mercator: {
                for (GridLabel gl : tLabels) {
                    if (!gl.isBorder() && gl.isLongitude() && gl.getCoord().Y > 1000.0) {
                        gl.setLabDirection(Direction.North);
                    }
                    this.gridLabels.add(gl);
                }
                break;
            }
            case North_Polar_Stereographic_Azimuthal: 
            case South_Polar_Stereographic_Azimuthal: {
                for (GridLabel aGL : tLabels) {
                    if (!aGL.isBorder()) {
                        if (!aGL.isLongitude() || Math.abs(aGL.getCoord().X) < 100000.0 && Math.abs(aGL.getCoord().Y) < 100000.0) continue;
                        float refLon = (float)this.projInfo.getCenterLon();
                        if (MIMath.lonDistance((float)aGL.getValue(), (float)refLon) < 45.0f) {
                            if (this.projInfo.getProjectionName() == ProjectionNames.North_Polar_Stereographic_Azimuthal) {
                                aGL.setLabDirection(Direction.South);
                            } else {
                                aGL.setLabDirection(Direction.North);
                            }
                        } else {
                            refLon = MIMath.lonAdd((float)refLon, (float)180.0f);
                            if (MIMath.lonDistance((float)aGL.getValue(), (float)refLon) < 45.0f) {
                                if (this.projInfo.getProjectionName() == ProjectionNames.North_Polar_Stereographic_Azimuthal) {
                                    aGL.setLabDirection(Direction.North);
                                } else {
                                    aGL.setLabDirection(Direction.South);
                                }
                            } else if (aGL.getCoord().X < 0.0) {
                                aGL.setLabDirection(Direction.Weast);
                            } else {
                                aGL.setLabDirection(Direction.East);
                            }
                        }
                    }
                    this.gridLabels.add(aGL);
                }
                break;
            }
            case Robinson: {
                for (GridLabel aGL : tLabels) {
                    if (!aGL.isBorder()) {
                        if (aGL.isLongitude()) {
                            if (aGL.getCoord().Y < 0.0) {
                                aGL.setLabDirection(Direction.South);
                            } else {
                                aGL.setLabDirection(Direction.North);
                            }
                        } else if (aGL.getCoord().X < 0.0) {
                            aGL.setLabDirection(Direction.Weast);
                        } else {
                            aGL.setLabDirection(Direction.East);
                        }
                    }
                    this.gridLabels.add(aGL);
                }
                break;
            }
            case Molleweide: 
            case Hammer_Eckert: {
                for (GridLabel aGL : tLabels) {
                    if (!aGL.isBorder()) {
                        if (aGL.isLongitude()) continue;
                        if (aGL.getCoord().X < 0.0) {
                            aGL.setLabDirection(Direction.Weast);
                        } else {
                            aGL.setLabDirection(Direction.East);
                        }
                    }
                    this.gridLabels.add(aGL);
                }
                break;
            }
            case Orthographic_Azimuthal: 
            case Geostationary_Satellite: {
                for (GridLabel aGL : tLabels) {
                    if (!aGL.isBorder()) {
                        if (aGL.isLongitude()) continue;
                        if (aGL.getCoord().X < 0.0) {
                            aGL.setLabDirection(Direction.Weast);
                        } else {
                            aGL.setLabDirection(Direction.East);
                        }
                    }
                    this.gridLabels.add(aGL);
                }
                break;
            }
            case Oblique_Stereographic_Alternative: 
            case Transverse_Mercator: {
                for (GridLabel aGL : tLabels) {
                    if (!aGL.isBorder()) continue;
                    this.gridLabels.add(aGL);
                }
                break;
            }
            default: {
                this.gridLabels = tLabels;
            }
        }
        if (this.drawDegreeSymbol) {
            for (GridLabel gridLabel : this.gridLabels) {
                String lab = gridLabel.getLabString();
                lab = lab.endsWith("E") || lab.endsWith("W") || lab.endsWith("N") || lab.endsWith("S") ? (this.degreeSpace ? lab.substring(0, lab.length() - 1) + String.valueOf('\u00ba') + " " + lab.substring(lab.length() - 1) : lab.substring(0, lab.length() - 1) + String.valueOf('\u00ba') + lab.substring(lab.length() - 1)) : lab + String.valueOf('\u00ba');
                gridLabel.setLabString(lab);
            }
        }
    }

    public List<GridLabel> getLongitudeLabels() {
        ArrayList<GridLabel> lonLabels = new ArrayList<GridLabel>();
        for (GridLabel label : this.gridLabels) {
            if (!label.isLongitude() || label.getLabDirection() != Direction.South) continue;
            lonLabels.add(label);
        }
        return lonLabels;
    }

    public List<GridLabel> getLatitudeLabels() {
        ArrayList<GridLabel> latLabels = new ArrayList<GridLabel>();
        for (GridLabel label : this.gridLabels) {
            if (label.isLongitude() || label.getLabDirection() != Direction.Weast) continue;
            latLabels.add(label);
        }
        return latLabels;
    }
}

