/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic;

import java.util.List;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.meteoinfo.chart.graphic.TriMeshGraphic;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.math.ArrayMath;

public class Model
extends TriMeshGraphic {
    protected Vector3f location = null;
    protected Vector3f rotation = null;
    protected float scale = 1.0f;
    protected Vector3f direction = null;

    public Vector3f getLocation() {
        return this.location;
    }

    public void setLocation(Vector3f value) {
        this.location = value;
    }

    public void setLocation(List<Number> value) {
        this.location = new Vector3f(value.get(0).floatValue(), value.get(1).floatValue(), value.get(2).floatValue());
    }

    public void setLocation(float x, float y, float z) {
        this.location = new Vector3f(x, y, z);
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public void setRotation(Vector3f value) {
        this.rotation = value;
    }

    public void setRotation(List<Number> value) {
        this.rotation = new Vector3f(value.get(0).floatValue(), value.get(1).floatValue(), value.get(2).floatValue());
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f value) {
        this.direction = value;
    }

    public void setDirection(List<Number> value) {
        this.direction = new Vector3f(value.get(0).floatValue(), value.get(1).floatValue(), value.get(2).floatValue());
    }

    public void setDirection(Vector3f start, Vector3f end) {
        this.direction = end.sub((Vector3fc)start);
    }

    public void setLookAt(List<Number> start, List<Number> end) {
        Vector3f sv = new Vector3f(start.get(0).floatValue(), start.get(1).floatValue(), start.get(2).floatValue());
        Vector3f ev = new Vector3f(end.get(0).floatValue(), end.get(1).floatValue(), end.get(2).floatValue());
        this.direction = ev.sub((Vector3fc)sv);
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float value) {
        this.scale = value;
    }

    public Vector3f getRotationRadians() {
        return new Vector3f((float)Math.toRadians(this.rotation.x), (float)Math.toRadians(this.rotation.y), (float)Math.toRadians(this.rotation.z));
    }

    protected void buildTriMeshGraphic() {
    }

    @Override
    public void setTriangles(Array faceIndices, Array x, Array y, Array z) {
        this.logger.info("Start set triangles...");
        x = x.copyIfView();
        y = y.copyIfView();
        z = z.copyIfView();
        faceIndices = faceIndices.copyIfView();
        this.vertexIndices = (int[])faceIndices.getStorage();
        float xMin = ArrayMath.min((Array)x).floatValue();
        float xMax = ArrayMath.max((Array)x).floatValue();
        float yMin = ArrayMath.min((Array)y).floatValue();
        float yMax = ArrayMath.max((Array)y).floatValue();
        float zMin = ArrayMath.min((Array)z).floatValue();
        float zMax = ArrayMath.max((Array)z).floatValue();
        float range = Math.max(xMax - xMin, yMax - yMin);
        range = zMax - zMin > range ? zMax - zMin : range;
        float min = -range / 2.0f;
        float max = range / 2.0f;
        Transform transform = new Transform();
        transform.setExtent(min, max, min, max, min, max);
        int n = x.getShape()[0];
        this.vertexPosition = new float[n * 3];
        int idx = 0;
        for (int i = 0; i < n; ++i) {
            this.vertexPosition[idx] = transform.transform_x(x.getFloat(i));
            this.vertexPosition[idx + 1] = transform.transform_y(y.getFloat(i));
            this.vertexPosition[idx + 2] = transform.transform_z(z.getFloat(i));
            idx += 3;
        }
        this.updateExtent();
        this.logger.info("Set triangles finished!");
    }

    @Override
    public void setTriangles(Array faceIndices, Array x, Array y, Array z, Array normal) {
        this.logger.info("Start set triangles...");
        x = x.copyIfView();
        y = y.copyIfView();
        z = z.copyIfView();
        faceIndices = faceIndices.copyIfView();
        this.vertexIndices = (int[])faceIndices.getStorage();
        this.vertexNormal = (float[])normal.getStorage();
        float xMin = ArrayMath.min((Array)x).floatValue();
        float xMax = ArrayMath.max((Array)x).floatValue();
        float yMin = ArrayMath.min((Array)y).floatValue();
        float yMax = ArrayMath.max((Array)y).floatValue();
        float zMin = ArrayMath.min((Array)z).floatValue();
        float zMax = ArrayMath.max((Array)z).floatValue();
        float range = Math.max(xMax - xMin, yMax - yMin);
        range = zMax - zMin > range ? zMax - zMin : range;
        float min = -range / 2.0f;
        float max = range / 2.0f;
        Transform transform = new Transform();
        transform.setExtent(min, max, min, max, min, max);
        int n = x.getShape()[0];
        this.vertexPosition = new float[n * 3];
        int idx = 0;
        for (int i = 0; i < n; ++i) {
            this.vertexPosition[idx] = transform.transform_x(x.getFloat(i));
            this.vertexPosition[idx + 1] = transform.transform_y(y.getFloat(i));
            this.vertexPosition[idx + 2] = transform.transform_z(z.getFloat(i));
            idx += 3;
        }
        this.normalLoaded = true;
        this.updateExtent();
        this.logger.info("Set triangles finished!");
    }
}

