/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oshi.hardware.Sensors;
import oshi.util.FileUtil;

public class LinuxSensors
implements Sensors {
    private static final long serialVersionUID = 1L;
    private static final String TEMP = "temp";
    private static final String FAN = "fan";
    private static final String VOLTAGE = "in";
    private static final String[] SENSORS = new String[]{"temp", "fan", "in"};
    private static final String HWMON = "/sys/class/hwmon/hwmon";
    private Map<String, String> hwmonMap = new HashMap<String, String>();

    public LinuxSensors() {
        int i = 0;
        while (Paths.get(HWMON + i, new String[0]).toFile().isDirectory()) {
            for (String sensor : SENSORS) {
                String prefix;
                String path = HWMON + i;
                File dir = new File(path);
                File[] matchingFiles = dir.listFiles(new FileFilter(prefix = sensor){
                    final /* synthetic */ String val$prefix;
                    {
                        this.val$prefix = string;
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.getName().startsWith(this.val$prefix) && f.getName().endsWith("_input");
                    }
                });
                if (matchingFiles == null || matchingFiles.length <= 0) continue;
                this.hwmonMap.put(sensor, String.format("%s/%s", path, sensor));
            }
            ++i;
        }
    }

    @Override
    public double getCpuTemperature() {
        if (!this.hwmonMap.containsKey(TEMP)) {
            return 0.0;
        }
        String hwmon = this.hwmonMap.get(TEMP);
        long millidegrees = FileUtil.getLongFromFile(String.format("%s1_input", hwmon));
        if (millidegrees > 0L) {
            return (double)millidegrees / 1000.0;
        }
        int sum = 0;
        int count = 0;
        for (int i = 2; i <= 6; ++i) {
            millidegrees = FileUtil.getLongFromFile(String.format("%s%d_input", hwmon, i));
            if (millidegrees <= 0L) continue;
            sum = (int)((long)sum + millidegrees);
            ++count;
        }
        if (count > 0) {
            return (double)sum / ((double)count * 1000.0);
        }
        return 0.0;
    }

    @Override
    public int[] getFanSpeeds() {
        if (this.hwmonMap.containsKey(FAN)) {
            String fanPath;
            String hwmon = this.hwmonMap.get(FAN);
            ArrayList<Integer> speeds = new ArrayList<Integer>();
            int fan = 1;
            while (new File(fanPath = String.format("%s%d_input", hwmon, fan)).exists()) {
                speeds.add(FileUtil.getIntFromFile(fanPath));
                ++fan;
            }
            int[] fanSpeeds = new int[speeds.size()];
            for (int i = 0; i < speeds.size(); ++i) {
                fanSpeeds[i] = (Integer)speeds.get(i);
            }
            return fanSpeeds;
        }
        return new int[0];
    }

    @Override
    public double getCpuVoltage() {
        if (this.hwmonMap.containsKey(VOLTAGE)) {
            String hwmon = this.hwmonMap.get(VOLTAGE);
            return (double)FileUtil.getIntFromFile(String.format("%s1_input", hwmon)) / 1000.0;
        }
        return 0.0;
    }
}

