/*
 * Decompiled with CFR 0.152.
 */
package ucar.atd.dorade;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import ucar.atd.dorade.DoradeDescriptor;

class DoradeSSWB
extends DoradeDescriptor {
    private Date lastUseTime;
    private Date startTime;
    private Date endTime;
    private int fileSize;
    private int compressionFlag;
    private Date volumeTime;
    private int nParams;
    private String radarName;
    private int version;
    private int status;
    private int nKeyTables;
    private KeyTable[] keyTables;

    public DoradeSSWB(RandomAccessFile file, boolean littleEndianData) throws DoradeDescriptor.DescriptorException {
        byte[] data = this.readDescriptor(file, littleEndianData, "SSWB");
        if (data == null) {
            throw new IllegalStateException("SSWB data null");
        }
        int intTime = this.grabInt(data, 8);
        this.lastUseTime = new Date((long)intTime * 1000L);
        intTime = this.grabInt(data, 12);
        this.startTime = new Date((long)intTime * 1000L);
        intTime = this.grabInt(data, 16);
        this.endTime = new Date((long)intTime * 1000L);
        this.fileSize = this.grabInt(data, 20);
        this.compressionFlag = this.grabInt(data, 24);
        intTime = this.grabInt(data, 28);
        this.volumeTime = new Date((long)intTime * 1000L);
        this.nParams = this.grabInt(data, 32);
        if (data.length == 36) {
            this.radarName = "";
            this.version = 0;
            this.status = 0;
            this.nKeyTables = 0;
            this.keyTables = null;
        } else {
            this.radarName = new String(data, 36, 8, StandardCharsets.UTF_8).trim();
            int optOffset = data.length == 200 ? 4 : 0;
            double doubleTime = this.grabDouble(data, 44 + optOffset);
            if (doubleTime != 0.0) {
                this.startTime.setTime((long)(doubleTime * 1000.0));
            }
            if ((doubleTime = this.grabDouble(data, 52 + optOffset)) != 0.0) {
                this.endTime.setTime((long)(doubleTime * 1000.0));
            }
            this.version = this.grabInt(data, 60 + optOffset);
            this.nKeyTables = this.grabInt(data, 64 + optOffset);
            this.status = this.grabInt(data, 68 + optOffset);
            this.keyTables = this.nKeyTables > 0 ? new KeyTable[this.nKeyTables] : null;
            for (int i = 0; i < this.nKeyTables; ++i) {
                int entrystart = 100 + 12 * i + optOffset;
                this.keyTables[i] = new KeyTable(this.grabInt(data, entrystart), this.grabInt(data, entrystart + 4), this.grabInt(data, entrystart + 8));
            }
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder("SSWB\n");
        s.append("  last use: ").append(DoradeSSWB.formatDate(this.lastUseTime)).append("\n");
        s.append("  start time: ").append(DoradeSSWB.formatDate(this.startTime)).append("\n");
        s.append("  end time: ").append(DoradeSSWB.formatDate(this.endTime)).append("\n");
        s.append("  file size: ").append(this.fileSize).append("\n");
        s.append("  compression flag: ").append(this.compressionFlag).append("\n");
        s.append("  volume time: ").append(DoradeSSWB.formatDate(this.volumeTime)).append("\n");
        s.append("  number of params: ").append(this.nParams).append("\n");
        s.append("  radar name: ").append(this.radarName).append("\n");
        s.append("  SSWB version: ").append(this.version).append("\n");
        s.append("  status: ").append(this.status).append("\n");
        s.append("  number of key tables: ").append(this.nKeyTables).append("\n");
        for (KeyTable k : this.keyTables) {
            s.append("  key table type contained: ").append(k.type).append("\n");
        }
        return s.toString();
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    private static class KeyTable {
        public int offset;
        public int size;
        public int type;
        public static final int KEYED_BY_TIME = 1;
        public static final int KEYED_BY_ROT_ANG = 2;
        public static final int SOLO_EDIT_SUMMARY = 3;

        public KeyTable(int offset, int size, int type) {
            this.offset = offset;
            this.size = size;
            this.type = type;
        }

        private byte[] readTable(RandomAccessFile raf) throws IOException {
            raf.seek(this.offset);
            byte[] ret = new byte[this.size];
            if (raf.read(ret) != ret.length) {
                throw new IOException("Error reading KeyTable");
            }
            return ret;
        }
    }
}

