/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.interpolate;

import org.meteoinfo.math.MathEx;
import org.meteoinfo.math.interpolate.Interpolation;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

public class KrigingInterpolation1DJ
implements Interpolation {
    private final double[] x;
    private final double[] yvi;
    private final double alpha;
    private final double beta;

    public KrigingInterpolation1DJ(double[] x, double[] y) {
        this(x, y, 1.5);
    }

    public KrigingInterpolation1DJ(double[] x, double[] y, double beta) {
        if (beta < 1.0 || beta >= 2.0) {
            throw new IllegalArgumentException("Invalid beta: " + beta);
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException("x.length != y.length");
        }
        this.x = x;
        this.beta = beta;
        this.alpha = this.pow(x, y);
        int n = x.length;
        double[] yv = new double[n + 1];
        Primitive64Store v = (Primitive64Store)Primitive64Store.FACTORY.make(n + 1, n + 1);
        for (int i = 0; i < n; ++i) {
            yv[i] = y[i];
            for (int j = i; j < n; ++j) {
                double var = this.variogram(Math.abs(x[i] - x[j]));
                v.set((long)i, (long)j, var);
                v.set((long)j, (long)i, var);
            }
            v.set((long)n, (long)i, 1.0);
            v.set((long)i, (long)n, 1.0);
        }
        yv[n] = 0.0;
        v.set((long)n, (long)n, 0.0);
        SingularValue tmpSVD = SingularValue.PRIMITIVE.make((Structure2D)v);
        tmpSVD.decompose((Access2D.Collectable)v);
        MatrixStore solution = tmpSVD.getSolution((Access2D.Collectable)Primitive64Store.FACTORY.column(yv));
        this.yvi = solution.toRawCopy1D();
    }

    @Override
    public double interpolate(double x) {
        int n = this.x.length;
        double y = this.yvi[n];
        for (int i = 0; i < n; ++i) {
            y += this.yvi[i] * this.variogram(Math.abs(x - this.x[i]));
        }
        return y;
    }

    private double pow(double[] x, double[] y) {
        int n = x.length;
        double num = 0.0;
        double denom = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double rb = MathEx.pow2(x[i] - x[j]);
                rb = Math.pow(rb, 0.5 * this.beta);
                num += rb * 0.5 * MathEx.pow2(y[i] - y[j]);
                denom += rb * rb;
            }
        }
        return num / denom;
    }

    private double variogram(double r) {
        return this.alpha * Math.pow(r, this.beta);
    }

    public String toString() {
        return "Kriging Interpolation";
    }
}

