/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.meteo;

import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.Index3D;

public class WRF {
    public static final double GAMMA_SEVEN = 720.0;
    public static final double RHOWAT = 1000.0;
    public static final double RHO_R = 1000.0;
    public static final double RHO_S = 100.0;
    public static final double RHO_G = 400.0;
    public static final double ALPHA = 0.224;
    public static final double CELKEL = 273.15;
    public static final double PI = Math.PI;
    public static final double RD = 287.04;

    public static Array calcDBZ(Array prs, Array tmk, Array qvp, Array qra, Array qsn, Array qgr, int sn0, int ivarint, int iliqskin) {
        int i;
        int j;
        int k;
        int[] shape = prs.getShape();
        int nz = shape[0];
        int ny = shape[1];
        int nx = shape[2];
        double R1 = 1.0E-15;
        double RON = 8000000.0;
        double RON2 = 1.0E10;
        double SON = 2.0E7;
        double GON = 5.0E7;
        double RON_MIN = 8000000.0;
        double RON_QR0 = 1.0E-4;
        double RON_DELQR0 = 0.25 * RON_QR0;
        double RON_CONST1R = (RON2 - RON_MIN) * 0.5;
        double RON_CONST2R = (RON2 + RON_MIN) * 0.5;
        double RN0_R = 8000000.0;
        double RN0_S = 2.0E7;
        double RN0_G = 4000000.0;
        Index3D index = (Index3D)Index3D.factory((int[])shape);
        for (k = 0; k < nz; ++k) {
            for (j = 0; j < ny; ++j) {
                for (i = 0; i < nx; ++i) {
                    index.set(k, j, i);
                    if (qvp.getDouble((Index)index) < 0.0) {
                        qvp.setDouble((Index)index, 0.0);
                    }
                    if (qra.getDouble((Index)index) < 0.0) {
                        qra.setDouble((Index)index, 0.0);
                    }
                    if (qsn.getDouble((Index)index) < 0.0) {
                        qsn.setDouble((Index)index, 0.0);
                    }
                    if (!(qgr.getDouble((Index)index) < 0.0)) continue;
                    qgr.setDouble((Index)index, 0.0);
                }
            }
        }
        if (sn0 == 0) {
            for (k = 0; k < nz; ++k) {
                for (j = 0; j < ny; ++j) {
                    for (i = 0; i < nx; ++i) {
                        index.set(k, j, i);
                        if (!(tmk.getDouble((Index)index) < 273.15)) continue;
                        qsn.setDouble((Index)index, qra.getDouble((Index)index));
                        qra.setDouble((Index)index, 0.0);
                    }
                }
            }
        }
        double factor_r = 7.2E20 * Math.pow(3.183098861837907E-4, 1.75);
        double factor_s = 7.2E20 * Math.pow(0.0031830988618379067, 1.75) * Math.pow(0.1, 2.0) * 0.224;
        double factor_g = 7.2E20 * Math.pow(7.957747154594767E-4, 1.75) * Math.pow(0.4, 2.0) * 0.224;
        Array dbz = Array.factory((DataType)prs.getDataType(), (int[])shape);
        for (k = 0; k < nz; ++k) {
            for (j = 0; j < ny; ++j) {
                for (i = 0; i < nx; ++i) {
                    double ronv;
                    double gonv;
                    double sonv;
                    double factorb_g;
                    double factorb_s;
                    index.set(k, j, i);
                    double virtual_t = tmk.getDouble((Index)index) * (0.622 + qvp.getDouble((Index)index)) / (0.622 * (1.0 + qvp.getDouble((Index)index)));
                    double rhoair = prs.getDouble((Index)index) / (287.04 * virtual_t);
                    if (iliqskin == 1 && tmk.getDouble((Index)index) > 273.15) {
                        factorb_s = factor_s / 0.224;
                        factorb_g = factor_g / 0.224;
                    } else {
                        factorb_s = factor_s;
                        factorb_g = factor_g;
                    }
                    if (ivarint == 1) {
                        double temp_c = Math.min(-0.001, tmk.getDouble((Index)index) - 273.15);
                        sonv = Math.min(2.0E8, 2000000.0 * Math.exp(-0.12 * temp_c));
                        gonv = GON;
                        if (qgr.getDouble((Index)index) > R1) {
                            gonv = 2.38 * Math.pow(1256.6370614359173 / (rhoair * qgr.getDouble((Index)index)), 0.92);
                            gonv = Math.max(10000.0, Math.min(gonv, GON));
                        }
                        ronv = RON2;
                        if (qra.getDouble((Index)index) > R1) {
                            ronv = RON_CONST1R * Math.tanh((RON_QR0 - qra.getDouble((Index)index)) / RON_DELQR0) + RON_CONST2R;
                        }
                    } else {
                        ronv = RN0_R;
                        sonv = RN0_S;
                        gonv = RN0_G;
                    }
                    double z_e = factor_r * Math.pow(rhoair * qra.getDouble((Index)index), 1.75) / Math.pow(ronv, 0.75) + factorb_s * Math.pow(rhoair * qsn.getDouble((Index)index), 1.75) / Math.pow(sonv, 0.75) + factorb_g * Math.pow(rhoair * qgr.getDouble((Index)index), 1.75) / Math.pow(gonv, 0.75);
                    z_e = Math.max(z_e, 0.001);
                    dbz.setDouble((Index)index, 10.0 * Math.log10(z_e));
                }
            }
        }
        return dbz;
    }
}

