/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.spatial.transform;

import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.rotation.QuaternionRotation;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class TransformUtil {
    public static Array rotation(QuaternionRotation quaternionRotation, Array array) {
        if ((array = array.copyIfView()).getRank() == 1) {
            Vector3D v1 = Vector3D.of((double)array.getDouble(0), (double)array.getDouble(1), (double)array.getDouble(2));
            Vector3D v2 = quaternionRotation.apply(v1);
            return Array.factory((DataType)DataType.DOUBLE, (int[])array.getShape(), (Object)v2.toArray());
        }
        int[] shape = array.getShape();
        int ni = shape[0];
        int nj = shape[1];
        Array r = Array.factory((DataType)DataType.DOUBLE, (int[])array.getShape());
        int i = 0;
        while ((long)i < array.getSize()) {
            Vector3D v1 = Vector3D.of((double)array.getDouble(i), (double)array.getDouble(i + 1), (double)array.getDouble(i + 2));
            Vector3D v2 = quaternionRotation.apply(v1);
            r.setDouble(i, v2.getX());
            r.setDouble(i + 1, v2.getY());
            r.setDouble(i + 2, v2.getZ());
            i += 3;
        }
        return r;
    }
}

