/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.JumpableUniformRandomProvider;
import org.apache.commons.rng.LongJumpableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

abstract class AbstractXoShiRo256
extends LongProvider
implements LongJumpableUniformRandomProvider {
    private static final int SEED_SIZE = 4;
    private static final long[] JUMP_COEFFICIENTS = new long[]{1733541517147835066L, -3051731464161248980L, -6244198995065845334L, 4155657270789760540L};
    private static final long[] LONG_JUMP_COEFFICIENTS = new long[]{8566230491382795199L, -4251311993797857357L, 8606660816089834049L, 4111957640723818037L};
    protected long state0;
    protected long state1;
    protected long state2;
    protected long state3;

    AbstractXoShiRo256(long[] seed) {
        if (seed.length < 4) {
            long[] state = new long[4];
            this.fillState(state, seed);
            this.setState(state);
        } else {
            this.setState(seed);
        }
    }

    AbstractXoShiRo256(long seed0, long seed1, long seed2, long seed3) {
        this.state0 = seed0;
        this.state1 = seed1;
        this.state2 = seed2;
        this.state3 = seed3;
    }

    protected AbstractXoShiRo256(AbstractXoShiRo256 source) {
        super(source);
        this.state0 = source.state0;
        this.state1 = source.state1;
        this.state2 = source.state2;
        this.state3 = source.state3;
    }

    private void setState(long[] state) {
        this.state0 = state[0];
        this.state1 = state[1];
        this.state2 = state[2];
        this.state3 = state[3];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.state0, this.state1, this.state2, this.state3}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 32);
        this.setState(NumberFactory.makeLongArray(c[0]));
        super.setStateInternal(c[1]);
    }

    @Override
    public long next() {
        long result = this.nextOutput();
        long t = this.state1 << 17;
        this.state2 ^= this.state0;
        this.state3 ^= this.state1;
        this.state1 ^= this.state2;
        this.state0 ^= this.state3;
        this.state2 ^= t;
        this.state3 = Long.rotateLeft(this.state3, 45);
        return result;
    }

    protected abstract long nextOutput();

    public UniformRandomProvider jump() {
        AbstractXoShiRo256 copy = this.copy();
        this.performJump(JUMP_COEFFICIENTS);
        return copy;
    }

    public JumpableUniformRandomProvider longJump() {
        AbstractXoShiRo256 copy = this.copy();
        this.performJump(LONG_JUMP_COEFFICIENTS);
        return copy;
    }

    protected abstract AbstractXoShiRo256 copy();

    private void performJump(long[] jumpCoefficients) {
        long s0 = 0L;
        long s1 = 0L;
        long s2 = 0L;
        long s3 = 0L;
        for (long jc : jumpCoefficients) {
            for (int b = 0; b < 64; ++b) {
                if ((jc & 1L << b) != 0L) {
                    s0 ^= this.state0;
                    s1 ^= this.state1;
                    s2 ^= this.state2;
                    s3 ^= this.state3;
                }
                this.next();
            }
        }
        this.state0 = s0;
        this.state1 = s1;
        this.state2 = s2;
        this.state3 = s3;
        this.resetCachedState();
    }
}

