/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.oned;

import org.apache.commons.geometry.euclidean.oned.OrientedPoint;
import org.apache.commons.geometry.euclidean.oned.Vector1D;
import org.apache.commons.numbers.core.Precision;

public final class OrientedPoints {
    private OrientedPoints() {
    }

    public static OrientedPoint fromLocationAndDirection(double location, boolean positiveFacing, Precision.DoubleEquivalence precision) {
        return OrientedPoints.fromPointAndDirection(Vector1D.of(location), positiveFacing, precision);
    }

    public static OrientedPoint fromPointAndDirection(Vector1D point, boolean positiveFacing, Precision.DoubleEquivalence precision) {
        return new OrientedPoint(point, positiveFacing, precision);
    }

    public static OrientedPoint fromPointAndDirection(Vector1D point, Vector1D direction, Precision.DoubleEquivalence precision) {
        if (direction.isZero(precision)) {
            throw new IllegalArgumentException("Oriented point direction cannot be zero");
        }
        boolean positiveFacing = direction.getX() > 0.0;
        return new OrientedPoint(point, positiveFacing, precision);
    }

    public static OrientedPoint createPositiveFacing(Vector1D point, Precision.DoubleEquivalence precision) {
        return new OrientedPoint(point, true, precision);
    }

    public static OrientedPoint createPositiveFacing(double location, Precision.DoubleEquivalence precision) {
        return new OrientedPoint(Vector1D.of(location), true, precision);
    }

    public static OrientedPoint createNegativeFacing(Vector1D point, Precision.DoubleEquivalence precision) {
        return new OrientedPoint(point, false, precision);
    }

    public static OrientedPoint createNegativeFacing(double location, Precision.DoubleEquivalence precision) {
        return new OrientedPoint(Vector1D.of(location), false, precision);
    }
}

