/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.meteoinfo.common.Direction;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.GridLabel;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geometry.geoprocess.BorderPoint;
import org.meteoinfo.geometry.shape.Line;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.math.meteo.MeteoMath;

public class GeoComputation
extends org.meteoinfo.geometry.geoprocess.GeoComputation {
    /*
     * Enabled aggressive block sorting
     */
    public static List<GridLabel> getGridLabels(Polyline inPolyLine, Extent clipExtent, boolean isVertical) {
        int i;
        ArrayList<GridLabel> gridLabels = new ArrayList<GridLabel>();
        List aPList = inPolyLine.getPointList();
        if (!GeoComputation.isExtentCross((Extent)inPolyLine.getExtent(), (Object)clipExtent)) {
            return gridLabels;
        }
        ArrayList<List> newLines = new ArrayList<List>();
        boolean isReversed = false;
        if (!GeoComputation.pointInClipObj((Object)clipExtent, (PointD)((PointD)aPList.get(0)))) {
            newLines.add(aPList);
        } else {
            boolean isAllIn = true;
            int notInIdx = 0;
            for (i = 0; i < aPList.size(); ++i) {
                if (GeoComputation.pointInClipObj((Object)clipExtent, (PointD)((PointD)aPList.get(i)))) continue;
                notInIdx = i;
                isAllIn = false;
                break;
            }
            if (!isAllIn) {
                if (inPolyLine.isClosed()) {
                    ArrayList bPList = new ArrayList();
                    bPList.addAll(aPList.subList(notInIdx, aPList.size() - 1));
                    bPList.addAll(aPList.subList(1, notInIdx));
                    bPList.add((PointD)bPList.get(0));
                    newLines.add(bPList);
                } else {
                    Collections.reverse(aPList);
                    newLines.add(aPList);
                    isReversed = true;
                }
            } else {
                PointD p1 = (PointD)aPList.get(0);
                PointD p2 = aPList.size() == 2 ? (PointD)aPList.get(1) : (PointD)aPList.get(2);
                GridLabel aGL = new GridLabel();
                aGL.setLongitude(isVertical);
                aGL.setBorder(false);
                aGL.setCoord(p1);
                if (isVertical) {
                    aGL.setLabDirection(Direction.South);
                } else {
                    aGL.setLabDirection(Direction.Weast);
                }
                aGL.setAnge((float)MeteoMath.uv2ds((double)(p2.X - p1.X), (double)(p2.Y - p1.Y))[0]);
                gridLabels.add(aGL);
                p1 = (PointD)aPList.get(aPList.size() - 1);
                p2 = aPList.size() == 2 ? (PointD)aPList.get(aPList.size() - 2) : (PointD)aPList.get(aPList.size() - 3);
                aGL = new GridLabel();
                aGL.setLongitude(isVertical);
                aGL.setBorder(false);
                aGL.setCoord(p1);
                if (isVertical) {
                    aGL.setLabDirection(Direction.North);
                } else {
                    aGL.setLabDirection(Direction.East);
                }
                aGL.setAnge((float)MeteoMath.uv2ds((double)(p2.X - p1.X), (double)(p2.Y - p1.Y))[0]);
                gridLabels.add(aGL);
                return gridLabels;
            }
        }
        ArrayList<BorderPoint> borderList = new ArrayList<BorderPoint>();
        List clipPList = GeoComputation.getClipPointList((Object)clipExtent);
        for (PointD aP : clipPList) {
            BorderPoint aBP = new BorderPoint();
            aBP.Point = aP;
            aBP.Id = -1;
            borderList.add(aBP);
        }
        int l = 0;
        block2: while (l < newLines.size()) {
            aPList = (List)newLines.get(l);
            boolean isInPolygon = GeoComputation.pointInClipObj((Object)clipExtent, (PointD)((PointD)aPList.get(0)));
            PointD IPoint = new PointD();
            ArrayList<PointD> newPlist = new ArrayList<PointD>();
            PointD p1 = (PointD)aPList.get(0);
            int inIdx = -1;
            int outIdx = -1;
            int a1 = 0;
            i = 1;
            while (true) {
                PointD p2;
                block56: {
                    Line lineB;
                    PointD q2;
                    int j;
                    GridLabel aGL;
                    PointD q1;
                    Line lineA;
                    block57: {
                        block54: {
                            block55: {
                                block52: {
                                    block53: {
                                        if (i >= aPList.size()) break block52;
                                        p2 = (PointD)aPList.get(i);
                                        if (!GeoComputation.pointInClipObj((Object)clipExtent, (PointD)p2)) break block53;
                                        if (isInPolygon) break block54;
                                        lineA = new Line();
                                        lineA.P1 = p1;
                                        lineA.P2 = p2;
                                        q1 = ((BorderPoint)borderList.get((int)0)).Point;
                                        break block55;
                                    }
                                    if (!isInPolygon) break block56;
                                    lineA = new Line();
                                    lineA.P1 = p1;
                                    lineA.P2 = p2;
                                    q1 = ((BorderPoint)borderList.get((int)0)).Point;
                                    break block57;
                                }
                                if (isInPolygon && newPlist.size() > 1) {
                                    aGL = new GridLabel();
                                    aGL.setLongitude(isVertical);
                                    aGL.setBorder(false);
                                    aGL.setCoord((PointD)newPlist.get(newPlist.size() - 1));
                                    if (isVertical) {
                                        if (isReversed) {
                                            aGL.setLabDirection(Direction.South);
                                        } else {
                                            aGL.setLabDirection(Direction.North);
                                        }
                                    } else if (isReversed) {
                                        aGL.setLabDirection(Direction.Weast);
                                    } else {
                                        aGL.setLabDirection(Direction.East);
                                    }
                                    gridLabels.add(aGL);
                                }
                                ++l;
                                continue block2;
                            }
                            for (j = 1; j < borderList.size(); ++j) {
                                q2 = ((BorderPoint)borderList.get((int)j)).Point;
                                lineB = new Line();
                                lineB.P1 = q1;
                                lineB.P2 = q2;
                                if (GeoComputation.isLineSegmentCross((Line)lineA, (Line)lineB)) {
                                    IPoint = GeoComputation.getCrossPoint((Line)lineA, (Line)lineB);
                                    inIdx = j;
                                    break;
                                }
                                q1 = q2;
                            }
                            aGL = new GridLabel();
                            aGL.setLongitude(isVertical);
                            aGL.setBorder(true);
                            aGL.setCoord(IPoint);
                            if (MIMath.doubleEquals((double)q1.X, (double)((BorderPoint)borderList.get((int)j)).Point.X)) {
                                if (MIMath.doubleEquals((double)q1.X, (double)clipExtent.minX)) {
                                    aGL.setLabDirection(Direction.Weast);
                                } else {
                                    aGL.setLabDirection(Direction.East);
                                }
                            } else if (MIMath.doubleEquals((double)q1.Y, (double)clipExtent.minY)) {
                                aGL.setLabDirection(Direction.South);
                            } else {
                                aGL.setLabDirection(Direction.North);
                            }
                            if (isVertical) {
                                if (aGL.getLabDirection() == Direction.South || aGL.getLabDirection() == Direction.North) {
                                    gridLabels.add(aGL);
                                }
                            } else if (aGL.getLabDirection() == Direction.East || aGL.getLabDirection() == Direction.Weast) {
                                gridLabels.add(aGL);
                            }
                        }
                        newPlist.add((PointD)aPList.get(i));
                        isInPolygon = true;
                        break block56;
                    }
                    for (j = 1; j < borderList.size(); ++j) {
                        q2 = ((BorderPoint)borderList.get((int)j)).Point;
                        lineB = new Line();
                        lineB.P1 = q1;
                        lineB.P2 = q2;
                        if (GeoComputation.isLineSegmentCross((Line)lineA, (Line)lineB)) {
                            IPoint = GeoComputation.getCrossPoint((Line)lineA, (Line)lineB);
                            outIdx = j;
                            a1 = inIdx;
                            break;
                        }
                        q1 = q2;
                    }
                    if (j < borderList.size()) {
                        aGL = new GridLabel();
                        aGL.setBorder(true);
                        aGL.setLongitude(isVertical);
                        aGL.setCoord(IPoint);
                        if (MIMath.doubleEquals((double)q1.X, (double)((BorderPoint)borderList.get((int)j)).Point.X)) {
                            if (MIMath.doubleEquals((double)q1.X, (double)clipExtent.minX)) {
                                aGL.setLabDirection(Direction.Weast);
                            } else {
                                aGL.setLabDirection(Direction.East);
                            }
                        } else if (MIMath.doubleEquals((double)q1.Y, (double)clipExtent.minY)) {
                            aGL.setLabDirection(Direction.South);
                        } else {
                            aGL.setLabDirection(Direction.North);
                        }
                        if (isVertical) {
                            if (aGL.getLabDirection() == Direction.South || aGL.getLabDirection() == Direction.North) {
                                gridLabels.add(aGL);
                            }
                        } else if (aGL.getLabDirection() == Direction.East || aGL.getLabDirection() == Direction.Weast) {
                            gridLabels.add(aGL);
                        }
                    }
                    isInPolygon = false;
                    newPlist = new ArrayList();
                }
                p1 = p2;
                ++i;
            }
            break;
        }
        return gridLabels;
    }

    public static List<GridLabel> getGridLabels_StraightLine(Polyline inPolyLine, Extent clipExtent, boolean isVertical) {
        GridLabel aGL;
        ArrayList<GridLabel> gridLabels = new ArrayList<GridLabel>();
        PointD aPoint = (PointD)inPolyLine.getPointList().get(0);
        if (isVertical) {
            if (aPoint.X < clipExtent.minX || aPoint.X > clipExtent.maxX) {
                return gridLabels;
            }
            aGL = new GridLabel();
            aGL.setLabDirection(Direction.South);
            aGL.setCoord(new PointD(aPoint.X, clipExtent.minY));
            gridLabels.add(aGL);
        } else {
            if (aPoint.Y < clipExtent.minY || aPoint.Y > clipExtent.maxY) {
                return gridLabels;
            }
            aGL = new GridLabel();
            aGL.setLabDirection(Direction.Weast);
            aGL.setCoord(new PointD(clipExtent.minX, aPoint.Y));
            gridLabels.add(aGL);
        }
        aPoint = (PointD)inPolyLine.getPointList().get(inPolyLine.getPointList().size() - 1);
        if (isVertical) {
            if (aPoint.X < clipExtent.minX || aPoint.X > clipExtent.maxX) {
                return gridLabels;
            }
            aGL = new GridLabel();
            aGL.setLabDirection(Direction.North);
            aGL.setCoord(new PointD(aPoint.X, clipExtent.maxY));
            gridLabels.add(aGL);
        } else {
            if (aPoint.Y < clipExtent.minY || aPoint.Y > clipExtent.maxY) {
                return gridLabels;
            }
            aGL = new GridLabel();
            aGL.setLabDirection(Direction.East);
            aGL.setCoord(new PointD(clipExtent.maxX, aPoint.Y));
            gridLabels.add(aGL);
        }
        return gridLabels;
    }

    public static boolean pointInPolygonLayer(VectorLayer aLayer, PointD aPoint, boolean onlySel) {
        if (!MIMath.pointInExtent((PointD)aPoint, (Extent)aLayer.getExtent())) {
            return false;
        }
        ArrayList<PolygonShape> polygons = new ArrayList<PolygonShape>();
        if (onlySel) {
            for (Shape shape : aLayer.getShapes()) {
                if (!shape.isSelected()) continue;
                polygons.add((PolygonShape)shape);
            }
        } else {
            for (Shape shape : aLayer.getShapes()) {
                polygons.add((PolygonShape)shape);
            }
        }
        return GeoComputation.pointInPolygons(polygons, (PointD)aPoint);
    }
}

