/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.io;

import java.util.ArrayList;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geo.layer.ImageLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.shape.ImageShape;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PointZShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolygonZShape;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.PolylineZ;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class GraphicUtil {
    public static GraphicCollection layerToGraphics(VectorLayer layer, double xShift) {
        GraphicCollection graphics = new GraphicCollection();
        LegendScheme ls = layer.getLegendScheme();
        if (xShift == 0.0) {
            for (Shape shape : layer.getShapes()) {
                if (shape.getLegendIndex() < 0) continue;
                ColorBreak cb = ls.getLegendBreak(shape.getLegendIndex());
                graphics.add(new Graphic(shape, cb));
            }
        } else {
            for (Shape shape : layer.getShapes()) {
                if (shape.getLegendIndex() < 0) continue;
                for (PointD p : shape.getPoints()) {
                    p.X += xShift;
                }
                shape.updateExtent();
                ColorBreak cb = ls.getLegendBreak(shape.getLegendIndex());
                graphics.add(new Graphic(shape, cb));
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection layerToGraphics_back(VectorLayer layer, double xShift) {
        LegendScheme ls;
        GraphicCollection graphics;
        block22: {
            graphics = new GraphicCollection();
            ShapeTypes shapeType = layer.getShapeType();
            ls = layer.getLegendScheme();
            switch (shapeType) {
                case POINT: {
                    for (PointShape pointShape : layer.getShapes()) {
                        if (pointShape.getLegendIndex() < 0) continue;
                        pointShape.getPoint().X += xShift;
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(pointShape.getLegendIndex());
                        graphics.add(new Graphic((Shape)pointShape, cb));
                    }
                    break;
                }
                case POLYLINE: {
                    for (PolylineShape polylineShape : layer.getShapes()) {
                        if (polylineShape.getLegendIndex() < 0) continue;
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(polylineShape.getLegendIndex());
                        for (Polyline pl : polylineShape.getPolylines()) {
                            PolylineShape s = new PolylineShape();
                            ArrayList<PointD> plist = new ArrayList<PointD>();
                            for (PointD p : pl.getPointList()) {
                                p.X += xShift;
                                plist.add(p);
                            }
                            s.setPoints(plist);
                            graphics.add(new Graphic((Shape)s, cb));
                        }
                    }
                    break;
                }
                case POLYGON: {
                    for (PolygonShape polygonShape : layer.getShapes()) {
                        if (polygonShape.getLegendIndex() < 0) continue;
                        PolygonShape s = new PolygonShape();
                        ArrayList<PointD> plist = new ArrayList<PointD>();
                        for (PointD p : polygonShape.getPoints()) {
                            p.X += xShift;
                            plist.add(p);
                        }
                        s.setPartNum(polygonShape.getPartNum());
                        s.setParts(polygonShape.getParts());
                        s.setPoints(plist);
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(polygonShape.getLegendIndex());
                        graphics.add(new Graphic((Shape)s, cb));
                    }
                    break;
                }
                case POINT_Z: 
                case POLYLINE_Z: 
                case POLYGON_Z: {
                    graphics = new GraphicCollection3D();
                    ((GraphicCollection3D)graphics).setFixZ(false);
                    switch (shapeType) {
                        case POINT_Z: {
                            for (PointZShape pointZShape : layer.getShapes()) {
                                if (pointZShape.getLegendIndex() < 0) continue;
                                ((PointZ)pointZShape.getPoint()).X += xShift;
                                ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(pointZShape.getLegendIndex());
                                graphics.add(new Graphic((Shape)pointZShape, cb));
                            }
                            break block22;
                        }
                        case POLYLINE_Z: {
                            for (PolylineZShape polylineZShape : layer.getShapes()) {
                                if (polylineZShape.getLegendIndex() < 0) continue;
                                ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(polylineZShape.getLegendIndex());
                                for (PointZ p : polylineZShape.getPoints()) {
                                    p.X += xShift;
                                }
                                graphics.add(new Graphic((Shape)polylineZShape, cb));
                            }
                            break block22;
                        }
                        case POLYGON_Z: {
                            for (PolygonZShape polygonZShape : layer.getShapes()) {
                                if (polygonZShape.getLegendIndex() < 0) continue;
                                PolygonZShape s = new PolygonZShape();
                                ArrayList<PointZ> plist = new ArrayList<PointZ>();
                                for (PointZ p : polygonZShape.getPoints()) {
                                    p.X += xShift;
                                    plist.add(p);
                                }
                                s.setPartNum(polygonZShape.getPartNum());
                                s.setParts(polygonZShape.getParts());
                                s.setPoints(plist);
                                ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(polygonZShape.getLegendIndex());
                                graphics.add(new Graphic((Shape)s, cb));
                            }
                        }
                    }
                }
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection layerToGraphics(VectorLayer layer, double offset, double xshift) {
        LegendScheme ls;
        GraphicCollection3D graphics;
        block23: {
            graphics = new GraphicCollection3D();
            graphics.setFixZ(true);
            graphics.setZValue(offset);
            ShapeTypes shapeType = layer.getShapeType();
            ls = layer.getLegendScheme();
            switch (shapeType) {
                case POINT: {
                    for (PointShape pointShape : layer.getShapes()) {
                        PointZShape s = new PointZShape();
                        PointD pd = pointShape.getPoint();
                        PointZ pz = new PointZ(pd.X + xshift, pd.Y, offset);
                        s.setPoint((PointD)pz);
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(pointShape.getLegendIndex());
                        graphics.add(new Graphic((Shape)s, cb));
                    }
                    break;
                }
                case POLYLINE: {
                    for (PolylineShape polylineShape : layer.getShapes()) {
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(polylineShape.getLegendIndex());
                        for (Polyline pl : polylineShape.getPolylines()) {
                            PolylineZShape s = new PolylineZShape();
                            ArrayList<PointZ> plist = new ArrayList<PointZ>();
                            for (PointD pd : pl.getPointList()) {
                                PointZ pz = new PointZ(pd.X + xshift, pd.Y, offset);
                                plist.add(pz);
                            }
                            s.setPoints(plist);
                            graphics.add(new Graphic((Shape)s, cb));
                        }
                    }
                    break;
                }
                case POLYGON: {
                    for (PolygonShape polygonShape : layer.getShapes()) {
                        PolygonZShape s = new PolygonZShape();
                        ArrayList<PointZ> plist = new ArrayList<PointZ>();
                        for (PointD pd : polygonShape.getPoints()) {
                            PointZ pz = new PointZ(pd.X + xshift, pd.Y, offset);
                            plist.add(pz);
                        }
                        s.setPartNum(polygonShape.getPartNum());
                        s.setParts(polygonShape.getParts());
                        s.setPoints(plist);
                        ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(polygonShape.getLegendIndex());
                        graphics.add(new Graphic((Shape)s, cb));
                    }
                    break;
                }
                case POINT_Z: 
                case POLYLINE_Z: 
                case POLYGON_Z: {
                    graphics.setFixZ(false);
                    switch (shapeType) {
                        case POINT_Z: {
                            for (PointZShape pointZShape : layer.getShapes()) {
                                PointZShape s = new PointZShape();
                                PointZ pd = (PointZ)pointZShape.getPoint();
                                PointZ pz = new PointZ(pd.X + xshift, pd.Y, pd.Z + offset, pd.M);
                                s.setPoint((PointD)pz);
                                ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(pointZShape.getLegendIndex());
                                graphics.add(new Graphic((Shape)s, cb));
                            }
                            break block23;
                        }
                        case POLYLINE_Z: {
                            for (PolylineZShape polylineZShape : layer.getShapes()) {
                                ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(polylineZShape.getLegendIndex());
                                for (PolylineZ pl : polylineZShape.getPolylines()) {
                                    PolylineZShape s = new PolylineZShape();
                                    ArrayList<PointZ> plist = new ArrayList<PointZ>();
                                    for (PointZ pd : pl.getPointList()) {
                                        PointZ pz = new PointZ(pd.X + xshift, pd.Y, pd.Z + offset, pd.M);
                                        plist.add(pz);
                                    }
                                    s.setPoints(plist);
                                    graphics.add(new Graphic((Shape)s, cb));
                                }
                            }
                            break block23;
                        }
                        case POLYGON_Z: {
                            for (PolygonZShape polygonZShape : layer.getShapes()) {
                                PolygonZShape s = new PolygonZShape();
                                ArrayList<PointZ> plist = new ArrayList<PointZ>();
                                for (PointZ pd : polygonZShape.getPoints()) {
                                    PointZ pz = new PointZ(pd.X + xshift, pd.Y, pd.Z + offset, pd.M);
                                    plist.add(pz);
                                }
                                s.setPartNum(polygonZShape.getPartNum());
                                s.setParts(polygonZShape.getParts());
                                s.setPoints(plist);
                                ColorBreak cb = (ColorBreak)ls.getLegendBreaks().get(polygonZShape.getLegendIndex());
                                graphics.add(new Graphic((Shape)s, cb));
                            }
                        }
                    }
                }
            }
        }
        graphics.setLegendScheme(ls);
        return graphics;
    }

    public static GraphicCollection layerToGraphics(ImageLayer layer, double xShift, String interpolation) {
        GraphicCollection graphics = new GraphicCollection();
        ImageShape ishape = new ImageShape();
        ishape.setImage(layer.getImage());
        Extent extent = layer.getExtent();
        extent = extent.shift(xShift, 0.0);
        ArrayList<PointZ> coords = new ArrayList<PointZ>();
        coords.add(new PointZ(extent.minX + xShift, extent.minY, 0.0));
        coords.add(new PointZ(extent.maxX + xShift, extent.minY, 0.0));
        coords.add(new PointZ(extent.maxX + xShift, extent.maxY, 0.0));
        coords.add(new PointZ(extent.minX + xShift, extent.maxY, 0.0));
        ishape.setExtent(extent);
        ishape.setCoords(coords);
        Graphic gg = new Graphic((Shape)ishape, new ColorBreak());
        if (interpolation != null) {
            ((ImageShape)gg.getShape()).setInterpolation(interpolation);
        }
        graphics.add(gg);
        return graphics;
    }

    public static GraphicCollection layerToGraphics(ImageLayer layer, double offset, double xshift, String interpolation) {
        GraphicCollection3D graphics = new GraphicCollection3D();
        graphics.setFixZ(true);
        graphics.setZDir("z");
        graphics.setZValue(offset);
        ImageShape ishape = new ImageShape();
        ishape.setImage(layer.getImage());
        Extent extent = layer.getExtent();
        Extent3D ex3 = new Extent3D(extent.minX + xshift, extent.maxX + xshift, extent.minY, extent.maxY, offset, offset);
        ArrayList<PointZ> coords = new ArrayList<PointZ>();
        coords.add(new PointZ(extent.minX + xshift, extent.minY, offset));
        coords.add(new PointZ(extent.maxX + xshift, extent.minY, offset));
        coords.add(new PointZ(extent.maxX + xshift, extent.maxY, offset));
        coords.add(new PointZ(extent.minX + xshift, extent.maxY, offset));
        ishape.setExtent((Extent)ex3);
        ishape.setCoords(coords);
        Graphic gg = new Graphic((Shape)ishape, new ColorBreak());
        if (interpolation != null) {
            ((ImageShape)gg.getShape()).setInterpolation(interpolation);
        }
        graphics.add(gg);
        return graphics;
    }
}

