/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.util;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.PointD;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.GridDataSetting;
import org.meteoinfo.data.StationData;
import org.meteoinfo.geo.analysis.GeoComputation;
import org.meteoinfo.geo.analysis.InterpolationSetting;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.math.interpolate.InterpUtil;
import wcontour.Interpolate;

public class GeoMathUtil {
    public static GridData maskout(GridData gridData, PolygonShape aPGS) {
        int xNum = gridData.getXNum();
        int yNum = gridData.getYNum();
        GridData cGrid = new GridData(gridData);
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        for (int i = 0; i < yNum; ++i) {
            int j;
            if (yArray[i] >= aPGS.getExtent().minY && yArray[i] <= aPGS.getExtent().maxY) {
                for (j = 0; j < xNum; ++j) {
                    if (xArray[j] >= aPGS.getExtent().minX && xArray[j] <= aPGS.getExtent().maxX) {
                        if (GeoComputation.pointInPolygon((PolygonShape)aPGS, (PointD)new PointD(xArray[j], yArray[i]))) {
                            cGrid.setValue(i, j, gridData.getDoubleValue(i, j));
                            continue;
                        }
                        cGrid.setValue(i, j, gridData.getDoubleMissingValue());
                        continue;
                    }
                    cGrid.setValue(i, j, gridData.getDoubleMissingValue());
                }
                continue;
            }
            for (j = 0; j < xNum; ++j) {
                cGrid.setValue(i, j, gridData.getDoubleMissingValue());
            }
        }
        return cGrid;
    }

    public static GridData maskout(GridData gridData, List<PolygonShape> polygons) {
        int xNum = gridData.getXNum();
        int yNum = gridData.getYNum();
        GridData cGrid = new GridData(gridData);
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                if (GeoComputation.pointInPolygons(polygons, (PointD)new PointD(xArray[j], yArray[i]))) {
                    cGrid.setValue(i, j, gridData.getDoubleValue(i, j));
                    continue;
                }
                cGrid.setValue(i, j, gridData.getDoubleMissingValue());
            }
        }
        return cGrid;
    }

    public static GridData maskout(GridData gridData, VectorLayer maskLayer) {
        if (maskLayer.getShapeType() != ShapeTypes.POLYGON) {
            return gridData;
        }
        int xNum = gridData.getXNum();
        int yNum = gridData.getYNum();
        GridData cGrid = new GridData(gridData);
        double[] xArray = gridData.getXArray();
        double[] yArray = gridData.getYArray();
        for (int i = 0; i < yNum; ++i) {
            int j;
            if (yArray[i] >= maskLayer.getExtent().minY && yArray[i] <= maskLayer.getExtent().maxY) {
                for (j = 0; j < xNum; ++j) {
                    if (xArray[j] >= maskLayer.getExtent().minX && xArray[j] <= maskLayer.getExtent().maxX) {
                        if (GeoComputation.pointInPolygonLayer(maskLayer, new PointD(xArray[j], yArray[i]), false)) {
                            cGrid.setValue(i, j, gridData.getDoubleValue(i, j));
                            continue;
                        }
                        cGrid.setValue(i, j, gridData.getDoubleMissingValue());
                        continue;
                    }
                    cGrid.setValue(i, j, gridData.getDoubleMissingValue());
                }
                continue;
            }
            for (j = 0; j < xNum; ++j) {
                cGrid.setValue(i, j, gridData.getDoubleMissingValue());
            }
        }
        return cGrid;
    }

    public static StationData maskout(StationData stationData, PolygonShape polygonShape) {
        StationData stData = new StationData();
        stData.projInfo = stationData.projInfo;
        stData.missingValue = stationData.missingValue;
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (!GeoComputation.pointInPolygon((PolygonShape)polygonShape, (PointD)new PointD(stationData.getX(i), stationData.getY(i)))) continue;
            stData.addData(stationData.getStid(i), stationData.getX(i), stationData.getY(i), stationData.getValue(i));
        }
        return stData;
    }

    public static StationData maskout(StationData stationData, List<PolygonShape> polygonShapes) {
        StationData stData = new StationData();
        stData.projInfo = stationData.projInfo;
        stData.missingValue = stationData.missingValue;
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (!GeoComputation.pointInPolygons(polygonShapes, (PointD)new PointD(stationData.getX(i), stationData.getY(i)))) continue;
            stData.addData(stationData.getStid(i), stationData.getX(i), stationData.getY(i), stationData.getValue(i));
        }
        return stData;
    }

    public static StationData maskout(StationData stationData, VectorLayer maskLayer) {
        if (maskLayer.getShapeType() != ShapeTypes.POLYGON) {
            return stationData;
        }
        List<? extends Shape> polygons = maskLayer.getShapes();
        return GeoMathUtil.maskout(stationData, polygons);
    }

    public static StationData maskin(StationData stationData, PolygonShape polygonShape) {
        StationData stData = new StationData();
        stData.projInfo = stationData.projInfo;
        stData.missingValue = stationData.missingValue;
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (GeoComputation.pointInPolygon((PolygonShape)polygonShape, (PointD)new PointD(stationData.getX(i), stationData.getY(i)))) continue;
            stData.addData(stationData.getStid(i), stationData.getX(i), stationData.getY(i), stationData.getValue(i));
        }
        return stData;
    }

    public static StationData maskin(StationData stationData, List<PolygonShape> polygonShapes) {
        StationData stData = new StationData();
        stData.projInfo = stationData.projInfo;
        stData.missingValue = stationData.missingValue;
        for (int i = 0; i < stationData.getStNum(); ++i) {
            if (GeoComputation.pointInPolygons(polygonShapes, (PointD)new PointD(stationData.getX(i), stationData.getY(i)))) continue;
            stData.addData(stationData.getStid(i), stationData.getX(i), stationData.getY(i), stationData.getValue(i));
        }
        return stData;
    }

    public static StationData maskin(StationData stationData, VectorLayer maskLayer) {
        if (maskLayer.getShapeType() != ShapeTypes.POLYGON) {
            return stationData;
        }
        List<? extends Shape> polygons = maskLayer.getShapes();
        return GeoMathUtil.maskin(stationData, polygons);
    }

    public static GridData interpolateData(StationData stationData, InterpolationSetting interSet) {
        GridData aGridData = null;
        List<double[]> values = GeoMathUtil.createGridXY(interSet.getGridDataSetting());
        double[] X = values.get(0);
        double[] Y = values.get(1);
        switch (interSet.getInterpolationMethod()) {
            case IDW_RADIUS: {
                stationData.filterData_Radius(interSet.getRadius(), interSet.getGridDataSetting().dataExtent);
                aGridData = GeoMathUtil.interpolate_Radius(stationData.data, X, Y, interSet.getMinPointNum(), interSet.getRadius(), stationData.missingValue);
                break;
            }
            case IDW_NEIGHBORS: {
                stationData.filterData_Radius(interSet.getRadius(), interSet.getGridDataSetting().dataExtent);
                aGridData = GeoMathUtil.interpolate_Neighbor(stationData.data, X, Y, interSet.getMinPointNum(), stationData.missingValue);
                break;
            }
            case CRESSMAN: {
                stationData.filterData_Radius(0.0, interSet.getGridDataSetting().dataExtent);
                aGridData = GeoMathUtil.interpolate_Cressman(stationData.data, X, Y, interSet.getRadiusList(), stationData.missingValue);
                break;
            }
            case BARNES: {
                stationData.filterData_Radius(0.0, interSet.getGridDataSetting().dataExtent);
                double[][] gData = InterpUtil.barnes((double[])stationData.getX(), (double[])stationData.getY(), (double[])stationData.getStData(), (double[])X, (double[])Y, interSet.getRadiusList(), (double)1.0, (double)1.0);
                aGridData = new GridData(gData, X, Y);
                break;
            }
            case KRIGING: {
                stationData.filterData_Radius(0.0, interSet.getGridDataSetting().dataExtent);
                double[][] gData = InterpUtil.kriging((double[])stationData.getX(), (double[])stationData.getY(), (double[])stationData.getStData(), (double[])X, (double[])Y, (double)interSet.getBeta());
                aGridData = new GridData(gData, X, Y);
                break;
            }
            case ASSIGN_POINT_GRID: {
                stationData.filterData_Radius(0.0, interSet.getGridDataSetting().dataExtent);
                aGridData = GeoMathUtil.interpolate_Assign(stationData.data, X, Y, stationData.missingValue);
            }
        }
        return aGridData;
    }

    public static GridData interpolate_Radius(double[][] S, double[] X, double[] Y, int minPNum, double radius, double missingValue) {
        double[][] dataArray = Interpolate.interpolation_IDW_Radius((double[][])S, (double[])X, (double[])Y, (int)minPNum, (double)radius, (double)missingValue);
        return new GridData(dataArray, X, Y, missingValue);
    }

    public static GridData interpolate_Radius(StationData stationData, List<Number> X, List<Number> Y, int minPNum, double radius, double missingValue) {
        int i;
        double[] nX = new double[X.size()];
        double[] nY = new double[Y.size()];
        for (i = 0; i < X.size(); ++i) {
            nX[i] = X.get(i).doubleValue();
        }
        for (i = 0; i < Y.size(); ++i) {
            nY[i] = Y.get(i).doubleValue();
        }
        return GeoMathUtil.interpolate_Radius(stationData.data, nX, nY, minPNum, radius, missingValue);
    }

    public static GridData interpolate_Neighbor(double[][] S, double[] X, double[] Y, int pNum, double missingValue) {
        double[][] dataArray = Interpolate.interpolation_IDW_Neighbor((double[][])S, (double[])X, (double[])Y, (int)pNum, (double)missingValue);
        return new GridData(dataArray, X, Y, missingValue);
    }

    public static GridData interpolate_Neighbor(StationData stationData, List<Number> X, List<Number> Y, int pNum, double missingValue) {
        int i;
        double[] nX = new double[X.size()];
        double[] nY = new double[Y.size()];
        for (i = 0; i < X.size(); ++i) {
            nX[i] = X.get(i).doubleValue();
        }
        for (i = 0; i < Y.size(); ++i) {
            nY[i] = Y.get(i).doubleValue();
        }
        return GeoMathUtil.interpolate_Neighbor(stationData.data, nX, nY, pNum, missingValue);
    }

    public static GridData interpolate_Cressman(double[][] S, double[] X, double[] Y, List<Double> radList, double missingValue) {
        double[][] dataArray = Interpolate.cressman((double[][])S, (double[])X, (double[])Y, (double)missingValue, radList);
        return new GridData(dataArray, X, Y, missingValue);
    }

    public static GridData interpolate_Cressman(StationData stationData, List<Number> X, List<Number> Y, List<Number> radList, double missingValue) {
        int i;
        double[] nX = new double[X.size()];
        double[] nY = new double[Y.size()];
        for (i = 0; i < X.size(); ++i) {
            nX[i] = X.get(i).doubleValue();
        }
        for (i = 0; i < Y.size(); ++i) {
            nY[i] = Y.get(i).doubleValue();
        }
        ArrayList<Double> rlist = new ArrayList<Double>();
        for (Number r : radList) {
            rlist.add(r.doubleValue());
        }
        return GeoMathUtil.interpolate_Cressman(stationData.data, nX, nY, rlist, missingValue);
    }

    public static GridData interpolate_Assign(double[][] S, double[] X, double[] Y, double missingValue) {
        double[][] dataArray = Interpolate.assignPointToGrid((double[][])S, (double[])X, (double[])Y, (double)missingValue);
        return new GridData(dataArray, X, Y, missingValue);
    }

    public static GridData interpolate_Assign(StationData stationData, List<Number> X, List<Number> Y, double missingValue) {
        int i;
        double[] nX = new double[X.size()];
        double[] nY = new double[Y.size()];
        for (i = 0; i < X.size(); ++i) {
            nX[i] = X.get(i).doubleValue();
        }
        for (i = 0; i < Y.size(); ++i) {
            nY[i] = Y.get(i).doubleValue();
        }
        return GeoMathUtil.interpolate_Assign(stationData.data, nX, nY, missingValue);
    }

    public static List<double[]> createGridXY(GridDataSetting gSet) {
        double xDelt = (gSet.dataExtent.maxX - gSet.dataExtent.minX) / (double)(gSet.xNum - 1);
        double yDelt = (gSet.dataExtent.maxY - gSet.dataExtent.minY) / (double)(gSet.yNum - 1);
        return Interpolate.createGridXY_Delt((double)gSet.dataExtent.minX, (double)gSet.dataExtent.minY, (double)gSet.dataExtent.maxX, (double)gSet.dataExtent.maxY, (double)xDelt, (double)yDelt);
    }
}

