/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.IndexIterator;

public class Statistics {
    public static int valueCount(List<Double> aDataList, double value) {
        int count = 0;
        for (Double v : aDataList) {
            if (!(v >= value)) continue;
            ++count;
        }
        return count;
    }

    public static double sum(List<Double> aDataList) {
        double aSum = 0.0;
        for (Double v : aDataList) {
            aSum += v.doubleValue();
        }
        return aSum;
    }

    public static double mean(List<Double> aDataList) {
        double aSum = 0.0;
        for (Double v : aDataList) {
            aSum += v.doubleValue();
        }
        return aSum / (double)aDataList.size();
    }

    public static double maximum(List<Double> aDataList) {
        double aMax = aDataList.get(0);
        for (int i = 1; i < aDataList.size(); ++i) {
            aMax = Math.max(aMax, aDataList.get(i));
        }
        return aMax;
    }

    public static double minimum(List<Double> aDataList) {
        double aMin = aDataList.get(0);
        for (int i = 1; i < aDataList.size(); ++i) {
            aMin = Math.min(aMin, aDataList.get(i));
        }
        return aMin;
    }

    public static double median(List<Double> aDataList) {
        Collections.sort(aDataList);
        if (aDataList.size() % 2 == 0) {
            return (aDataList.get(aDataList.size() / 2) + aDataList.get(aDataList.size() / 2 - 1)) / 2.0;
        }
        return aDataList.get(aDataList.size() / 2);
    }

    public static double quantile(List<Double> aDataList, int aNum) {
        Collections.sort(aDataList);
        double aData = 0.0;
        switch (aNum) {
            case 0: {
                aData = Statistics.minimum(aDataList);
                break;
            }
            case 1: {
                if ((aDataList.size() + 1) % 4 == 0) {
                    aData = aDataList.get((aDataList.size() + 1) / 4 - 1);
                    break;
                }
                aData = aDataList.get((aDataList.size() + 1) / 4 - 1) + 0.75 * (aDataList.get((aDataList.size() + 1) / 4) - aDataList.get((aDataList.size() + 1) / 4 - 1));
                break;
            }
            case 2: {
                aData = Statistics.median(aDataList);
                break;
            }
            case 3: {
                if ((aDataList.size() + 1) % 4 == 0) {
                    aData = aDataList.get((aDataList.size() + 1) * 3 / 4 - 1);
                    break;
                }
                aData = aDataList.get((aDataList.size() + 1) * 3 / 4 - 1) + 0.25 * (aDataList.get((aDataList.size() + 1) * 3 / 4) - aDataList.get((aDataList.size() + 1) * 3 / 4 - 1));
                break;
            }
            case 4: {
                aData = Statistics.maximum(aDataList);
            }
        }
        return aData;
    }

    public static double quantile(Array a, int aNum) {
        ArrayList<Double> dlist = new ArrayList<Double>();
        IndexIterator ii = a.getIndexIterator();
        while (ii.hasNext()) {
            double v = ii.getDoubleNext();
            if (Double.isNaN(v)) continue;
            dlist.add(v);
        }
        if (dlist.size() <= 3) {
            return Double.NaN;
        }
        return Statistics.quantile(dlist, aNum);
    }

    public static double quantile(List<Double> aDataList, double qValue) {
        Collections.sort(aDataList);
        double aData = qValue == 0.0 ? Statistics.minimum(aDataList) : (qValue == 1.0 ? Statistics.maximum(aDataList) : aDataList.get((int)((double)aDataList.size() * qValue) - 1));
        return aData;
    }

    public static double standardDeviation(List<Double> aDataList) {
        double theStdDev;
        double theMean = Statistics.mean(aDataList);
        double theSumSqDev = 0.0;
        for (int i = 0; i < aDataList.size(); ++i) {
            double theValue = aDataList.get(i);
            double theSqDev = (theValue - theMean) * (theValue - theMean);
            theSumSqDev = theSqDev + theSumSqDev;
        }
        if (aDataList.size() > 1) {
            double theVariance = theSumSqDev / (double)(aDataList.size() - 1);
            theStdDev = Math.sqrt(theVariance);
        } else {
            theStdDev = 0.0;
        }
        return theStdDev;
    }
}

