/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.micaps;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.ITrajDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.TrajectoryInfo;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.hysplit.HYSPLITTrajDataInfo;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;
import org.meteoinfo.table.ColumnData;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataTable;

public class MICAPS7DataInfo
extends DataInfo
implements ITrajDataInfo {
    private int trajNum;
    private List<TrajectoryInfo> trajInfoList;
    private String[] varNames;
    private int pointNum;
    private List<DataTable> dataTables;
    private String[] inVarNames;

    public MICAPS7DataInfo() {
        this.setDataType(MeteoDataType.MICAPS_7);
        this.initVariables();
    }

    private void initVariables() {
        this.varNames = new String[]{"time", "run_hour", "lon", "lat", "wind_speed", "pressure", "radius_7", "radius_10", "move_dir", "move_speed"};
        this.inVarNames = new String[]{"time", "run_hour", "lon", "lat"};
    }

    @Override
    public String getXVarName() {
        return "lon";
    }

    @Override
    public String getYVarName() {
        return "lat";
    }

    @Override
    public String getZVarName() {
        return null;
    }

    @Override
    public String getTVarName() {
        return "time";
    }

    @Override
    public List<TrajectoryInfo> getTrajInfoList() {
        return this.trajInfoList;
    }

    @Override
    public List<DataTable> getDataTables() {
        return this.dataTables;
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDataInfo(String fileName) {
        this.setFileName(fileName);
        this.initVariables();
        ArrayList<Double> times = new ArrayList<Double>();
        this.pointNum = 0;
        BufferedReader sr = null;
        try {
            sr = new BufferedReader(new FileReader(fileName));
            this.trajInfoList = new ArrayList<TrajectoryInfo>();
            TrajectoryInfo aTrajInfo = new TrajectoryInfo();
            sr.readLine();
            String aLine = sr.readLine();
            int trajIdx = -1;
            this.trajNum = 0;
            while (aLine != null) {
                if (aLine.trim().isEmpty()) {
                    aLine = sr.readLine();
                    continue;
                }
                String[] dataArray = aLine.split("\\s+");
                if (dataArray.length == 4) {
                    aTrajInfo = new TrajectoryInfo();
                    aTrajInfo.trajName = dataArray[0];
                    aTrajInfo.trajID = dataArray[1];
                    aTrajInfo.trajCenter = dataArray[2];
                    int pn = Integer.parseInt(dataArray[3]);
                    if (this.pointNum < pn) {
                        this.pointNum = pn;
                    }
                    trajIdx = -1;
                    ++this.trajNum;
                } else if (dataArray.length == 13 && ++trajIdx == 0) {
                    int year = Integer.parseInt(dataArray[0]);
                    if (year < 100) {
                        year = year < 50 ? 2000 + year : 1900 + year;
                    }
                    LocalDateTime tt = LocalDateTime.of(year, Integer.parseInt(dataArray[1]), Integer.parseInt(dataArray[2]), Integer.parseInt(dataArray[3]), 0, 0);
                    if (times.isEmpty()) {
                        times.add(JDateUtil.toOADate((LocalDateTime)tt));
                    }
                    aTrajInfo.startTime = tt;
                    aTrajInfo.startLat = Float.parseFloat(dataArray[6]);
                    aTrajInfo.startLon = Float.parseFloat(dataArray[5]);
                    this.trajInfoList.add(aTrajInfo);
                }
                aLine = sr.readLine();
            }
            sr.close();
            Dimension trajDim = new Dimension(DimensionType.OTHER);
            trajDim.setName("trajectory");
            trajDim.setLength(this.trajNum);
            this.addDimension(trajDim);
            Dimension obsDim = new Dimension(DimensionType.OTHER);
            obsDim.setName("obs");
            obsDim.setLength(this.pointNum);
            this.addDimension(obsDim);
            for (String vName : this.varNames) {
                Variable var = new Variable();
                var.setName(vName);
                switch (vName) {
                    case "time": {
                        var.setDataType(DataType.DATE);
                        break;
                    }
                    case "run_hour": {
                        var.setDataType(DataType.INT);
                        break;
                    }
                    default: {
                        var.setDataType(DataType.FLOAT);
                    }
                }
                var.addDimension(trajDim);
                var.addDimension(obsDim);
                var.addAttribute("long_name", vName);
                if (!Arrays.asList(this.inVarNames).contains(vName)) {
                    var.setStation(true);
                }
                this.addVariable(var);
            }
            this.dataTables = this.readTable();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "";
        dataInfo = dataInfo + "File Name: " + this.fileName;
        dataInfo = dataInfo + System.getProperty("line.separator") + "Typhoon number = " + String.valueOf(this.trajNum);
        dataInfo = dataInfo + System.getProperty("line.separator") + System.getProperty("line.separator") + "Typhoons:";
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:00");
        for (TrajectoryInfo aTrajInfo : this.trajInfoList) {
            dataInfo = dataInfo + System.getProperty("line.separator") + "  " + aTrajInfo.trajName + " " + aTrajInfo.trajID + " " + aTrajInfo.trajCenter + " " + format.format(aTrajInfo.startTime) + "  " + String.valueOf(aTrajInfo.startLat) + "  " + String.valueOf(aTrajInfo.startLon) + "  " + String.valueOf(aTrajInfo.startHeight);
        }
        dataInfo = dataInfo + System.getProperty("line.separator") + super.generateInfoText();
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        int[] origin = new int[]{0, 0};
        int[] size = new int[]{this.trajNum, this.pointNum};
        int[] stride = new int[]{1, 1};
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            DataColumn col = this.dataTables.get(0).findColumn(varName);
            DataType dtype = col.getDataType();
            switch (col.getDataType()) {
                case DATE: {
                    dtype = DataType.DOUBLE;
                }
            }
            Section section = new Section(origin, size, stride);
            Array array = Array.factory((DataType)dtype, (int[])section.getShape());
            Range trajRange = section.getRange(0);
            Range obsRange = section.getRange(1);
            Index index = array.getIndex();
            for (int trajIdx = trajRange.first(); trajIdx <= trajRange.last(); trajIdx += trajRange.stride()) {
                DataTable dTable = this.dataTables.get(trajIdx);
                ColumnData colData = dTable.getColumnData(varName);
                for (int obsIdx = obsRange.first(); obsIdx <= obsRange.last(); obsIdx += obsRange.stride()) {
                    if (colData.size() > obsIdx) {
                        if (col.getDataType() == DataType.DATE) {
                            array.setObject(index, (Object)JDateUtil.toOADate((LocalDateTime)((LocalDateTime)colData.getValue(obsIdx))));
                        } else {
                            array.setObject(index, colData.getValue(obsIdx));
                        }
                    } else {
                        array.setObject(index, (Object)Double.NaN);
                    }
                    index.incr();
                }
            }
            return array;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<DataTable> readTable() throws Exception {
        ArrayList<DataTable> tables = new ArrayList<DataTable>();
        for (int i = 0; i < this.trajNum; ++i) {
            DataTable table = new DataTable();
            for (Variable variable : this.variables) {
                table.addColumn(variable.getName(), variable.getDataType());
            }
            tables.add(table);
        }
        try {
            BufferedReader sr = new BufferedReader(new FileReader(this.getFileName()));
            int trajId = -1;
            sr.readLine();
            String line = sr.readLine();
            while (line != null) {
                if ((line = line.trim()).isEmpty()) {
                    line = sr.readLine();
                    continue;
                }
                String[] dataArray = line.split("\\s+");
                switch (dataArray.length) {
                    case 4: {
                        ++trajId;
                        break;
                    }
                    case 13: {
                        DataTable dataTable = (DataTable)tables.get(trajId);
                        dataTable.addRow();
                        int rowIdx = dataTable.getRowCount() - 1;
                        int year = Integer.parseInt(dataArray[0]);
                        year = year < 50 ? 2000 + year : 1900 + year;
                        LocalDateTime tt = LocalDateTime.of(year, Integer.parseInt(dataArray[1]), Integer.parseInt(dataArray[2]), Integer.parseInt(dataArray[3]), 0, 0);
                        int runHour = Integer.parseInt(dataArray[4]);
                        tt = tt.plusHours(runHour);
                        int i = 3;
                        String[] stringArray = this.varNames;
                        int n = stringArray.length;
                        for (int j = 0; j < n; ++j) {
                            String vName;
                            switch (vName = stringArray[j]) {
                                case "time": {
                                    dataTable.setValue(rowIdx, vName, (Object)tt);
                                    break;
                                }
                                case "run_hour": {
                                    dataTable.setValue(rowIdx, vName, (Object)runHour);
                                    break;
                                }
                                default: {
                                    float v = Float.parseFloat(dataArray[i]);
                                    if (v == 9999.0f) {
                                        v = Float.NaN;
                                    }
                                    dataTable.setValue(rowIdx, vName, (Object)Float.valueOf(v));
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                }
                line = sr.readLine();
            }
            sr.close();
        }
        catch (IOException ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(HYSPLITTrajDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<Object>> getATrajData(int aTrajIdx) {
        ArrayList<List<Object>> trajPointsData = new ArrayList<List<Object>>();
        boolean ifExit = false;
        BufferedReader sr = null;
        try {
            sr = new BufferedReader(new FileReader(this.fileName));
            int TrajIdx = -1;
            sr.readLine();
            String aLine = sr.readLine();
            while (aLine != null) {
                if (aLine.trim().isEmpty()) {
                    aLine = sr.readLine();
                    continue;
                }
                String[] dataArray = aLine.split("\\s+");
                switch (dataArray.length) {
                    case 4: {
                        if (++TrajIdx <= aTrajIdx) break;
                        ifExit = true;
                        break;
                    }
                    case 13: {
                        if (TrajIdx != aTrajIdx) break;
                        ArrayList<Object> dList = new ArrayList<Object>();
                        LocalDateTime tt = LocalDateTime.of(Integer.parseInt(dataArray[0]), Integer.parseInt(dataArray[1]), Integer.parseInt(dataArray[2]), Integer.parseInt(dataArray[3]), 0, 0);
                        PointD aPoint = new PointD();
                        aPoint.X = Double.parseDouble(dataArray[5]);
                        aPoint.Y = Double.parseDouble(dataArray[6]);
                        dList.add(aPoint);
                        dList.add(tt);
                        dList.add(Double.parseDouble(dataArray[7]));
                        trajPointsData.add(dList);
                    }
                }
                if (ifExit) break;
                aLine = sr.readLine();
            }
            sr.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                sr.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPS7DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return trajPointsData;
    }
}

