/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.dock.dockable.MovingImage;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class TrueMovingImage
extends JPanel
implements MovingImage {
    private BufferedImage image;
    private float alpha = 1.0f;
    private boolean transparent = true;

    public void setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f || Float.isNaN(alpha)) {
            throw new IllegalArgumentException("alpha must be between 0 and 1");
        }
        this.alpha = alpha;
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.image != null) {
            if (this.alpha == 1.0f || !this.transparent) {
                g.drawImage(this.image, 0, 0, this);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                Composite old = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(11, this.alpha));
                g.drawImage(this.image, 0, 0, this);
                g2.setComposite(old);
            }
        }
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        if (image != null) {
            this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        }
        this.repaint();
    }

    @Override
    public Point getOffset(Point pressPoint) {
        return null;
    }

    @Override
    public void bind(boolean transparency) {
        this.transparent = transparency;
        this.setOpaque(!transparency);
    }

    @Override
    public void unbind() {
    }

    @Override
    public Component getComponent() {
        return this;
    }
}

