/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.event;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class VetoableDockFrontendEvent
implements Iterable<Dockable> {
    private DockFrontend frontend;
    private Dockable[] dockables;
    private boolean cancelable;
    private boolean canceled = false;
    private boolean expected;

    public VetoableDockFrontendEvent(DockFrontend frontend, boolean cancelable, boolean expected, Dockable ... dockables) {
        if (dockables.length < 1) {
            throw new IllegalArgumentException("An empty event is not allowed");
        }
        this.frontend = frontend;
        this.dockables = dockables;
        this.cancelable = cancelable;
        this.expected = expected;
    }

    public DockFrontend getFrontend() {
        return this.frontend;
    }

    public int getDockableCount() {
        return this.dockables.length;
    }

    public Dockable getDockable(int index) {
        return this.dockables[index];
    }

    public Dockable[] getDockables() {
        Dockable[] copy = new Dockable[this.dockables.length];
        System.arraycopy(this.dockables, 0, copy, 0, this.dockables.length);
        return copy;
    }

    @Override
    public Iterator<Dockable> iterator() {
        return new Iterator<Dockable>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < VetoableDockFrontendEvent.this.dockables.length;
            }

            @Override
            public Dockable next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return VetoableDockFrontendEvent.this.dockables[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public void cancel() {
        if (this.cancelable) {
            this.canceled = true;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isExpected() {
        return this.expected;
    }
}

