/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.layout;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.dockable.DefaultDockableFactory;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.layout.DefaultLocationEstimationMap;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.MissingDockFactory;
import bibliothek.gui.dock.perspective.Perspective;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.station.flap.FlapDockStationFactory;
import bibliothek.gui.dock.station.split.SplitDockStationFactory;
import bibliothek.gui.dock.station.stack.StackDockStationFactory;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DockSituation {
    public static final Path DOCK_FACTORY_EXTENSION = new Path("dock.DockSituation.DockFactory");
    public static final Path ADJACENT_DOCK_FACTORY_EXTENSION = new Path("dock.DockSituation.AdjacentDockFactory");
    public static final String EXTENSION_PARAM = "situation";
    private Map<String, DockFactory<?, ?, ?>> factories = new HashMap();
    private MissingDockFactory missingFactory;
    private Map<String, AdjacentDockFactory<?>> adjacent = new HashMap();
    private MissingDockFactory missingAdjacent;
    private DockSituationIgnore ignore;
    private PlaceholderStrategy intermediatePlaceholders;
    private PlaceholderStrategy placeholders;

    public DockSituation(DockFactory<?, ?, ?> ... factories) {
        for (DockFactory<?, ?, ?> factory : factories) {
            this.factories.put(this.getID(factory), factory);
        }
    }

    public DockSituation(DockController controller) {
        this(new DefaultDockableFactory(), new SplitDockStationFactory(), new StackDockStationFactory(), new FlapDockStationFactory());
        List<DockFactory> factories = controller.getExtensions().load(new ExtensionName<DockFactory>(DOCK_FACTORY_EXTENSION, DockFactory.class, EXTENSION_PARAM, this));
        for (DockFactory factory : factories) {
            this.add(factory);
        }
        List<AdjacentDockFactory> adjacent = controller.getExtensions().load(new ExtensionName<AdjacentDockFactory>(ADJACENT_DOCK_FACTORY_EXTENSION, AdjacentDockFactory.class, EXTENSION_PARAM, this));
        for (AdjacentDockFactory factory : adjacent) {
            this.addAdjacent(factory);
        }
    }

    public Perspective createPerspective() {
        return new Perspective(this){

            @Override
            protected String getID(PerspectiveElement element) {
                return DockSituation.this.getID(element);
            }

            @Override
            protected DockFactory<?, ?, ?> getFactory(String id) {
                return DockSituation.this.getFactory(id);
            }
        };
    }

    public void setIgnore(DockSituationIgnore ignore) {
        this.ignore = ignore;
    }

    public DockSituationIgnore getIgnore() {
        return this.ignore;
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholders) {
        this.placeholders = placeholders;
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholders;
    }

    public void setIntermediatePlaceholders(PlaceholderStrategy intermediatePlaceholders) {
        this.intermediatePlaceholders = intermediatePlaceholders;
    }

    public PlaceholderStrategy getIntermediatePlaceholders() {
        return this.intermediatePlaceholders;
    }

    protected Path getPlaceholder(DockElement element) {
        if (this.placeholders == null) {
            return null;
        }
        Dockable dockable = element.asDockable();
        if (dockable == null) {
            return null;
        }
        return this.placeholders.getPlaceholderFor(dockable);
    }

    public void add(DockFactory<?, ?, ?> factory) {
        this.factories.put(this.getID(factory), factory);
    }

    public void addAdjacent(AdjacentDockFactory<?> factory) {
        this.adjacent.put(this.getAdjacentID(factory), factory);
    }

    public void setMissingFactory(MissingDockFactory missingFactory) {
        this.missingFactory = missingFactory;
    }

    public MissingDockFactory getMissingFactory() {
        return this.missingFactory;
    }

    public void setMissingAdjacentFactory(MissingDockFactory missingAdjacent) {
        this.missingAdjacent = missingAdjacent;
    }

    public MissingDockFactory getMissingAdjacentFactory() {
        return this.missingAdjacent;
    }

    public DockLayoutComposition convert(DockElement element) {
        if (this.ignoreElement(element)) {
            return null;
        }
        String id = this.getID(element);
        DockFactory<DockElement, ?, ?> factory = this.getFactory(id);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown factory-id: " + element.getFactoryID());
        }
        DockStation station = element.asDockStation();
        HashMap<Dockable, Integer> ids = new HashMap<Dockable, Integer>();
        ArrayList<DockLayoutComposition> children = new ArrayList<DockLayoutComposition>();
        boolean ignore = false;
        if (station != null && !(ignore = this.ignoreChildren(station))) {
            int index = 0;
            int n = station.getDockableCount();
            for (int i = 0; i < n; ++i) {
                Dockable dockable = station.getDockable(i);
                DockLayoutComposition dockLayoutComposition = this.convert(dockable);
                if (dockLayoutComposition == null) continue;
                children.add(dockLayoutComposition);
                ids.put(dockable, index++);
            }
        }
        Object data = factory.getLayout(element, ids);
        DockLayout layout = new DockLayout(id, data);
        ArrayList adjacent = null;
        for (AdjacentDockFactory adjacentDockFactory : this.adjacent.values()) {
            if (!adjacentDockFactory.interested(element)) continue;
            Object adjacentData = adjacentDockFactory.getLayout(element, ids);
            if (adjacent == null) {
                adjacent = new ArrayList();
            }
            adjacent.add(new DockLayout(this.getAdjacentID(adjacentDockFactory), adjacentData));
        }
        DockLayoutInfo info = new DockLayoutInfo(layout);
        info.setPlaceholder(this.getPlaceholder(element));
        return new DockLayoutComposition(info, adjacent, children, ignore);
    }

    public DockElement convert(DockLayoutComposition composition) {
        List<DockLayout<?>> adjacent;
        DockLayoutInfo info = composition.getLayout();
        if (info == null) {
            return null;
        }
        DockLayout<?> layout = info.getDataLayout();
        if (layout == null) {
            return null;
        }
        DockFactory<DockElement, ?, ?> factory = this.getFactory(layout.getFactoryID());
        if (factory == null) {
            return null;
        }
        DockElement result = null;
        HashMap<Integer, Dockable> children = null;
        if (composition.isIgnoreChildren()) {
            for (DockLayoutComposition childComposition : composition.getChildren()) {
                this.convert(childComposition);
            }
            result = factory.layout(layout.getData(), this.placeholders);
        } else {
            children = new HashMap<Integer, Dockable>();
            int index = 0;
            for (DockLayoutComposition dockLayoutComposition : composition.getChildren()) {
                Dockable dockable;
                DockElement child = this.convert(dockLayoutComposition);
                if (child != null && (dockable = child.asDockable()) != null) {
                    children.put(index, dockable);
                    if (dockable.getDockParent() != null) {
                        dockable.getDockParent().drag(dockable);
                    }
                }
                ++index;
            }
            result = factory.layout(layout.getData(), children, this.placeholders);
        }
        if (result != null && (adjacent = composition.getAdjacent()) != null) {
            for (DockLayout dockLayout : adjacent) {
                AdjacentDockFactory<?> adjacentFactory = this.getAdjacentFactory(dockLayout.getFactoryID());
                if (adjacentFactory == null) continue;
                if (children == null) {
                    adjacentFactory.setLayout(result, dockLayout.getData(), this.placeholders);
                    continue;
                }
                adjacentFactory.setLayout(result, dockLayout.getData(), children, this.placeholders);
            }
        }
        return result;
    }

    public void writeComposition(DockLayoutComposition composition, DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_8);
        this.writeCompositionStream(composition, out);
    }

    private void writeCompositionStream(DockLayoutComposition composition, DataOutputStream out) throws IOException {
        DockLayoutInfo info = composition.getLayout();
        Path placeholder = info.getPlaceholder();
        out.writeBoolean(placeholder != null);
        if (placeholder != null) {
            out.writeUTF(placeholder.toString());
        }
        if (info.getKind() == DockLayoutInfo.Data.BYTE) {
            out.write(info.getDataByte());
        } else if (info.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
            DockLayout<?> layout = info.getDataLayout();
            DockFactory<? extends DockElement, ?, ?> factory = this.getFactory(layout.getFactoryID());
            if (factory == null) {
                throw new IOException("Missing factory: " + layout.getFactoryID());
            }
            out.writeUTF(this.getID(factory));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(byteArrayOutputStream);
            factory.write(layout.getData(), dout);
            dout.close();
            out.writeInt(byteArrayOutputStream.size());
            byteArrayOutputStream.writeTo(out);
        } else {
            throw new IllegalArgumentException("Cannot store layout in stream: it was never translated and its raw format is not a byte stream");
        }
        List<DockLayout<?>> adjacentLayouts = composition.getAdjacent();
        if (adjacentLayouts == null) {
            out.writeInt(0);
        } else {
            out.writeInt(adjacentLayouts.size());
            for (DockLayout dockLayout : adjacentLayouts) {
                AdjacentDockFactory<?> adjacentFactory = this.getAdjacentFactory(dockLayout.getFactoryID());
                if (adjacentFactory == null) {
                    throw new IOException("Missing adjacent factory: " + dockLayout.getFactoryID());
                }
                ByteArrayOutputStream adjacentBOut = new ByteArrayOutputStream();
                DataOutputStream adjacentOut = new DataOutputStream(adjacentBOut);
                adjacentFactory.write(dockLayout.getData(), adjacentOut);
                adjacentOut.close();
                out.writeUTF(this.getAdjacentID(adjacentFactory));
                out.writeInt(adjacentBOut.size());
                adjacentBOut.writeTo(out);
            }
        }
        out.writeBoolean(composition.isIgnoreChildren());
        List<DockLayoutComposition> children = composition.getChildren();
        out.writeInt(children.size());
        for (DockLayoutComposition child : children) {
            this.writeCompositionStream(child, out);
        }
    }

    public DockLayoutComposition readComposition(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        return this.readCompositionStream(in, version);
    }

    private DockLayoutComposition readCompositionStream(DataInputStream in, Version version) throws IOException {
        int layoutCount;
        Path entryPlaceholder = null;
        if (Version.VERSION_1_0_8.compareTo(version) <= 0 && in.readBoolean()) {
            entryPlaceholder = new Path(in.readUTF());
        }
        byte[] entry = this.readBuffer(in);
        DockLayoutInfo info = this.readEntry(entry, entryPlaceholder);
        ArrayList adjacentLayouts = null;
        if (Version.VERSION_1_0_7.compareTo(version) <= 0 && (layoutCount = in.readInt()) > 0) {
            adjacentLayouts = new ArrayList(layoutCount);
            for (int i = 0; i < layoutCount; ++i) {
                Object data;
                DataInputStream din;
                int adjacentCount;
                String adjacentFactoryId = in.readUTF();
                AdjacentDockFactory<?> adjacentFactory = this.getAdjacentFactory(adjacentFactoryId);
                if (adjacentFactory == null) {
                    if (this.missingAdjacent == null) {
                        int skipped;
                        for (adjacentCount = in.readInt(); adjacentCount > 0; adjacentCount -= skipped) {
                            skipped = (int)in.skip(adjacentCount);
                            if (skipped > 0) continue;
                            throw new EOFException();
                        }
                        continue;
                    }
                    din = this.readBuffer(in, adjacentCount);
                    data = this.missingAdjacent.read(this.getAdjacentFactoryID(adjacentFactoryId), din, adjacentCount);
                    if (data != null) {
                        adjacentLayouts.add(new DockLayout(adjacentFactoryId, data));
                    }
                    din.close();
                    continue;
                }
                din = this.readBuffer(in, adjacentCount);
                data = adjacentFactory.read(din, this.intermediatePlaceholders);
                if (data != null) {
                    adjacentLayouts.add(new DockLayout(adjacentFactoryId, data));
                }
                din.close();
            }
        }
        boolean ignore = in.readBoolean();
        ArrayList<DockLayoutComposition> children = new ArrayList<DockLayoutComposition>();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            children.add(this.readCompositionStream(in, version));
        }
        return new DockLayoutComposition(info, adjacentLayouts, children, ignore);
    }

    private DockLayoutInfo readEntry(byte[] entry, Path placeholder) throws IOException {
        DockLayoutInfo info;
        DataInputStream entryIn = new DataInputStream(new ByteArrayInputStream(entry));
        String factoryId = entryIn.readUTF();
        DockFactory<DockElement, ?, ?> factory = this.getFactory(factoryId);
        int count = entryIn.readInt();
        if (factory == null) {
            info = null;
            if (this.missingFactory != null) {
                Object data = this.missingFactory.read(this.getFactoryID(factoryId), entryIn, count);
                entryIn.close();
                if (data != null) {
                    info = new DockLayoutInfo(new DockLayout<Object>(factoryId, data));
                    info.setPlaceholder(placeholder);
                }
            }
            if (info == null) {
                info = new DockLayoutInfo(entry);
                info.setPlaceholder(placeholder);
            }
        } else {
            Object data = factory.read(entryIn, this.intermediatePlaceholders);
            if (data == null) {
                info = null;
            } else {
                info = new DockLayoutInfo(new DockLayout(factoryId, data));
                info.setPlaceholder(placeholder);
            }
            entryIn.close();
        }
        return info;
    }

    private DataInputStream readBuffer(DataInputStream in, int count) throws IOException {
        int input;
        byte[] buffer = new byte[count];
        for (int read = 0; read < count; read += input) {
            input = in.read(buffer, read, count - read);
            if (input >= 0) continue;
            throw new EOFException();
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(buffer);
        DataInputStream din = new DataInputStream(bin);
        return din;
    }

    private byte[] readBuffer(DataInputStream in) throws IOException {
        String factory = in.readUTF();
        int count = in.readInt();
        ByteArrayOutputStream out = new ByteArrayOutputStream(factory.length() * 4 + 4 + count);
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeUTF(factory);
        dout.writeInt(count);
        for (int i = 0; i < count; ++i) {
            int read = in.read();
            if (read == -1) {
                throw new EOFException("unexpectetly reached end of file");
            }
            dout.write(read);
        }
        dout.close();
        return out.toByteArray();
    }

    public byte[] write(Map<String, DockStation> stations) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bytes);
        this.write(stations, out);
        out.close();
        return bytes.toByteArray();
    }

    public void write(Map<String, DockStation> stations, DataOutputStream out) throws IOException {
        HashMap<String, DockLayoutComposition> map = new HashMap<String, DockLayoutComposition>();
        for (Map.Entry<String, DockStation> entry : stations.entrySet()) {
            DockLayoutComposition composition = this.convert(entry.getValue());
            if (composition == null) continue;
            map.put(entry.getKey(), composition);
        }
        this.writeCompositions(map, out);
    }

    public void writeCompositions(Map<String, DockLayoutComposition> stations, DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_4);
        out.writeInt(stations.size());
        for (Map.Entry<String, DockLayoutComposition> entry : stations.entrySet()) {
            out.writeUTF(entry.getKey());
            this.writeComposition(entry.getValue(), out);
        }
    }

    public Map<String, DockStation> read(byte[] data) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        Map<String, DockStation> result = this.read(in);
        in.close();
        return result;
    }

    public Map<String, DockStation> read(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        int count = in.readInt();
        HashMap<String, DockStation> result = new HashMap<String, DockStation>();
        for (int i = 0; i < count; ++i) {
            DockStation station;
            String key = in.readUTF();
            DockLayoutComposition composition = this.readComposition(in);
            DockElement element = composition == null ? null : this.convert(composition);
            DockStation dockStation = station = element == null ? null : element.asDockStation();
            if (station == null) continue;
            result.put(key, station);
        }
        return result;
    }

    public Map<String, DockLayoutComposition> readCompositions(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        int count = in.readInt();
        HashMap<String, DockLayoutComposition> result = new HashMap<String, DockLayoutComposition>();
        for (int i = 0; i < count; ++i) {
            String key = in.readUTF();
            DockLayoutComposition composition = this.readComposition(in);
            if (composition == null) continue;
            result.put(key, composition);
        }
        return result;
    }

    public void writeCompositionXML(DockLayoutComposition composition, XElement element) {
        DockLayoutInfo info = composition.getLayout();
        if (info.getKind() == DockLayoutInfo.Data.XML) {
            element.addElement(info.getDataXML());
        } else if (info.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
            DockLayout<?> layout = info.getDataLayout();
            DockFactory<DockElement, ?, ?> factory = this.getFactory(layout.getFactoryID());
            if (factory == null) {
                throw new IllegalArgumentException("Missing factory: " + layout.getFactoryID());
            }
            XElement xfactory = element.addElement("layout");
            xfactory.addString("factory", this.getID(factory));
            Path placeholder = info.getPlaceholder();
            if (placeholder != null) {
                xfactory.addString("placeholder", placeholder.toString());
            }
            factory.write(layout.getData(), xfactory);
        } else {
            throw new IllegalArgumentException("Cannot store layout as XML: it was never translated and its raw format is not XML");
        }
        List<DockLayout<?>> adjacentLayouts = composition.getAdjacent();
        if (adjacentLayouts != null) {
            XElement xadjacent = element.addElement("adjacent");
            for (DockLayout<?> adjacentLayout : adjacentLayouts) {
                AdjacentDockFactory<?> adjacentFactory = this.getAdjacentFactory(adjacentLayout.getFactoryID());
                if (adjacentFactory == null) {
                    throw new IllegalArgumentException("Missing adjacent factory: " + adjacentLayout.getFactoryID());
                }
                XElement xlayout = xadjacent.addElement("layout");
                xlayout.addString("factory", this.getAdjacentID(adjacentFactory));
                adjacentFactory.write(adjacentLayout.getData(), xlayout);
            }
        }
        XElement xchildren = element.addElement("children");
        xchildren.addBoolean("ignore", composition.isIgnoreChildren());
        for (DockLayoutComposition child : composition.getChildren()) {
            XElement xchild = xchildren.addElement("child");
            this.writeCompositionXML(child, xchild);
        }
    }

    public DockLayoutComposition readCompositionXML(XElement element) {
        XElement xfactory = element.getElement("layout");
        DockLayoutInfo layout = this.readEntry(xfactory);
        XElement xadjacent = element.getElement("adjacent");
        ArrayList adjacentLayouts = null;
        if (xadjacent != null) {
            adjacentLayouts = new ArrayList();
            for (XElement xlayout : xadjacent.getElements("layout")) {
                Object data;
                String factoryId = xlayout.getString("factory");
                AdjacentDockFactory<?> adjacentFactory = this.getAdjacentFactory(factoryId);
                if (adjacentFactory != null) {
                    data = adjacentFactory.read(xlayout, this.intermediatePlaceholders);
                    if (data == null) continue;
                    adjacentLayouts.add(new DockLayout(factoryId, data));
                    continue;
                }
                if (this.missingAdjacent == null || (data = this.missingAdjacent.readXML(this.getAdjacentFactoryID(factoryId), xlayout)) == null) continue;
                adjacentLayouts.add(new DockLayout(factoryId, data));
            }
        }
        XElement xchildren = element.getElement("children");
        boolean ignore = true;
        ArrayList<DockLayoutComposition> children = new ArrayList<DockLayoutComposition>();
        if (xchildren != null) {
            ignore = xchildren.getBoolean("ignore");
            for (XElement xchild : xchildren.getElements("child")) {
                children.add(this.readCompositionXML(xchild));
            }
        }
        return new DockLayoutComposition(layout, adjacentLayouts, children, ignore);
    }

    private DockLayoutInfo readEntry(XElement element) {
        DockLayoutInfo layout = null;
        if (element != null) {
            DockFactory<DockElement, ?, ?> factory;
            String factoryId = element.getString("factory");
            Path placeholder = null;
            XAttribute xplaceholder = element.getAttribute("placeholder");
            if (xplaceholder != null) {
                placeholder = new Path(xplaceholder.getString());
            }
            if ((factory = this.getFactory(factoryId)) != null) {
                Object data = factory.read(element, this.intermediatePlaceholders);
                if (data != null) {
                    layout = new DockLayoutInfo(new DockLayout(factoryId, data));
                    layout.setPlaceholder(placeholder);
                }
            } else {
                Object data;
                layout = null;
                if (this.missingFactory != null && (data = this.missingFactory.readXML(this.getFactoryID(factoryId), element)) != null) {
                    layout = new DockLayoutInfo(new DockLayout<Object>(factoryId, data));
                    layout.setPlaceholder(placeholder);
                }
                if (layout == null) {
                    layout = new DockLayoutInfo(element);
                    layout.setPlaceholder(placeholder);
                }
            }
        }
        return layout;
    }

    public void writeXML(Map<String, DockStation> stations, XElement element) {
        HashMap<String, DockLayoutComposition> map = new HashMap<String, DockLayoutComposition>();
        for (Map.Entry<String, DockStation> entry : stations.entrySet()) {
            DockLayoutComposition composition = this.convert(entry.getValue());
            if (composition == null) continue;
            map.put(entry.getKey(), composition);
        }
        this.writeCompositionsXML(map, element);
    }

    public void writeCompositionsXML(Map<String, DockLayoutComposition> stations, XElement element) {
        for (Map.Entry<String, DockLayoutComposition> entry : stations.entrySet()) {
            XElement xchild = element.addElement("element");
            xchild.addString("name", entry.getKey());
            this.writeCompositionXML(entry.getValue(), xchild);
        }
    }

    public Map<String, DockStation> readXML(XElement root) {
        HashMap<String, DockStation> result = new HashMap<String, DockStation>();
        for (XElement xelement : root.getElements("element")) {
            DockStation station;
            String name = xelement.getString("name");
            DockLayoutComposition composition = this.readCompositionXML(xelement);
            DockElement element = composition == null ? null : this.convert(composition);
            DockStation dockStation = station = element == null ? null : element.asDockStation();
            if (station == null) continue;
            result.put(name, station);
        }
        return result;
    }

    public Map<String, DockLayoutComposition> readCompositionsXML(XElement root) {
        HashMap<String, DockLayoutComposition> result = new HashMap<String, DockLayoutComposition>();
        for (XElement xelement : root.getElements("element")) {
            String name = xelement.getString("name");
            DockLayoutComposition composition = this.readCompositionXML(xelement);
            if (composition == null) continue;
            result.put(name, composition);
        }
        return result;
    }

    public DockLayoutComposition fillMissing(DockLayoutComposition composition) throws IOException, XException {
        ArrayList<DockLayoutComposition> newChildren;
        DockLayoutInfo info;
        DockLayoutInfo original = info = composition.getLayout();
        if (info.getKind() == DockLayoutInfo.Data.BYTE) {
            if ((info = this.readEntry(info.getDataByte(), info.getPlaceholder())) != null && info.getKind() == DockLayoutInfo.Data.BYTE) {
                info = original;
            }
        } else if (info.getKind() == DockLayoutInfo.Data.XML && (info = this.readEntry(info.getDataXML())) != null && info.getKind() == DockLayoutInfo.Data.XML) {
            info = original;
        }
        if (info.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
            info = this.fillMissing(info);
        }
        boolean createNew = info != original;
        List<DockLayoutComposition> children = composition.getChildren();
        if (children != null) {
            newChildren = new ArrayList<DockLayoutComposition>(children.size());
            for (DockLayoutComposition child : children) {
                DockLayoutComposition filled = this.fillMissing(child);
                newChildren.add(filled);
                if (child == filled) continue;
                createNew = true;
            }
        } else {
            newChildren = null;
        }
        if (info != null && info != original) {
            info.setLocation(original.getLocation());
        }
        if (createNew) {
            return new DockLayoutComposition(info, composition.getAdjacent(), newChildren, composition.isIgnoreChildren());
        }
        return composition;
    }

    protected DockLayoutInfo fillMissing(DockLayoutInfo info) {
        return info;
    }

    public void estimateLocations(DockLayoutComposition composition) {
        this.estimateLocations(composition, composition.getLayout().getLocation());
    }

    public void estimateLocations(DockLayoutComposition composition, DockableProperty location) {
        DefaultLocationEstimationMap map = new DefaultLocationEstimationMap(composition);
        this.estimateLocations(map);
        if (location != null) {
            this.appendFirstOnEstimate(composition, location);
        }
    }

    private void appendFirstOnEstimate(DockLayoutComposition composition, DockableProperty location) {
        DockLayoutInfo info = composition.getLayout();
        DockableProperty property = info.getLocation();
        if (property != null) {
            info.setLocation(DockUtilities.append(property, location));
        }
        for (DockLayoutComposition child : composition.getChildren()) {
            this.appendFirstOnEstimate(child, location);
        }
    }

    protected void estimateLocations(DefaultLocationEstimationMap map) {
        DockLayoutComposition composition = map.getRoot();
        List<DockLayoutComposition> children = composition.getChildren();
        if (children == null || children.size() == 0) {
            return;
        }
        DockLayout<?> layout = composition.getLayout().getDataLayout();
        if (layout == null) {
            return;
        }
        DockFactory<DockElement, ?, ?> factory = this.getFactory(layout.getFactoryID());
        if (factory == null) {
            return;
        }
        int n = map.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.estimateLocations(map.subMap(i));
        }
        map.prepare();
        factory.estimateLocations(layout.getData(), map);
        map.finish();
    }

    protected boolean ignoreElement(DockElement element) {
        if (this.ignore == null) {
            return false;
        }
        return this.ignore.ignoreElement(element);
    }

    protected boolean ignoreChildren(DockStation station) {
        if (this.ignore == null) {
            return false;
        }
        return this.ignore.ignoreChildren(station);
    }

    protected String getID(PerspectiveElement element) {
        return element.getFactoryID();
    }

    protected String getID(DockElement element) {
        return element.getFactoryID();
    }

    protected String getID(DockFactory<?, ?, ?> factory) {
        return factory.getID();
    }

    protected String getFactoryID(DockLayoutInfo info) {
        if (info.getKind() == DockLayoutInfo.Data.BYTE) {
            try {
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(info.getDataByte()));
                String result = in.readUTF();
                in.close();
                return result;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("byte entry not in the correct format", ex);
            }
        }
        if (info.getKind() == DockLayoutInfo.Data.XML) {
            return info.getDataXML().getString("factory");
        }
        if (info.getKind() == DockLayoutInfo.Data.DOCK_LAYOUT) {
            return info.getDataLayout().getFactoryID();
        }
        return null;
    }

    public String convertFactoryId(DockFactory<?, ?, ?> factory) {
        return this.getID(factory);
    }

    public String convertFactoryId(String id) {
        return this.getFactoryID(id);
    }

    protected String getFactoryID(String id) {
        return id;
    }

    protected String getAdjacentID(AdjacentDockFactory<?> factory) {
        return factory.getID();
    }

    protected String getAdjacentFactoryID(String id) {
        return id;
    }

    public DockFactory<? extends DockElement, ?, ?> getFactory(String id) {
        DockFactory<?, ?, ?> result = this.factories.get(id);
        if (result == null) {
            String base = null;
            if (id.startsWith("delegate_secure ")) {
                base = id.substring("delegate_secure ".length());
                id = "delegate_" + base;
            } else if (id.startsWith("secure ")) {
                id = base = id.substring("secure ".length());
            }
            if ("flap dock".equals(base) || "screen dock".equals(base) || "StackDockStationFactory".equals(base) || "SplitDockStationFactory".equals(base)) {
                result = this.factories.get(id);
            }
        }
        return result;
    }

    public AdjacentDockFactory<?> getAdjacentFactory(String id) {
        return this.adjacent.get(id);
    }

    public Map<String, AdjacentDockFactory<?>> getAdjacentFactorys() {
        return Collections.unmodifiableMap(this.adjacent);
    }

    public String getIdentifier(DockLayoutComposition composition) {
        return null;
    }
}

